/*
 * Decompiled with CFR 0.152.
 */
package omeroconnect;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import loci.common.DataTools;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;

public class OPTDataEntry {
    public List<ImageCoreMetadata> metadata_allscans = new ArrayList<ImageCoreMetadata>();
    public File fileobj;
    public String scanID;
    public File scanMetafile;
    public File scanProjMetafile;
    public List<File> scanProjChannelDirNames = new ArrayList<File>();
    public File scanReconMetafile;
    public List<File> scanReconChannelDirNames = new ArrayList<File>();
    public IFormatReader imgplanereader;

    OPTDataEntry(File datadir) throws Exception {
        this.fileobj = datadir;
        this.scanID = this.fileobj.getName();
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        this.imgplanereader = new ImageReader(defaultClasses);
        this.imgplanereader.setMetadataCollected(false);
        this.imgplanereader.setOriginalMetadataPopulated(false);
        this.imgplanereader.setMetadataFiltered(false);
        this.imgplanereader.setMetadataStore((MetadataStore)meta);
        this.readFolderStructure();
        this.readImageMetadata();
        this.print();
    }

    public void readFolderStructure() throws Exception {
        File[] files = this.fileobj.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.scanProjChannelDirNames.add(file);
                File[] subfiles = file.listFiles();
                for (int j = 0; j < subfiles.length; ++j) {
                    File subfile = subfiles[j];
                    if (subfile.isDirectory()) {
                        this.scanReconChannelDirNames.add(subfile);
                        File[] subsubfiles = subfile.listFiles();
                        for (int k = 0; k < subsubfiles.length; ++k) {
                            File subsubfile = subsubfiles[k];
                            if (!subsubfile.getName().endsWith(".log")) continue;
                            this.scanReconMetafile = subsubfile;
                        }
                    }
                    if (!subfile.getName().endsWith(".log")) continue;
                    this.scanProjMetafile = subfile;
                }
            }
            if (!file.getName().endsWith(".txt")) continue;
            this.scanMetafile = file;
        }
    }

    public byte[] getImageBytes(File file, byte[] imgbytes) throws Exception {
        this.imgplanereader.setId(file.getAbsolutePath());
        int pixelType = this.imgplanereader.getPixelType();
        int bytesPerPixel = this.getBytesPerPixel(pixelType);
        imgbytes = this.imgplanereader.openBytes(0, imgbytes);
        if (this.imgplanereader.isLittleEndian() && bytesPerPixel != 1) {
            ByteBuffer buffer = ByteBuffer.wrap(imgbytes);
            if (bytesPerPixel == 2) {
                ShortBuffer buf = buffer.asShortBuffer();
                int length = buffer.capacity() / 2;
                for (int i = 0; i < length; ++i) {
                    short x = buf.get(i);
                    buf.put(i, (short)(x << 8 | x >> 8 & 0xFF));
                }
            } else if (bytesPerPixel == 4) {
                IntBuffer buf = buffer.asIntBuffer();
                int length = buffer.capacity() / 4;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((int)buf.get(i)));
                }
            } else if (bytesPerPixel == 8) {
                LongBuffer buf = buffer.asLongBuffer();
                int length = buffer.capacity() / 8;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((long)buf.get(i)));
                }
            }
            imgbytes = buffer.array();
            buffer.clear();
        }
        this.imgplanereader.close();
        return imgbytes;
    }

    public void readImageMetadata() throws Exception {
        ImageCoreMetadata currentscan_meta;
        float pixsize;
        ImageReader myimagereader;
        ClassList defaultClasses;
        File f;
        File[] channelfiles;
        int zsize;
        boolean foundimg;
        File imgfile;
        File channeldir;
        String channelpath;
        if (!this.scanProjChannelDirNames.isEmpty()) {
            channelpath = this.fileobj.getAbsolutePath() + "\\" + this.scanProjChannelDirNames.get(0).getName();
            System.out.println("channelpath: " + channelpath);
            channeldir = new File(channelpath);
            imgfile = null;
            foundimg = false;
            zsize = 0;
            channelfiles = channeldir.listFiles();
            System.out.println("channelfiles.length: " + channelfiles.length);
            for (int i = 0; i < channelfiles.length; ++i) {
                f = channelfiles[i];
                if (!f.getName().contains("tif")) continue;
                imgfile = new File(f.getAbsolutePath());
                ++zsize;
            }
            IMetadata meta = MetadataTools.createOMEXMLMetadata();
            defaultClasses = new ClassList("readers.txt", IFormatReader.class);
            myimagereader = new ImageReader(defaultClasses);
            myimagereader.setMetadataCollected(false);
            myimagereader.setOriginalMetadataPopulated(false);
            myimagereader.setMetadataFiltered(false);
            myimagereader.setMetadataStore((MetadataStore)meta);
            myimagereader = new ChannelSeparator((IFormatReader)myimagereader);
            myimagereader.setId(imgfile.getAbsolutePath());
            pixsize = this.readLogFilePixelSize(this.scanProjMetafile);
            currentscan_meta = new ImageCoreMetadata();
            currentscan_meta.scan_name = this.scanID + "_Projection";
            currentscan_meta.x = myimagereader.getSizeX();
            currentscan_meta.y = myimagereader.getSizeY();
            currentscan_meta.z = zsize;
            currentscan_meta.c = this.scanProjChannelDirNames.size();
            currentscan_meta.t = 1;
            currentscan_meta.bpp = this.getBytesPerPixel(myimagereader.getPixelType());
            currentscan_meta.physicalX = pixsize;
            currentscan_meta.physicalY = pixsize;
            currentscan_meta.physicalZ = 0.0f;
            currentscan_meta.pixelType = FormatTools.getPixelTypeString((int)myimagereader.getPixelType());
            currentscan_meta.print();
            this.metadata_allscans.add(currentscan_meta);
            myimagereader.close();
        }
        if (!this.scanReconChannelDirNames.isEmpty()) {
            channelpath = this.fileobj.getAbsolutePath() + "\\" + this.scanProjChannelDirNames.get(0).getName() + "\\" + this.scanReconChannelDirNames.get(0).getName();
            channeldir = new File(channelpath);
            imgfile = null;
            foundimg = false;
            zsize = 0;
            channelfiles = channeldir.listFiles();
            for (int i = 0; i < channelfiles.length; ++i) {
                f = channelfiles[i];
                if (f.getName().contains("tif")) {
                    imgfile = new File(f.getAbsolutePath());
                    ++zsize;
                    continue;
                }
                if (!f.getName().contains("bmp")) continue;
                imgfile = new File(f.getAbsolutePath());
                ++zsize;
            }
            IMetadata meta = MetadataTools.createOMEXMLMetadata();
            defaultClasses = new ClassList("readers.txt", IFormatReader.class);
            myimagereader = new ImageReader(defaultClasses);
            myimagereader.setMetadataCollected(false);
            myimagereader.setOriginalMetadataPopulated(false);
            myimagereader.setMetadataFiltered(false);
            myimagereader.setMetadataStore((MetadataStore)meta);
            myimagereader = new ChannelSeparator((IFormatReader)myimagereader);
            myimagereader.setId(imgfile.getAbsolutePath());
            pixsize = this.readLogFilePixelSize(this.scanProjMetafile);
            currentscan_meta = new ImageCoreMetadata();
            currentscan_meta.scan_name = this.scanID + "_Reconstruction";
            currentscan_meta.x = myimagereader.getSizeX();
            currentscan_meta.y = myimagereader.getSizeY();
            currentscan_meta.z = zsize;
            currentscan_meta.c = this.scanProjChannelDirNames.size();
            currentscan_meta.t = 1;
            currentscan_meta.bpp = this.getBytesPerPixel(myimagereader.getPixelType());
            currentscan_meta.physicalX = pixsize;
            currentscan_meta.physicalY = pixsize;
            currentscan_meta.physicalZ = pixsize;
            currentscan_meta.pixelType = FormatTools.getPixelTypeString((int)myimagereader.getPixelType());
            currentscan_meta.print();
            this.metadata_allscans.add(currentscan_meta);
            myimagereader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readLogFilePixelSize(File file) {
        float scale = 0.0f;
        String filecontents = new String();
        filecontents = "";
        try {
            BufferedReader input = new BufferedReader(new FileReader(file));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    filecontents = filecontents + "\r\n" + line;
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            System.out.println("ERROR: Settings.txt file could not be found!");
        }
        StringTokenizer st = new StringTokenizer(filecontents, "=\r\n", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equals("Pixel Size (um)")) continue;
            token = st.nextToken();
            scale = Float.parseFloat(token);
        }
        return scale;
    }

    public int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        return -1;
    }

    public void print() {
        int i;
        System.out.println("---------------------------------------------------------");
        System.out.println("fileobj: " + this.fileobj.getAbsolutePath());
        System.out.println("scanID: " + this.scanID);
        System.out.println("scanMetafile: " + this.scanMetafile.getName());
        System.out.println("---------------------------------------------------------");
        System.out.println("PROJECTIONS:");
        System.out.println("scanProjMetafile: " + this.scanProjMetafile.getName());
        System.out.println("Channels:");
        for (i = 0; i < this.scanProjChannelDirNames.size(); ++i) {
            System.out.print(this.scanProjChannelDirNames.get(i).getName() + "\t");
        }
        System.out.println("\n---------------------------------------------------------");
        System.out.println("RECONSTRUNCTIONS:");
        System.out.println("scanReconMetafile: " + this.scanReconMetafile.getName());
        System.out.println("Channels:");
        for (i = 0; i < this.scanReconChannelDirNames.size(); ++i) {
            System.out.print(this.scanReconChannelDirNames.get(i).getName() + "\t");
        }
        System.out.println("\n---------------------------------------------------------");
    }

    public static class ImageCoreMetadata {
        public String scan_name = "";
        public int x = 0;
        public int y = 0;
        public int z = 0;
        public int c = 0;
        public int t = 0;
        public int bpp;
        public float physicalX = 0.0f;
        public float physicalY = 0.0f;
        public float physicalZ = 0.0f;
        public String pixelType = "";

        ImageCoreMetadata() {
        }

        public void print() {
            System.out.println("scan_name: " + this.scan_name);
            System.out.println("x: " + this.x);
            System.out.println("y: " + this.y);
            System.out.println("z: " + this.z);
            System.out.println("c: " + this.c);
            System.out.println("t: " + this.t);
            System.out.println("physicalX: " + this.physicalX);
            System.out.println("physicalY: " + this.physicalY);
            System.out.println("physicalZ: " + this.physicalZ);
            System.out.println("pixelType: " + this.pixelType);
        }
    }
}

