/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.RandomAccessInputStream;

public class SDTInfo {
    public static final short BH_HEADER_CHKSUM = 21930;
    public static final short BH_HEADER_NOT_VALID = 4369;
    public static final short BH_HEADER_VALID = 21845;
    public static final String SETUP_IDENTIFIER = "\u0004SPC Setup Script File\u0004";
    public static final String DATA_IDENTIFIER = "\u0004SPC Setup & Data File\u0004";
    public static final String FLOW_DATA_IDENTIFIER = "\u0004SPC Flow Data File\u0004";
    public static final String DLL_DATA_IDENTIFIER = "\u0004SPC DLL Data File\u0004";
    public static final String FCS_DATA_IDENTIFIER = "\u0004SPC FCS Data File\u0004";
    public static final String X_STRING = "#SP [SP_SCAN_X,I,";
    public static final String Y_STRING = "#SP [SP_SCAN_Y,I,";
    public static final String T_STRING = "#SP [SP_ADC_RE,I,";
    public static final String C_STRING = "#SP [SP_SCAN_RX,I,";
    public int width;
    public int height;
    public int timeBins;
    public int channels;
    public short revision;
    public int infoOffs;
    public short infoLength;
    public int setupOffs;
    public short setupLength;
    public int dataBlockOffs;
    public short noOfDataBlocks;
    public int dataBlockLength;
    public int measDescBlockOffs;
    public short noOfMeasDescBlocks;
    public short measDescBlockLength;
    public int headerValid;
    public long reserved1;
    public int reserved2;
    public int chksum;
    public String info;
    public String setup;
    public boolean hasMeasureInfo;
    public String time;
    public String date;
    public String modSerNo;
    public short measMode;
    public float cfdLL;
    public float cfdLH;
    public float cfdZC;
    public float cfdHF;
    public float synZC;
    public short synFD;
    public float synHF;
    public float tacR;
    public short tacG;
    public float tacOF;
    public float tacLL;
    public float tacLH;
    public short adcRE;
    public short ealDE;
    public short ncx;
    public short ncy;
    public int page;
    public float colT;
    public float repT;
    public short stopt;
    public int overfl;
    public short useMotor;
    public int steps;
    public float offset;
    public short dither;
    public short incr;
    public short memBank;
    public String modType;
    public float synTH;
    public short deadTimeComp;
    public short polarityL;
    public short polarityF;
    public short polarityP;
    public short linediv;
    public short accumulate;
    public int flbckY;
    public int flbckX;
    public int bordU;
    public int bordL;
    public float pixTime;
    public short pixClk;
    public short trigger;
    public int scanX;
    public int scanY;
    public int scanRX;
    public int scanRY;
    public short fifoTyp;
    public int epxDiv;
    public int modTypeCode;
    public int modFpgaVer;
    public float overflowCorrFactor;
    public int adcZoom;
    public int cycles;
    public boolean hasMeasStopInfo;
    public int status;
    public int flags;
    public float stopTime;
    public int curStep;
    public int curCycle;
    public int curPage;
    public float minSyncRate;
    public float minCfdRate;
    public float minTacRate;
    public float minAdcRate;
    public float maxSyncRate;
    public float maxCfdRate;
    public float maxTacRate;
    public float maxAdcRate;
    public int mReserved1;
    public float mReserved2;
    public boolean hasMeasFCSInfo;
    public int chan;
    public int fcsDecayCalc;
    public long mtResol;
    public float cortime;
    public long calcPhotons;
    public int fcsPoints;
    public float endTime;
    public int overruns;
    public int fcsType;
    public int crossChan;
    public int mod;
    public int crossMod;
    public long crossMtResol;
    public boolean hasExtendedMeasureInfo;
    public int imageX;
    public int imageY;
    public int imageRX;
    public int imageRY;
    public short xyGain;
    public short masterClock;
    public short adcDE;
    public short detType;
    public short xAxis;
    public boolean hasMeasHISTInfo;
    public float fidaTime;
    public float fildaTime;
    public int fidaPoints;
    public int fildaPoints;
    public float mcsTime;
    public int mcsPoints;
    public short blockNo;
    public int dataOffs;
    public int nextBlockOffs;
    public int blockType;
    public short measDescBlockNo;
    public long lblockNo;
    public long blockLength;

    public SDTInfo(RandomAccessInputStream in, Hashtable meta) throws IOException {
        String token;
        this.revision = in.readShort();
        this.infoOffs = in.readInt();
        this.infoLength = in.readShort();
        this.setupOffs = in.readInt();
        this.setupLength = in.readShort();
        this.dataBlockOffs = in.readInt();
        this.noOfDataBlocks = in.readShort();
        this.dataBlockLength = in.readInt();
        this.measDescBlockOffs = in.readInt();
        this.noOfMeasDescBlocks = in.readShort();
        this.measDescBlockLength = in.readShort();
        this.headerValid = in.readUnsignedShort();
        this.reserved1 = 0xFFFFFFFFL & (long)in.readInt();
        this.reserved2 = in.readUnsignedShort();
        this.chksum = in.readUnsignedShort();
        if (meta != null) {
            String bhfileHeader = "bhfileHeader.";
            meta.put("bhfileHeader.revision", new Short(this.revision));
            meta.put("bhfileHeader.infoOffs", new Integer(this.infoOffs));
            meta.put("bhfileHeader.infoLength", new Short(this.infoLength));
            meta.put("bhfileHeader.setupOffs", new Integer(this.setupOffs));
            meta.put("bhfileHeader.dataBlockOffs", new Integer(this.dataBlockOffs));
            meta.put("bhfileHeader.noOfDataBlocks", new Short(this.noOfDataBlocks));
            meta.put("bhfileHeader.dataBlockLength", new Integer(this.dataBlockLength));
            meta.put("bhfileHeader.measDescBlockOffs", new Integer(this.measDescBlockOffs));
            meta.put("bhfileHeader.noOfMeasDescBlocks", new Short(this.noOfMeasDescBlocks));
            meta.put("bhfileHeader.measDescBlockLength", new Integer(this.measDescBlockLength));
            meta.put("bhfileHeader.headerValid", new Integer(this.headerValid));
            meta.put("bhfileHeader.reserved1", new Long(this.reserved1));
            meta.put("bhfileHeader.reserved2", new Integer(this.reserved2));
            meta.put("bhfileHeader.chksum", new Integer(this.chksum));
        }
        in.seek(this.infoOffs);
        byte[] infoBytes = new byte[this.infoLength];
        in.readFully(infoBytes);
        this.info = new String(infoBytes);
        StringTokenizer st = new StringTokenizer(this.info, "\n");
        int count = st.countTokens();
        st.nextToken();
        String key = null;
        String value = null;
        for (int i = 1; i < count - 1; ++i) {
            token = st.nextToken().trim();
            if (token.indexOf(":") == -1) continue;
            key = token.substring(0, token.indexOf(":")).trim();
            value = token.substring(token.indexOf(":") + 1).trim();
            meta.put(key, value);
        }
        in.seek(this.setupOffs);
        byte[] setupBytes = new byte[this.setupLength];
        in.readFully(setupBytes);
        this.setup = new String(setupBytes);
        st = new StringTokenizer(this.setup, "\n");
        while (st.hasMoreTokens()) {
            int end;
            int ndx;
            token = st.nextToken().trim();
            if (token.startsWith("#SP") || token.startsWith("#DI") || token.startsWith("#PR") || token.startsWith("#MP")) {
                int open = token.indexOf("[");
                key = token.substring(open + 1, token.indexOf(",", open));
                value = token.substring(token.lastIndexOf(",") + 1, token.length() - 1);
            } else if (token.startsWith("#TR") || token.startsWith("#WI")) {
                key = token.substring(0, token.indexOf("[")).trim();
                value = token.substring(token.indexOf("[") + 1, token.indexOf("]"));
            }
            if (key != null && value != null) {
                meta.put(key, value);
            }
            if (token.indexOf(X_STRING) != -1) {
                ndx = token.indexOf(X_STRING) + X_STRING.length();
                end = token.indexOf("]", ndx);
                this.width = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(Y_STRING) != -1) {
                ndx = token.indexOf(Y_STRING) + Y_STRING.length();
                end = token.indexOf("]", ndx);
                this.height = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(T_STRING) != -1) {
                ndx = token.indexOf(T_STRING) + T_STRING.length();
                end = token.indexOf("]", ndx);
                this.timeBins = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(C_STRING) == -1) continue;
            ndx = token.indexOf(C_STRING) + C_STRING.length();
            end = token.indexOf("]", ndx);
            this.channels = Integer.parseInt(token.substring(ndx, end));
        }
        if (this.noOfMeasDescBlocks > 0) {
            in.seek(this.measDescBlockOffs);
            this.hasMeasureInfo = this.measDescBlockLength >= 211;
            this.hasMeasStopInfo = this.measDescBlockLength >= 271;
            this.hasMeasFCSInfo = this.measDescBlockLength >= 309;
            this.hasExtendedMeasureInfo = this.measDescBlockLength >= 335;
            boolean bl = this.hasMeasHISTInfo = this.measDescBlockLength >= 359;
            if (this.hasMeasureInfo) {
                byte[] timeBytes = new byte[9];
                in.readFully(timeBytes);
                this.time = new String(timeBytes);
                byte[] dateBytes = new byte[11];
                in.readFully(dateBytes);
                this.date = new String(dateBytes);
                byte[] modSerNoBytes = new byte[16];
                in.readFully(modSerNoBytes);
                this.modSerNo = new String(modSerNoBytes);
                this.measMode = in.readShort();
                this.cfdLL = in.readFloat();
                this.cfdLH = in.readFloat();
                this.cfdZC = in.readFloat();
                this.cfdHF = in.readFloat();
                this.synZC = in.readFloat();
                this.synFD = in.readShort();
                this.synHF = in.readFloat();
                this.tacR = in.readFloat();
                this.tacG = in.readShort();
                this.tacOF = in.readFloat();
                this.tacLL = in.readFloat();
                this.tacLH = in.readFloat();
                this.adcRE = in.readShort();
                this.ealDE = in.readShort();
                this.ncx = in.readShort();
                this.ncy = in.readShort();
                this.page = in.readUnsignedShort();
                this.colT = in.readFloat();
                this.repT = in.readFloat();
                this.stopt = in.readShort();
                this.overfl = in.readUnsignedByte();
                this.useMotor = in.readShort();
                this.steps = in.readUnsignedShort();
                this.offset = in.readFloat();
                this.dither = in.readShort();
                this.incr = in.readShort();
                this.memBank = in.readShort();
                byte[] modTypeBytes = new byte[16];
                in.readFully(modTypeBytes);
                this.modType = new String(modTypeBytes);
                this.synTH = in.readFloat();
                this.deadTimeComp = in.readShort();
                this.polarityL = in.readShort();
                this.polarityF = in.readShort();
                this.polarityP = in.readShort();
                this.linediv = in.readShort();
                this.accumulate = in.readShort();
                this.flbckY = in.readInt();
                this.flbckX = in.readInt();
                this.bordU = in.readInt();
                this.bordL = in.readInt();
                this.pixTime = in.readFloat();
                this.pixClk = in.readShort();
                this.trigger = in.readShort();
                this.scanX = in.readInt();
                this.scanY = in.readInt();
                this.scanRX = in.readInt();
                this.scanRY = in.readInt();
                this.fifoTyp = in.readShort();
                this.epxDiv = in.readInt();
                this.modTypeCode = in.readUnsignedShort();
                this.modFpgaVer = in.readUnsignedShort();
                this.overflowCorrFactor = in.readFloat();
                this.adcZoom = in.readInt();
                this.cycles = in.readInt();
                if (meta != null) {
                    String measureInfo = "MeasureInfo.";
                    meta.put("MeasureInfo.time", this.time);
                    meta.put("MeasureInfo.date", this.date);
                    meta.put("MeasureInfo.modSerNo", this.modSerNo);
                    meta.put("MeasureInfo.measMode", new Short(this.measMode));
                    meta.put("MeasureInfo.cfdLL", new Float(this.cfdLL));
                    meta.put("MeasureInfo.cfdLH", new Float(this.cfdLH));
                    meta.put("MeasureInfo.cfdZC", new Float(this.cfdZC));
                    meta.put("MeasureInfo.cfdHF", new Float(this.cfdHF));
                    meta.put("MeasureInfo.synZC", new Float(this.synZC));
                    meta.put("MeasureInfo.synFD", new Short(this.synFD));
                    meta.put("MeasureInfo.synHF", new Float(this.synHF));
                    meta.put("MeasureInfo.tacR", new Float(this.tacR));
                    meta.put("MeasureInfo.tacG", new Short(this.tacG));
                    meta.put("MeasureInfo.tacOF", new Float(this.tacOF));
                    meta.put("MeasureInfo.tacLL", new Float(this.tacLL));
                    meta.put("MeasureInfo.tacLH", new Float(this.tacLH));
                    meta.put("MeasureInfo.adcRE", new Short(this.adcRE));
                    meta.put("MeasureInfo.ealDE", new Short(this.ealDE));
                    meta.put("MeasureInfo.ncx", new Short(this.ncx));
                    meta.put("MeasureInfo.ncy", new Short(this.ncy));
                    meta.put("MeasureInfo.page", new Integer(this.page));
                    meta.put("MeasureInfo.colT", new Float(this.colT));
                    meta.put("MeasureInfo.repT", new Float(this.repT));
                    meta.put("MeasureInfo.stopt", new Short(this.stopt));
                    meta.put("MeasureInfo.overfl", new Integer(this.overfl));
                    meta.put("MeasureInfo.useMotor", new Short(this.useMotor));
                    meta.put("MeasureInfo.steps", new Integer(this.steps));
                    meta.put("MeasureInfo.offset", new Float(this.offset));
                    meta.put("MeasureInfo.dither", new Short(this.dither));
                    meta.put("MeasureInfo.incr", new Short(this.incr));
                    meta.put("MeasureInfo.memBank", new Short(this.memBank));
                    meta.put("MeasureInfo.modType", this.modType);
                    meta.put("MeasureInfo.synTH", new Float(this.synTH));
                    meta.put("MeasureInfo.deadTimeComp", new Short(this.deadTimeComp));
                    meta.put("MeasureInfo.polarityL", new Short(this.polarityL));
                    meta.put("MeasureInfo.polarityF", new Short(this.polarityF));
                    meta.put("MeasureInfo.polarityP", new Short(this.polarityP));
                    meta.put("MeasureInfo.linediv", new Short(this.linediv));
                    meta.put("MeasureInfo.accumulate", new Short(this.accumulate));
                    meta.put("MeasureInfo.flbckY", new Integer(this.flbckY));
                    meta.put("MeasureInfo.flbckX", new Integer(this.flbckX));
                    meta.put("MeasureInfo.bordU", new Integer(this.bordU));
                    meta.put("MeasureInfo.bordL", new Integer(this.bordL));
                    meta.put("MeasureInfo.pixTime", new Float(this.pixTime));
                    meta.put("MeasureInfo.pixClk", new Short(this.pixClk));
                    meta.put("MeasureInfo.trigger", new Short(this.trigger));
                    meta.put("MeasureInfo.scanX", new Integer(this.scanX));
                    meta.put("MeasureInfo.scanY", new Integer(this.scanY));
                    meta.put("MeasureInfo.scanRX", new Integer(this.scanRX));
                    meta.put("MeasureInfo.scanRY", new Integer(this.scanRY));
                    meta.put("MeasureInfo.fifoTyp", new Short(this.fifoTyp));
                    meta.put("MeasureInfo.epxDiv", new Integer(this.epxDiv));
                    meta.put("MeasureInfo.modTypeCode", new Integer(this.modTypeCode));
                    meta.put("MeasureInfo.modFpgaVer", new Integer(this.modFpgaVer));
                    meta.put("MeasureInfo.overflowCorrFactor", new Float(this.overflowCorrFactor));
                    meta.put("MeasureInfo.adcZoom", new Integer(this.adcZoom));
                    meta.put("MeasureInfo.cycles", new Integer(this.cycles));
                }
                this.width = this.scanX;
                this.height = this.scanY;
                this.timeBins = this.adcRE;
                this.channels = this.scanRX;
            }
            if (this.hasMeasStopInfo) {
                this.status = in.readUnsignedShort();
                this.flags = in.readUnsignedShort();
                this.stopTime = in.readFloat();
                this.curStep = in.readInt();
                this.curCycle = in.readInt();
                this.curPage = in.readInt();
                this.minSyncRate = in.readFloat();
                this.minCfdRate = in.readFloat();
                this.minTacRate = in.readFloat();
                this.minAdcRate = in.readFloat();
                this.maxSyncRate = in.readFloat();
                this.maxCfdRate = in.readFloat();
                this.maxTacRate = in.readFloat();
                this.maxAdcRate = in.readFloat();
                this.mReserved1 = in.readInt();
                this.mReserved2 = in.readFloat();
                if (meta != null) {
                    String measStopInfo = "MeasStopInfo.";
                    meta.put("MeasStopInfo.status", new Integer(this.status));
                    meta.put("MeasStopInfo.flags", new Integer(this.flags));
                    meta.put("MeasStopInfo.stopTime", new Float(this.stopTime));
                    meta.put("MeasStopInfo.curStep", new Integer(this.curStep));
                    meta.put("MeasStopInfo.curCycle", new Integer(this.curCycle));
                    meta.put("MeasStopInfo.curPage", new Integer(this.curPage));
                    meta.put("MeasStopInfo.minSyncRate", new Float(this.minSyncRate));
                    meta.put("MeasStopInfo.minCfdRate", new Float(this.minCfdRate));
                    meta.put("MeasStopInfo.minTacRate", new Float(this.minTacRate));
                    meta.put("MeasStopInfo.minAdcRate", new Float(this.minAdcRate));
                    meta.put("MeasStopInfo.maxSyncRate", new Float(this.maxSyncRate));
                    meta.put("MeasStopInfo.maxCfdRate", new Float(this.maxCfdRate));
                    meta.put("MeasStopInfo.maxTacRate", new Float(this.maxTacRate));
                    meta.put("MeasStopInfo.maxAdcRate", new Float(this.maxAdcRate));
                    meta.put("MeasStopInfo.reserved1", new Integer(this.mReserved1));
                    meta.put("MeasStopInfo.reserved2", new Float(this.mReserved2));
                }
            }
            if (this.hasMeasFCSInfo) {
                this.chan = in.readUnsignedShort();
                this.fcsDecayCalc = in.readUnsignedShort();
                this.mtResol = 0xFFFFFFFFL & (long)in.readInt();
                this.cortime = in.readFloat();
                this.calcPhotons = 0xFFFFFFFFL & (long)in.readInt();
                this.fcsPoints = in.readInt();
                this.endTime = in.readFloat();
                this.overruns = in.readUnsignedShort();
                this.fcsType = in.readUnsignedShort();
                this.crossChan = in.readUnsignedShort();
                this.mod = in.readUnsignedShort();
                this.crossMod = in.readUnsignedShort();
                this.crossMtResol = 0xFFFFFFFFL & (long)in.readInt();
                if (meta != null) {
                    String measFCSInfo = "MeasFCSInfo.";
                    meta.put("MeasFCSInfo.chan", new Integer(this.chan));
                    meta.put("MeasFCSInfo.fcsDecayCalc", new Integer(this.fcsDecayCalc));
                    meta.put("MeasFCSInfo.mtResol", new Long(this.mtResol));
                    meta.put("MeasFCSInfo.cortime", new Float(this.cortime));
                    meta.put("MeasFCSInfo.calcPhotons", new Long(this.calcPhotons));
                    meta.put("MeasFCSInfo.fcsPoints", new Integer(this.fcsPoints));
                    meta.put("MeasFCSInfo.endTime", new Float(this.endTime));
                    meta.put("MeasFCSInfo.overruns", new Integer(this.overruns));
                    meta.put("MeasFCSInfo.fcsType", new Integer(this.fcsType));
                    meta.put("MeasFCSInfo.crossChan", new Integer(this.crossChan));
                    meta.put("MeasFCSInfo.mod", new Integer(this.mod));
                    meta.put("MeasFCSInfo.crossMod", new Integer(this.crossMod));
                    meta.put("MeasFCSInfo.crossMtResol", new Float(this.crossMtResol));
                }
            }
            if (this.hasExtendedMeasureInfo) {
                this.imageX = in.readInt();
                this.imageY = in.readInt();
                this.imageRX = in.readInt();
                this.imageRY = in.readInt();
                this.xyGain = in.readShort();
                this.masterClock = in.readShort();
                this.adcDE = in.readShort();
                this.detType = in.readShort();
                this.xAxis = in.readShort();
                if (meta != null) {
                    String measureInfo = "MeasureInfo.";
                    meta.put("MeasureInfo.imageX", new Integer(this.imageX));
                    meta.put("MeasureInfo.imageY", new Integer(this.imageY));
                    meta.put("MeasureInfo.imageRX", new Integer(this.imageRX));
                    meta.put("MeasureInfo.imageRY", new Integer(this.imageRY));
                    meta.put("MeasureInfo.xyGain", new Short(this.xyGain));
                    meta.put("MeasureInfo.masterClock", new Short(this.masterClock));
                    meta.put("MeasureInfo.adcDE", new Short(this.adcDE));
                    meta.put("MeasureInfo.detType", new Short(this.detType));
                    meta.put("MeasureInfo.xAxis", new Short(this.xAxis));
                }
            }
            if (this.hasMeasHISTInfo) {
                this.fidaTime = in.readFloat();
                this.fildaTime = in.readFloat();
                this.fidaPoints = in.readInt();
                this.fildaPoints = in.readInt();
                this.mcsTime = in.readFloat();
                this.mcsPoints = in.readInt();
                if (meta != null) {
                    String measHISTInfo = "MeasHISTInfo.";
                    meta.put("MeasHISTInfo.fidaTime", new Float(this.fidaTime));
                    meta.put("MeasHISTInfo.fildaTime", new Float(this.fildaTime));
                    meta.put("MeasHISTInfo.fidaPoints", new Integer(this.fidaPoints));
                    meta.put("MeasHISTInfo.fildaPoints", new Integer(this.fildaPoints));
                    meta.put("MeasHISTInfo.mcsTime", new Float(this.mcsTime));
                    meta.put("MeasHISTInfo.mcsPoints", new Integer(this.mcsPoints));
                }
            }
        }
        in.seek(this.dataBlockOffs);
        this.blockNo = in.readShort();
        this.dataOffs = in.readInt();
        this.nextBlockOffs = in.readInt();
        this.blockType = in.readUnsignedShort();
        this.measDescBlockNo = in.readShort();
        this.lblockNo = 0xFFFFFFFFL & (long)in.readInt();
        this.blockLength = 0xFFFFFFFFL & (long)in.readInt();
        if (meta != null) {
            String bhFileBlockHeader = "BHFileBlockHeader.";
            meta.put("BHFileBlockHeader.blockNo", new Short(this.blockNo));
            meta.put("BHFileBlockHeader.dataOffs", new Integer(this.dataOffs));
            meta.put("BHFileBlockHeader.nextBlockOffs", new Integer(this.nextBlockOffs));
            meta.put("BHFileBlockHeader.blockType", new Integer(this.blockType));
            meta.put("BHFileBlockHeader.measDescBlockNo", new Short(this.measDescBlockNo));
            meta.put("BHFileBlockHeader.lblockNo", new Long(this.lblockNo));
            meta.put("BHFileBlockHeader.blockLength", new Long(this.blockLength));
        }
    }
}

