/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class IvisionReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private boolean color16;
    private boolean squareRoot;
    private byte[] lut;
    private long imageOffset;
    private String binX;
    private String binY;
    private String creationDate;
    private String exposureTime;
    private String gain;
    private String offset;
    private String deltaT;
    private String magnification;
    private String lensNA;
    private String refractiveIndex;
    private String wavelength;

    public IvisionReader() {
        super("IVision", "ipm");
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockCheckLen = 4;
        if (!FormatTools.validStream(stream, 4, true)) {
            return false;
        }
        String version = stream.readString(4);
        return version.equals("3.9a");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC();
        planeSize = this.color16 ? 2 * (planeSize / 3) : (this.squareRoot ? (planeSize *= 2) : (planeSize *= FormatTools.getBytesPerPixel(this.getPixelType())));
        this.in.seek(this.imageOffset + (long)(planeSize * no));
        if (this.color16) {
            throw new FormatException("16-bit color iVision files are not supported");
        }
        if (this.squareRoot) {
            throw new FormatException("Square-root iVision files are not supported");
        }
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.color16 = false;
            this.squareRoot = false;
            this.lut = null;
            this.imageOffset = 0L;
            this.binY = null;
            this.binX = null;
            this.creationDate = null;
            this.exposureTime = null;
            this.offset = null;
            this.gain = null;
            this.deltaT = null;
            this.refractiveIndex = null;
            this.lensNA = null;
            this.magnification = null;
            this.wavelength = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("IvisionReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Populating metadata");
        String version = this.in.readString(4);
        int fileFormat = this.in.read();
        int dataType = this.in.read();
        this.core[0].sizeC = 1;
        switch (dataType) {
            case 0: {
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                this.core[0].pixelType = 2;
                break;
            }
            case 2: {
                this.core[0].pixelType = 4;
                break;
            }
            case 3: {
                this.core[0].pixelType = 6;
                break;
            }
            case 4: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 3;
                this.color16 = true;
                break;
            }
            case 5: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 4;
                break;
            }
            case 6: {
                this.core[0].pixelType = 3;
                break;
            }
            case 7: {
                this.core[0].pixelType = 6;
                this.squareRoot = true;
                break;
            }
            case 8: {
                this.core[0].pixelType = 3;
                this.core[0].sizeC = 3;
            }
        }
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.in.skipBytes(6);
        this.core[0].sizeZ = this.in.readShort();
        this.in.skipBytes(50);
        this.core[0].sizeT = 1;
        if (this.getSizeX() > 1 && this.getSizeY() > 1) {
            this.lut = new byte[2048];
            this.in.read(this.lut);
        }
        this.imageOffset = this.in.getFilePointer();
        this.in.skipBytes(this.getSizeZ() * this.getSizeC() * this.getSizeT() * this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()));
        this.status("Looking for XML metadata");
        boolean xmlFound = false;
        while (!xmlFound && this.in.getFilePointer() < this.in.length() - 6L) {
            int len = (int)Math.min(8192L, this.in.length() - this.in.getFilePointer());
            String check = this.in.readString(len);
            int xmlIndex = check.indexOf("<?xml");
            boolean bl = xmlFound = xmlIndex != -1;
            if (xmlFound) {
                this.in.seek(this.in.getFilePointer() - (long)check.length() + (long)xmlIndex);
                continue;
            }
            this.in.seek(this.in.getFilePointer() - 6L);
        }
        if (xmlFound) {
            String xml = this.in.readString((int)(this.in.length() - this.in.getFilePointer())).trim();
            xml = xml.substring(0, xml.lastIndexOf(">") + 1);
            IvisionHandler handler = new IvisionHandler();
            XMLTools.parseXML(xml, (DefaultHandler)handler);
        }
        this.status("Populating core metadata");
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].littleEndian = false;
        this.core[0].interleaved = true;
        this.core[0].indexed = false;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.status("Populating MetadataStore");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        if (this.creationDate != null) {
            String date = DateTools.formatDate(this.creationDate, DATE_FORMAT);
            store.setImageCreationDate(date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        if (this.deltaT != null) {
            store.setDimensionsTimeIncrement(new Float(this.deltaT), 0, 0);
        }
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        store.setObjectiveSettingsObjective(objectiveID, 0);
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        if (this.lensNA != null) {
            store.setObjectiveLensNA(new Float(this.lensNA), 0, 0);
        }
        if (this.magnification != null) {
            store.setObjectiveNominalMagnification(new Integer(this.magnification), 0, 0);
        }
        if (this.refractiveIndex != null) {
            store.setObjectiveSettingsRefractiveIndex(new Float(this.refractiveIndex), 0);
        }
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detectorID, 0, 0);
        store.setDetectorSettingsDetector(detectorID, 0, 0);
        store.setDetectorType("Unknown", 0, 0);
        store.setDetectorSettingsBinning(this.binX + "x" + this.binY, 0, 0);
        if (this.gain != null) {
            store.setDetectorSettingsGain(new Float(this.gain), 0, 0);
        }
    }

    class IvisionHandler
    extends DefaultHandler {
        private String key;
        private String value;
        private String currentElement;

        IvisionHandler() {
        }

        public void endElement(String uri, String localName, String qName) {
            IvisionReader.this.addGlobalMeta(this.key, this.value);
            if ("iplab:Bin_X".equals(this.key)) {
                IvisionReader.this.binX = this.value;
            } else if ("iplab:Bin_Y".equals(this.key)) {
                IvisionReader.this.binY = this.value;
            } else if ("iplab:Capture_Date".equals(this.key)) {
                IvisionReader.this.creationDate = this.value;
            } else if ("iplab:Exposure".equals(this.key)) {
                IvisionReader.this.exposureTime = this.value;
            } else if ("iplab:Gain".equals(this.key)) {
                IvisionReader.this.gain = this.value;
            } else if ("iplab:Offset".equals(this.key)) {
                IvisionReader.this.offset = this.value;
            } else if ("iplab:Interval_T".equals(this.key)) {
                IvisionReader.this.deltaT = this.value;
            } else if ("iplab:Objective_Mag".equals(this.key)) {
                IvisionReader.this.magnification = this.value;
            } else if ("iplab:Objective_NA".equals(this.key)) {
                IvisionReader.this.lensNA = this.value;
            } else if ("iplab:Objective_RI".equals(this.key)) {
                IvisionReader.this.refractiveIndex = this.value;
            } else if ("iplab:Wavelength".equals(this.key)) {
                IvisionReader.this.wavelength = this.value;
            }
        }

        public void characters(char[] ch, int start, int length) {
            String v = new String(ch, start, length);
            if ("key".equals(this.currentElement)) {
                this.key = v;
            } else {
                this.value = v;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentElement = qName;
        }
    }
}

