/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;

public class LZOCodec
extends BaseCodec {
    private static final int LZO_OVERRUN = -6;

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new FormatException("LZO Compression not currently supported");
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        byte[] b;
        ByteVector dst = new ByteVector();
        int t = in.read() & 0xFF;
        if (t > 17) {
            b = new byte[t -= 17];
            in.read(b);
            dst.add(b);
            t = in.read() & 0xFF;
            if (t < 16) {
                return dst.toByteArray();
            }
        }
        block0: while (true) {
            block24: {
                int mPos;
                block23: {
                    if (t >= 16) break block23;
                    if (t == 0) {
                        byte f = in.readByte();
                        while (f == 0) {
                            t += 255;
                            f = in.readByte();
                        }
                        t += 15 + (f & 0xFF);
                    }
                    b = new byte[t += 3];
                    in.read(b);
                    dst.add(b);
                    t = in.read() & 0xFF;
                    if (t >= 16) break block23;
                    mPos = dst.size() - 2049 - (t >> 2) - ((in.read() & 0xFF) << 2);
                    if (mPos < 0) {
                        t = -6;
                        break;
                    }
                    t = 3;
                    do {
                        dst.add(dst.get(mPos++));
                    } while (--t > 0);
                    in.seek(in.getFilePointer() - 2L);
                    t = in.read() & 3;
                    in.skipBytes(1);
                    if (t == 0) break block24;
                    b = new byte[t];
                    in.read(b);
                    dst.add(b);
                    t = in.read() & 0xFF;
                }
                while (true) {
                    if (t >= 64) {
                        mPos = dst.size() - 1 - (t >> 2 & 7) - ((in.read() & 0xFF) << 3);
                        t = (t >> 5) - 1;
                    } else if (t >= 32) {
                        if ((t &= 0x1F) == 0) {
                            byte f = in.readByte();
                            while (f == 0) {
                                t += 255;
                                f = in.readByte();
                            }
                            t += 31 + (f & 0xFF);
                        }
                        mPos = dst.size() - 1 - ((in.read() & 0xFF) >> 2);
                        mPos -= (in.read() & 0xFF) << 6;
                    } else if (t >= 16) {
                        mPos = dst.size() - ((t & 8) << 11);
                        if ((t &= 7) == 0) {
                            byte f = in.readByte();
                            while (f == 0) {
                                t += 255;
                                f = in.readByte();
                            }
                            t += 7 + (f & 0xFF);
                        }
                        mPos -= (in.read() & 0xFF) >> 2;
                        if ((mPos -= (in.read() & 0xFF) << 6) == dst.size()) break block0;
                        mPos -= 16384;
                    } else {
                        mPos = dst.size() - 1 - (t >> 2) - ((in.read() & 0xFF) << 2);
                        t = 0;
                    }
                    if (mPos < 0) {
                        t = -6;
                        break block0;
                    }
                    t += 2;
                    do {
                        dst.add(dst.get(mPos++));
                    } while (--t > 0);
                    in.seek(in.getFilePointer() - 2L);
                    t = in.read() & 3;
                    in.skipBytes(1);
                    if (t == 0) break;
                    b = new byte[t];
                    in.read(b);
                    dst.add(b);
                    t = 0;
                    t = in.read() & 0xFF;
                }
            }
            t = in.read() & 0xFF;
        }
        return dst.toByteArray();
    }
}

