/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.ReaderWrapper;
import loci.formats.meta.MetadataStore;

public class DimensionSwapper
extends ReaderWrapper {
    private String[] outputOrder;

    public static DimensionSwapper makeDimensionSwapper(IFormatReader r) {
        if (r instanceof DimensionSwapper) {
            return (DimensionSwapper)r;
        }
        return new DimensionSwapper(r);
    }

    public DimensionSwapper() {
    }

    public DimensionSwapper(IFormatReader r) {
        super(r);
    }

    public void swapDimensions(String order) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (order == null) {
            throw new IllegalArgumentException("order is null");
        }
        String oldOrder = this.getDimensionOrder();
        if (order.equals(oldOrder)) {
            return;
        }
        if (order.length() != 5) {
            throw new IllegalArgumentException("order is unexpected length (" + order.length() + ")");
        }
        int newX = order.indexOf("X");
        int newY = order.indexOf("Y");
        int newZ = order.indexOf("Z");
        int newC = order.indexOf("C");
        int newT = order.indexOf("T");
        if (newX < 0) {
            throw new IllegalArgumentException("X does not appear");
        }
        if (newY < 0) {
            throw new IllegalArgumentException("Y does not appear");
        }
        if (newZ < 0) {
            throw new IllegalArgumentException("Z does not appear");
        }
        if (newC < 0) {
            throw new IllegalArgumentException("C does not appear");
        }
        if (newT < 0) {
            throw new IllegalArgumentException("T does not appear");
        }
        if (newX > 1) {
            throw new IllegalArgumentException("X in unexpected position (" + newX + ")");
        }
        if (newY > 1) {
            throw new IllegalArgumentException("Y in unexpected position (" + newY + ")");
        }
        int[] dims = new int[5];
        int oldX = oldOrder.indexOf("X");
        int oldY = oldOrder.indexOf("Y");
        int oldZ = oldOrder.indexOf("Z");
        int oldC = oldOrder.indexOf("C");
        int oldT = oldOrder.indexOf("T");
        if (oldC != newC && this.reader.getRGBChannelCount() > 1) {
            throw new IllegalArgumentException("Cannot swap C dimension when RGB channel count > 1");
        }
        dims[oldX] = this.getSizeX();
        dims[oldY] = this.getSizeY();
        dims[oldZ] = this.getSizeZ();
        dims[oldC] = this.getSizeC();
        dims[oldT] = this.getSizeT();
        int series = this.getSeries();
        CoreMetadata[] core = this.getCoreMetadata();
        core[series].sizeX = dims[newX];
        core[series].sizeY = dims[newY];
        core[series].sizeZ = dims[newZ];
        core[series].sizeC = dims[newC];
        core[series].sizeT = dims[newT];
        if (this.outputOrder[series] == null) {
            this.outputOrder[series] = core[series].dimensionOrder;
        }
        core[series].dimensionOrder = order;
        if (oldC != newC) {
            core[series].cLengths = new int[]{this.getSizeC()};
            core[series].cTypes = new String[]{"Channel"};
        }
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
    }

    public void setOutputOrder(String outputOrder) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        this.outputOrder[this.getSeries()] = outputOrder;
    }

    public String getInputOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata()[this.getSeries()].dimensionOrder;
    }

    public int getSizeX() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata()[this.getSeries()].sizeX;
    }

    public int getSizeY() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata()[this.getSeries()].sizeY;
    }

    public int getSizeZ() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata()[this.getSeries()].sizeZ;
    }

    public int getSizeC() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata()[this.getSeries()].sizeC;
    }

    public int getSizeT() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata()[this.getSeries()].sizeT;
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        int[] cLengths = this.getCoreMetadata()[this.getSeries()].cLengths;
        return cLengths == null ? super.getChannelDimLengths() : cLengths;
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String[] cTypes = this.getCoreMetadata()[this.getSeries()].cTypes;
        return cTypes == null ? super.getChannelDimTypes() : cTypes;
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (this.outputOrder[this.getSeries()] != null) {
            return this.outputOrder[this.getSeries()];
        }
        return this.getInputOrder();
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return super.openBytes(this.reorder(no));
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf, x, y, w, h);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return super.openThumbBytes(this.reorder(no));
    }

    public int[] getZCTCoords(int no) {
        return FormatTools.getZCTCoords(this, no);
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    public void setId(String id) throws FormatException, IOException {
        String oldFile = this.getCurrentFile();
        super.setId(id);
        if (!id.equals(oldFile) || this.outputOrder == null) {
            this.outputOrder = new String[this.getSeriesCount()];
        }
    }

    protected int reorder(int no) throws FormatException {
        if (this.getInputOrder() == null) {
            return no;
        }
        return FormatTools.getReorderedIndex(this.getInputOrder(), this.getDimensionOrder(), this.getSizeZ(), this.getEffectiveSizeC(), this.getSizeT(), this.getImageCount(), no);
    }
}

