/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import omero.model.Ellipse;
import omero.model.Rect;
import omero.model.Roi;
import omero.model.Shape;
import pojos.DataObject;
import pojos.EllipseData;
import pojos.ROICoordinate;
import pojos.RectangleData;
import pojos.ShapeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIData
extends DataObject {
    private TreeMap<ROICoordinate, List<ShapeData>> roiShapes;

    private void initialize() {
        this.roiShapes = new TreeMap(new ROICoordinate());
        Roi roi = (Roi)this.asIObject();
        List<Shape> shapes = roi.copyShapes();
        if (shapes == null) {
            return;
        }
        for (Shape shape : shapes) {
            List<Object> data;
            ShapeData s = null;
            if (shape instanceof Rect) {
                s = new RectangleData(shape);
            } else if (shape instanceof Ellipse) {
                s = new EllipseData(shape);
            }
            if (s == null) continue;
            ROICoordinate coord = new ROICoordinate(s.getZ(), s.getT());
            if (!this.roiShapes.containsKey(coord)) {
                data = new ArrayList();
                this.roiShapes.put(coord, data);
            } else {
                data = this.roiShapes.get(coord);
            }
            data.add(s);
        }
    }

    public ROIData(Roi roi) {
        this.setValue(roi);
        if (roi != null) {
            this.initialize();
        }
    }

    public List<ShapeData> getShapes(int z, int t) {
        return this.roiShapes.get(new ROICoordinate(z, t));
    }

    public Iterator<List<ShapeData>> getIterator() {
        return this.roiShapes.values().iterator();
    }

    public ROICoordinate firstPlane() {
        return this.roiShapes.firstKey();
    }

    public ROICoordinate lastPlane() {
        return this.roiShapes.lastKey();
    }

    public Iterator<List<ShapeData>> getShapesInRange(ROICoordinate start, ROICoordinate end) {
        return this.roiShapes.subMap(start, end).values().iterator();
    }
}

