/*
 * Decompiled with CFR 0.152.
 */
package omerojava.util;

import ome.services.blitz.gateway.services.ImageService;
import omero.ServerError;
import omero.model.Pixels;
import omerojava.util.BytesConverter;
import omerojava.util.PixelsCache;
import omerojava.util.Plane2D;
import omerojava.util.ReadOnlyByteArray;

public class DataSink {
    static final String INT_8 = "int8";
    static final String UINT_8 = "uint8";
    static final String INT_16 = "int16";
    static final String UINT_16 = "uint16";
    static final String INT_32 = "int32";
    static final String UINT_32 = "uint32";
    static final String FLOAT = "float";
    static final String DOUBLE = "double";
    ImageService service;
    private Pixels source;
    private int bytesPerPixels;
    private BytesConverter strategy;
    private PixelsCache cache;

    public static DataSink makeNew(Pixels source, ImageService service) {
        if (source == null) {
            throw new NullPointerException("No pixels.");
        }
        if (service == null) {
            throw new NullPointerException("No Image service.");
        }
        return new DataSink(source, service);
    }

    private DataSink(Pixels source, ImageService service) {
        if (service == null) {
            throw new NullPointerException("No Image service.");
        }
        this.source = source;
        this.service = service;
        this.source = source;
        String type = source.getPixelsType().getValue().getValue();
        this.bytesPerPixels = DataSink.getBytesPerPixels(type);
        this.strategy = BytesConverter.getConverter(type);
    }

    private static int getBytesPerPixels(String v) {
        if (INT_8.equals(v) || UINT_8.equals(v)) {
            return 1;
        }
        if (INT_16.equals(v) || UINT_16.equals(v)) {
            return 2;
        }
        if (INT_32.equals(v) || UINT_32.equals(v) || FLOAT.equals(v)) {
            return 4;
        }
        if (DOUBLE.equals(v)) {
            return 8;
        }
        return -1;
    }

    private Integer linearize(int z, int w, int t) {
        int sizeZ = this.source.getSizeZ().getValue();
        int sizeC = this.source.getSizeC().getValue();
        if (z < 0 || sizeZ <= z) {
            throw new IllegalArgumentException("z out of range [0, " + sizeZ + "): " + z + ".");
        }
        if (w < 0 || sizeC <= w) {
            throw new IllegalArgumentException("w out of range [0, " + sizeC + "): " + w + ".");
        }
        if (t < 0 || this.source.getSizeT().getValue() <= t) {
            throw new IllegalArgumentException("t out of range [0, " + this.source.getSizeT().getValue() + "): " + t + ".");
        }
        return new Integer(sizeZ * sizeC * t + sizeZ * w + z);
    }

    private Plane2D createPlane(int z, int t, int w, BytesConverter strategy) throws ServerError {
        Integer planeIndex = this.linearize(z, w, t);
        Plane2D plane = null;
        if (plane != null) {
            return plane;
        }
        byte[] data = null;
        data = this.service.getRawPlane(this.source.getId().getValue(), z, w, t);
        ReadOnlyByteArray array = new ReadOnlyByteArray(data, 0, data.length);
        plane = new Plane2D(array, this.source.getSizeX().getValue(), this.source.getSizeY().getValue(), this.bytesPerPixels, strategy);
        return plane;
    }

    public Plane2D getPlane(int z, int t, int w) throws ServerError {
        return this.createPlane(z, t, w, this.strategy);
    }

    public boolean isSame(long pixelsID) {
        return pixelsID == this.source.getId().getValue();
    }

    public static double[][] mapServerToClient(byte[] data, int x, int y, String pixelType) {
        return DataSink.mapServerToClient(data, x, y, pixelType, false);
    }

    public static double[][] mapServerToClient(byte[] data, int x, int y, String pixelType, boolean transpose) {
        ReadOnlyByteArray array = new ReadOnlyByteArray(data, 0, data.length);
        int bpp = DataSink.getBytesPerPixels(pixelType);
        BytesConverter thisStrategy = BytesConverter.getConverter(pixelType);
        Plane2D thisPlane = new Plane2D(array, x, y, bpp, thisStrategy);
        return thisPlane.getPixelsArrayAsDouble(transpose);
    }
}

