/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.RoiAnnotationLink;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.roi.Shape;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="roi_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="roi_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="roi_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="roi_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="roi_owner_filter_SHAPES", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="roi_group_filter_SHAPES", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="roi_event_filter_SHAPES", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="roi_perms_filter_SHAPES", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="roi_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="roi_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="roi_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="roi_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="roi_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="roi_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="roi_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="roi_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="roi", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_roi", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_roi"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Roi
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "roi_owner_filter";
    public static final String GROUP_FILTER = "roi_group_filter";
    public static final String EVENT_FILTER = "roi_event_filter";
    public static final String PERMS_FILTER = "roi_perms_filter";
    public static final String ID = "ome.model.roi.Roi_id";
    protected Long id;
    public static final String VERSION = "ome.model.roi.Roi_version";
    protected Integer version = 0;
    protected List<Shape> shapes = new ArrayList<Shape>();
    public static final String OWNER_FILTER_SHAPES = "roi_owner_filter_SHAPES";
    public static final String GROUP_FILTER_SHAPES = "roi_group_filter_SHAPES";
    public static final String EVENT_FILTER_SHAPES = "roi_event_filter_SHAPES";
    public static final String PERMS_FILTER_SHAPES = "roi_perms_filter_SHAPES";
    protected Image image = null;
    protected OriginalFile source = null;
    protected Set<RoiAnnotationLink> annotationLinks = new HashSet<RoiAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "roi_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "roi_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "roi_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "roi_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String SHAPES = "ome.model.roi.Roi_shapes";
    public static final String IMAGE = "ome.model.roi.Roi_image";
    public static final String SOURCE = "ome.model.roi.Roi_source";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.roi.Roi_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.roi.Roi_annotationLinks";
    public static final String DESCRIPTION = "ome.model.roi.Roi_description";
    public static final String DETAILS = "ome.model.roi.Roi_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Roi() {
        this(null, true);
    }

    protected Roi(Long id) {
        this(id, true);
    }

    public Roi(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Roi(Image _image) {
        this(null, true);
        this.setImage(_image);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_roi")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @JoinColumn(name="roi", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="roi_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="roi_owner_filter_SHAPES", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="roi_group_filter_SHAPES", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="roi_event_filter_SHAPES", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="roi_perms_filter_SHAPES", condition=":permsStr = permissions")})
    protected List<Shape> getShapes() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.shapes;
    }

    protected void setShapes(List<Shape> shapes) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.shapes = shapes;
    }

    public int sizeOfShapes() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.shapes == null ? -1 : this.shapes.size();
    }

    public Iterator<Shape> iterateShapes() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            return new EmptyIterator<Shape>();
        }
        return this.getShapes().iterator();
    }

    public Collection<Shape> unmodifiableShapes() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getShapes());
    }

    public <E> List<E> collectShapes(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Shape> it = this.iterateShapes();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addShape(Shape target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        this.getShapes().add(target);
        if (target.isLoaded()) {
            target.setRoi(this);
        }
    }

    public void addShapeSet(Collection<Shape> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        this.getShapes().addAll(targets);
        for (Shape target : targets) {
            if (!target.isLoaded()) continue;
            target.setRoi(this);
        }
    }

    public void removeShape(Shape target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        this.getShapes().remove(target);
        if (target.isLoaded()) {
            target.setRoi(null);
        }
    }

    public void removeShapeSet(Collection<Shape> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        this.getShapes().removeAll(targets);
        for (Shape target : targets) {
            if (!target.isLoaded()) continue;
            target.setRoi(null);
        }
    }

    public void clearShapes() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        this.getShapes().clear();
        Iterator<Shape> it = this.iterateShapes();
        while (it.hasNext()) {
            Shape target = it.next();
            target.setRoi(null);
        }
    }

    public Shape getShape(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        return this.getShapes().get(index);
    }

    public void setShape(int index, Shape element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        this.getShapes().set(index, element);
    }

    @Transient
    public Shape getPrimaryShape() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        return this.getShapes().get(0);
    }

    public Shape setPrimaryShape(Shape element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getShapes() == null) {
            this.throwNullCollectionException("Shapes");
        }
        List<Shape> list = this.getShapes();
        int index = list.indexOf(element);
        Shape old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Image.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="image", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKroi_image_image")
    public Image getImage() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.image;
    }

    public void setImage(Image image) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.image = image;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=OriginalFile.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="source", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKroi_source_originalfile")
    public OriginalFile getSource() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.source;
    }

    public void setSource(OriginalFile source) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.source = source;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="roi_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="roi_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="roi_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="roi_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<RoiAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<RoiAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<RoiAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<RoiAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<RoiAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<RoiAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addRoiAnnotationLink(RoiAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        target.setParent(this);
    }

    public void addRoiAnnotationLinkSet(Collection<RoiAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (RoiAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    public void removeRoiAnnotationLink(RoiAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeRoiAnnotationLinkSet(Collection<RoiAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (RoiAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public RoiAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        RoiAnnotationLink link = new RoiAnnotationLink();
        link.link(this, addition);
        this.addRoiAnnotationLink(link, true);
        return link;
    }

    public void addRoiAnnotationLink(RoiAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<RoiAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                RoiAnnotationLink link = (RoiAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<RoiAnnotationLink> findRoiAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<RoiAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<RoiAnnotationLink> result = new HashSet<RoiAnnotationLink>();
        while (it.hasNext()) {
            RoiAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<RoiAnnotationLink> toRemove = this.findRoiAnnotationLink(removal);
        Iterator<RoiAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeRoiAnnotationLink(it.next(), true);
        }
    }

    public void removeRoiAnnotationLink(RoiAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<RoiAnnotationLink> list = new ArrayList<RoiAnnotationLink>(this.getAnnotationLinks());
        for (RoiAnnotationLink link : list) {
            this.removeRoiAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Roi_annotationLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Roi_annotationLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Roi newInstance() {
        return new Roi();
    }

    public Roi proxy() {
        return new Roi(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.shapes = (List)__filter.filter(SHAPES, this.shapes);
            this.image = (Image)__filter.filter(IMAGE, this.image);
            this.source = (OriginalFile)__filter.filter(SOURCE, this.source);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(SHAPES)) {
            return this.getShapes();
        }
        if (field.equals(IMAGE)) {
            return this.getImage();
        }
        if (field.equals(SOURCE)) {
            return this.getSource();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(SHAPES)) {
            this.setShapes((List)value);
        } else if (field.equals(IMAGE)) {
            this.setImage((Image)value);
        } else if (field.equals(SOURCE)) {
            this.setSource((OriginalFile)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.shapes = null;
        this.image = null;
        this.source = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(SHAPES);
        raw.add(IMAGE);
        raw.add(SOURCE);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKroi_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKroi_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKroi_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKroi_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKroi_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

