/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.Pixels;
import ome.model.roi.Shape;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="mask")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Mask
extends Shape
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "mask_owner_filter";
    public static final String GROUP_FILTER = "mask_group_filter";
    public static final String EVENT_FILTER = "mask_event_filter";
    public static final String PERMS_FILTER = "mask_perms_filter";
    protected Double x = null;
    protected Double y = null;
    protected Double width = null;
    protected Double height = null;
    protected Pixels pixels = null;
    protected byte[] bytes = null;
    public static final String X = "ome.model.roi.Mask_x";
    public static final String Y = "ome.model.roi.Mask_y";
    public static final String WIDTH = "ome.model.roi.Mask_width";
    public static final String HEIGHT = "ome.model.roi.Mask_height";
    public static final String PIXELS = "ome.model.roi.Mask_pixels";
    public static final String BYTES = "ome.model.roi.Mask_bytes";
    public static final Set<String> FIELDS;

    public Mask() {
        this(null, true);
    }

    protected Mask(Long id) {
        this(id, true);
    }

    public Mask(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="x", updatable=true)
    public Double getX() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.x;
    }

    public void setX(Double x) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.x = x;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="y", updatable=true)
    public Double getY() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.y;
    }

    public void setY(Double y) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.y = y;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="width", updatable=true)
    public Double getWidth() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.width;
    }

    public void setWidth(Double width) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.width = width;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="height", updatable=true)
    public Double getHeight() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.height;
    }

    public void setHeight(Double height) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.height = height;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Pixels.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="pixels", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKmask_pixels_pixels")
    public Pixels getPixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixels;
    }

    public void setPixels(Pixels pixels) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixels = pixels;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="bytes", updatable=true)
    public byte[] getBytes() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.bytes = bytes;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Mask newInstance() {
        return new Mask();
    }

    public Mask proxy() {
        return new Mask(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.x = (Double)__filter.filter(X, this.x);
            this.y = (Double)__filter.filter(Y, this.y);
            this.width = (Double)__filter.filter(WIDTH, this.width);
            this.height = (Double)__filter.filter(HEIGHT, this.height);
            this.pixels = (Pixels)__filter.filter(PIXELS, this.pixels);
            this.bytes = (byte[])__filter.filter(BYTES, this.bytes);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(X)) {
            return this.getX();
        }
        if (field.equals(Y)) {
            return this.getY();
        }
        if (field.equals(WIDTH)) {
            return this.getWidth();
        }
        if (field.equals(HEIGHT)) {
            return this.getHeight();
        }
        if (field.equals(PIXELS)) {
            return this.getPixels();
        }
        if (field.equals(BYTES)) {
            return this.getBytes();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(X)) {
            this.setX((Double)value);
        } else if (field.equals(Y)) {
            this.setY((Double)value);
        } else if (field.equals(WIDTH)) {
            this.setWidth((Double)value);
        } else if (field.equals(HEIGHT)) {
            this.setHeight((Double)value);
        } else if (field.equals(PIXELS)) {
            this.setPixels((Pixels)value);
        } else if (field.equals(BYTES)) {
            this.setBytes((byte[])value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.x = null;
        this.y = null;
        this.width = null;
        this.height = null;
        this.pixels = null;
        this.bytes = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(X);
        raw.addAll(Shape.FIELDS);
        raw.add(Y);
        raw.addAll(Shape.FIELDS);
        raw.add(WIDTH);
        raw.addAll(Shape.FIELDS);
        raw.add(HEIGHT);
        raw.addAll(Shape.FIELDS);
        raw.add(PIXELS);
        raw.addAll(Shape.FIELDS);
        raw.add(BYTES);
        raw.addAll(Shape.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

