/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Dataset;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetAnnotationLinkI;
import omero.model.DatasetImageLink;
import omero.model.DatasetImageLinkI;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Project;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectDatasetLinkI;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetI
extends Dataset
implements ModelBased {
    public static final String PROJECTLINKS = "ome.model.containers.Dataset_projectLinks";
    public static final String IMAGELINKS = "ome.model.containers.Dataset_imageLinks";
    public static final String ANNOTATIONLINKS = "ome.model.containers.Dataset_annotationLinks";
    public static final String NAME = "ome.model.containers.Dataset_name";
    public static final String DESCRIPTION = "ome.model.containers.Dataset_description";
    public static final String DETAILS = "ome.model.containers.Dataset_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.projectLinksSeq = new ArrayList();
            this.projectLinksLoaded = true;
        } else {
            this.projectLinksSeq = null;
            this.projectLinksLoaded = false;
        }
        if (load) {
            this.imageLinksSeq = new ArrayList();
            this.imageLinksLoaded = true;
        } else {
            this.imageLinksSeq = null;
            this.imageLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public DatasetI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public DatasetI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public DatasetI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadProjectLinks();
        this.unloadImageLinks();
        this.unloadAnnotationLinks();
        this.unloadName();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        DatasetI copy = new DatasetI();
        copy.id = this.id;
        copy.version = this.version;
        if (!this.projectLinksLoaded) {
            copy.projectLinksLoaded = false;
            copy.projectLinksSeq = null;
        } else {
            copy.projectLinksLoaded = true;
            copy.projectLinksSeq = new ArrayList<ProjectDatasetLink>();
            for (IObject item : this.projectLinksSeq) {
                copy.projectLinksSeq.add(item == null ? null : (ProjectDatasetLink)item.proxy());
            }
        }
        if (!this.imageLinksLoaded) {
            copy.imageLinksLoaded = false;
            copy.imageLinksSeq = null;
        } else {
            copy.imageLinksLoaded = true;
            copy.imageLinksSeq = new ArrayList<DatasetImageLink>();
            for (IObject item : this.imageLinksSeq) {
                copy.imageLinksSeq.add(item == null ? null : (DatasetImageLink)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<DatasetAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (DatasetAnnotationLink)item.proxy());
            }
        }
        copy.name = this.name;
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new DatasetI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    @Override
    public void unloadProjectLinks(Current current) {
        this.projectLinksLoaded = false;
        this.projectLinksSeq = null;
    }

    protected List getProjectLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.projectLinksSeq;
    }

    protected void setProjectLinks(List projectLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.projectLinksSeq = projectLinks == null ? new ArrayList() : new ArrayList(projectLinks);
        this.projectLinksLoaded = projectLinks != null;
    }

    private void copyProjectLinks(ome.model.containers.Dataset source, IceMapper mapper) {
        this.setProjectLinks((List)mapper.findCollection((Collection)source.retrieve(PROJECTLINKS)), null);
        this.projectLinksCountPerOwner = source.getProjectLinksCountPerOwner();
    }

    private void fillProjectLinks(ome.model.containers.Dataset target, IceMapper mapper) {
        if (this.projectLinksLoaded) {
            target.putAt(PROJECTLINKS, (Object)mapper.reverse(this.projectLinksSeq, Set.class));
        } else {
            target.putAt(PROJECTLINKS, null);
        }
    }

    public boolean isProjectLinksLoaded() {
        return this.projectLinksLoaded;
    }

    @Override
    public int sizeOfProjectLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            return -1;
        }
        return this.projectLinksSeq.size();
    }

    public List copyProjectLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        ArrayList result = new ArrayList(this.projectLinksSeq);
        return result;
    }

    public Iterator iterateProjectLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        return this.projectLinksSeq.iterator();
    }

    @Override
    public void addProjectDatasetLink(ProjectDatasetLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        this.projectLinksSeq.add(target);
        target.setChild(this);
    }

    @Override
    public void addAllProjectDatasetLinkSet(List<ProjectDatasetLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        this.projectLinksSeq.addAll(targets);
        for (ProjectDatasetLink target : targets) {
            target.setChild(this);
        }
    }

    @Override
    public void removeProjectDatasetLink(ProjectDatasetLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        this.projectLinksSeq.remove(target);
        target.setChild(null);
    }

    @Override
    public void removeAllProjectDatasetLinkSet(List<ProjectDatasetLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        for (ProjectDatasetLink elt : targets) {
            elt.setChild(null);
            this.projectLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearProjectLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        for (ProjectDatasetLink elt : this.projectLinksSeq) {
            elt.setChild(null);
        }
        this.projectLinksSeq.clear();
    }

    @Override
    public void reloadProjectLinks(Dataset toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.projectLinksLoaded) {
            throw new ClientError("Cannot reload active collection: projectLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ProjectDatasetLink> copy = toCopy.copyProjectLinks();
        for (ProjectDatasetLink elt : copy) {
            elt.setChild(this);
        }
        this.projectLinksSeq = new ArrayList<ProjectDatasetLink>(copy);
        toCopy.unloadProjectLinks();
        this.projectLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getProjectLinksCountPerOwner(Current current) {
        return this.projectLinksCountPerOwner;
    }

    @Override
    public ProjectDatasetLink linkProject(Project addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        ProjectDatasetLinkI link = new ProjectDatasetLinkI();
        link.link(addition, this);
        this.addProjectDatasetLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addProjectDatasetLinkToBoth(ProjectDatasetLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        this.projectLinksSeq.add(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().addProjectDatasetLinkToBoth(link, false);
        }
    }

    @Override
    public List<ProjectDatasetLink> findProjectDatasetLink(Project removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        ArrayList<ProjectDatasetLink> result = new ArrayList<ProjectDatasetLink>();
        for (ProjectDatasetLink link : this.projectLinksSeq) {
            if (link.getParent() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkProject(Project removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        List<ProjectDatasetLink> toRemove = this.findProjectDatasetLink(removal);
        Iterator<ProjectDatasetLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeProjectDatasetLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeProjectDatasetLinkFromBoth(ProjectDatasetLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("projectLinksSeq");
        }
        this.projectLinksSeq.remove(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().removeProjectDatasetLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Project> linkedProjectList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.projectLinksLoaded) {
            this.throwNullCollectionException("ProjectLinks");
        }
        ArrayList<Project> linked = new ArrayList<Project>();
        for (ProjectDatasetLink link : this.projectLinksSeq) {
            linked.add(link.getParent());
        }
        return linked;
    }

    @Override
    public void unloadImageLinks(Current current) {
        this.imageLinksLoaded = false;
        this.imageLinksSeq = null;
    }

    protected List getImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.imageLinksSeq;
    }

    protected void setImageLinks(List imageLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.imageLinksSeq = imageLinks == null ? new ArrayList() : new ArrayList(imageLinks);
        this.imageLinksLoaded = imageLinks != null;
    }

    private void copyImageLinks(ome.model.containers.Dataset source, IceMapper mapper) {
        this.setImageLinks((List)mapper.findCollection((Collection)source.retrieve(IMAGELINKS)), null);
        this.imageLinksCountPerOwner = source.getImageLinksCountPerOwner();
    }

    private void fillImageLinks(ome.model.containers.Dataset target, IceMapper mapper) {
        if (this.imageLinksLoaded) {
            target.putAt(IMAGELINKS, (Object)mapper.reverse(this.imageLinksSeq, Set.class));
        } else {
            target.putAt(IMAGELINKS, null);
        }
    }

    public boolean isImageLinksLoaded() {
        return this.imageLinksLoaded;
    }

    @Override
    public int sizeOfImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            return -1;
        }
        return this.imageLinksSeq.size();
    }

    public List copyImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        ArrayList result = new ArrayList(this.imageLinksSeq);
        return result;
    }

    public Iterator iterateImageLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        return this.imageLinksSeq.iterator();
    }

    @Override
    public void addDatasetImageLink(DatasetImageLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllDatasetImageLinkSet(List<DatasetImageLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.addAll(targets);
        for (DatasetImageLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeDatasetImageLink(DatasetImageLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllDatasetImageLinkSet(List<DatasetImageLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        for (DatasetImageLink elt : targets) {
            elt.setParent(null);
            this.imageLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        for (DatasetImageLink elt : this.imageLinksSeq) {
            elt.setParent(null);
        }
        this.imageLinksSeq.clear();
    }

    @Override
    public void reloadImageLinks(Dataset toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.imageLinksLoaded) {
            throw new ClientError("Cannot reload active collection: imageLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<DatasetImageLink> copy = toCopy.copyImageLinks();
        for (DatasetImageLink elt : copy) {
            elt.setParent(this);
        }
        this.imageLinksSeq = new ArrayList<DatasetImageLink>(copy);
        toCopy.unloadImageLinks();
        this.imageLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getImageLinksCountPerOwner(Current current) {
        return this.imageLinksCountPerOwner;
    }

    @Override
    public DatasetImageLink linkImage(Image addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        DatasetImageLinkI link = new DatasetImageLinkI();
        link.link(this, addition);
        this.addDatasetImageLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addDatasetImageLinkToBoth(DatasetImageLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.add(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().addDatasetImageLinkToBoth(link, false);
        }
    }

    @Override
    public List<DatasetImageLink> findDatasetImageLink(Image removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        ArrayList<DatasetImageLink> result = new ArrayList<DatasetImageLink>();
        for (DatasetImageLink link : this.imageLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkImage(Image removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        List<DatasetImageLink> toRemove = this.findDatasetImageLink(removal);
        Iterator<DatasetImageLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeDatasetImageLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeDatasetImageLinkFromBoth(DatasetImageLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.remove(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().removeDatasetImageLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Image> linkedImageList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("ImageLinks");
        }
        ArrayList<Image> linked = new ArrayList<Image>();
        for (DatasetImageLink link : this.imageLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.containers.Dataset source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.containers.Dataset target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addDatasetAnnotationLink(DatasetAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllDatasetAnnotationLinkSet(List<DatasetAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (DatasetAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeDatasetAnnotationLink(DatasetAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllDatasetAnnotationLinkSet(List<DatasetAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (DatasetAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (DatasetAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Dataset toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<DatasetAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (DatasetAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<DatasetAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public DatasetAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        DatasetAnnotationLinkI link = new DatasetAnnotationLinkI();
        link.link(this, addition);
        this.addDatasetAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addDatasetAnnotationLinkToBoth(DatasetAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<DatasetAnnotationLink> findDatasetAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<DatasetAnnotationLink> result = new ArrayList<DatasetAnnotationLink>();
        for (DatasetAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<DatasetAnnotationLink> toRemove = this.findDatasetAnnotationLink(removal);
        Iterator<DatasetAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeDatasetAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeDatasetAnnotationLinkFromBoth(DatasetAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (DatasetAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.containers.Dataset source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.containers.Dataset target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.containers.Dataset source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.containers.Dataset target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.containers.Dataset) {
            ome.model.containers.Dataset source = (ome.model.containers.Dataset)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyProjectLinks(source, mapper);
                this.copyImageLinks(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyName(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Dataset cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.containers.Dataset target = new ome.model.containers.Dataset();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillProjectLinks(target, mapper);
            this.fillImageLinks(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillName(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<DatasetI> cast(List list) {
        return list;
    }
}

