/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.Identity;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.UserException;
import Ice.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import ome.api.JobHandle;
import ome.model.IObject;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.fire.TopicManager;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import omero.ApiUsageException;
import omero.InternalException;
import omero.RTime;
import omero.ServerError;
import omero.ValidationException;
import omero.grid.AMI_Tables_getTable;
import omero.grid.InteractiveProcessorI;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.InteractiveProcessorPrxHelper;
import omero.grid.InternalRepositoryPrx;
import omero.grid.ProcessorPrx;
import omero.grid.ProcessorPrxHelper;
import omero.grid.RepositoryMap;
import omero.grid.RepositoryPrx;
import omero.grid.TablePrx;
import omero.grid.TablePrxHelper;
import omero.grid.TablesPrx;
import omero.grid.TablesPrxHelper;
import omero.grid._SharedResourcesOperations;
import omero.model.FormatI;
import omero.model.Job;
import omero.model.JobStatusI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedResourcesI
extends AbstractAmdServant
implements _SharedResourcesOperations,
BlitzOnly,
ServiceFactoryAware {
    private static final Log log = LogFactory.getLog(SharedResourcesI.class);
    private final Set<String> tableIds = new HashSet<String>();
    private final TopicManager topicManager;
    private final Registry registry;
    private ServiceFactoryI sf;
    static String QUERY = "select o from OriginalFile o where o.format.value = 'Repository'";

    public SharedResourcesI(BlitzExecutor be, TopicManager topicManager, Registry registry) {
        super(null, be);
        this.topicManager = topicManager;
        this.registry = registry;
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.sf = sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<String> set = this.tableIds;
        synchronized (set) {
            for (String id : this.tableIds) {
                TablePrx table = TablePrxHelper.uncheckedCast(this.sf.adapter.getCommunicator().stringToProxy(id).ice_oneway());
                try {
                    table.close();
                }
                catch (Exception e) {
                    log.warn((Object)("Exception while closing table oneway: " + e));
                }
            }
            this.tableIds.clear();
        }
    }

    private void allow(ObjectPrx prx) {
        if (prx != null && this.sf.control != null) {
            this.sf.control.identities().add(new Identity[]{prx.ice_getIdentity()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(TablePrx prx) {
        if (prx != null) {
            Set<String> set = this.tableIds;
            synchronized (set) {
                this.tableIds.add(Util.identityToString((Identity)prx.ice_getIdentity()));
            }
        }
    }

    private void checkAcquisitionWait(int seconds) throws ApiUsageException {
        if (seconds > 180) {
            ApiUsageException aue = new ApiUsageException();
            aue.message = "Delay is too long. Maximum = 3 minutes.";
            throw aue;
        }
    }

    private <U extends ObjectPrx> U lookup(List<ObjectPrx> objectPrxs, int seconds, RepeatTask<U> task) throws ServerError {
        ResultHolder holder = new ResultHolder(seconds);
        for (ObjectPrx prx : objectPrxs) {
            if (prx == null) continue;
            task.requestService(prx, holder);
        }
        return (U)((ObjectPrx)holder.get());
    }

    @Override
    public RepositoryMap repositories(Current current) throws ServerError {
        IceMapper mapper = new IceMapper();
        List objs = (List)mapper.map((List)this.sf.executor.execute(this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "acquireRepositories", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findAllByQuery(QUERY, null);
            }
        }));
        InternalRepositoryPrx[] repos = this.registry.lookupRepositories();
        RepositoryMap map = new RepositoryMap();
        map.descriptions = new ArrayList<OriginalFile>();
        map.proxies = new ArrayList<RepositoryPrx>();
        ArrayList<Long> found = new ArrayList<Long>();
        for (InternalRepositoryPrx i : repos) {
            if (i == null) continue;
            try {
                OriginalFile desc = i.getDescription();
                RepositoryPrx proxy = i.getProxy();
                map.descriptions.add(desc);
                map.proxies.add(proxy);
                found.add(desc.getId().getValue());
                this.allow(proxy);
            }
            catch (LocalException e) {
                // empty catch block
            }
        }
        for (OriginalFile r : objs) {
            if (found.contains(r.getId().getValue())) continue;
            map.descriptions.add(r);
            map.proxies.add(null);
        }
        return map;
    }

    @Override
    public TablePrx newTable(long repo, String path, Current __current) throws ServerError {
        FormatI omero_tables = new FormatI();
        omero_tables.setValue(rtypes.rstring("OMERO.tables"));
        final OriginalFileI file = new OriginalFileI();
        RTime time = rtypes.rtime(System.currentTimeMillis());
        file.setAtime(time);
        file.setMtime(time);
        file.setCtime(time);
        file.setSha1(rtypes.rstring("UNKNOWN"));
        file.setFormat(omero_tables);
        file.setSize(rtypes.rlong(0L));
        file.setPath(rtypes.rstring(path));
        file.setName(rtypes.rstring(path));
        Long id = (Long)this.sf.executor.execute(this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "newTable", new Object[]{repo, path}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                try {
                    IObject obj = (IObject)new IceMapper().reverse(file);
                    return sf.getUpdateService().saveAndReturnObject(obj).getId();
                }
                catch (Exception e) {
                    log.error((Object)e);
                    return null;
                }
            }
        });
        if (id == null) {
            throw new InternalException(null, null, "Failed to save file");
        }
        file.setId(rtypes.rlong(id));
        file.unload();
        return this.openTable(file, __current);
    }

    @Override
    public TablePrx openTable(final OriginalFile file, Current __current) throws ServerError {
        if (file == null || file.getId() == null) {
            throw new ValidationException(null, null, "file must be a managed instance.");
        }
        this.sf.executor.execute(this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "checkOriginalFilePermissions", new Object[]{file.getId().getValue()}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().get(ome.model.core.OriginalFile.class, file.getId().getValue());
            }
        });
        file.unload();
        TablesPrx[] tables = this.registry.lookupTables();
        TablePrx tablePrx = this.lookup(Arrays.asList(tables), 60, new RepeatTask<TablePrx>(){

            @Override
            public void requestService(ObjectPrx prx, final ResultHolder holder) {
                TablesPrx server = TablesPrxHelper.uncheckedCast(prx);
                server.getTable_async(new AMI_Tables_getTable(){

                    public void ice_exception(LocalException ex) {
                        holder.set(null);
                    }

                    public void ice_response(TablePrx __ret) {
                        holder.set(__ret);
                    }

                    public void ice_exception(UserException ex) {
                        holder.set(null);
                    }
                }, file);
            }
        });
        this.allow(tablePrx);
        this.register(tablePrx);
        return tablePrx;
    }

    @Override
    public InteractiveProcessorPrx acquireProcessor(final Job submittedJob, int seconds, Current current) throws ServerError {
        this.checkAcquisitionWait(seconds);
        final IceMapper mapper = new IceMapper();
        ome.model.jobs.Job savedJob = (ome.model.jobs.Job)this.sf.executor.execute(this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "submitJob", new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=false)
            public ome.model.jobs.Job doWork(Session session, ServiceFactory sf) {
                JobHandle handle = sf.createJobHandle();
                try {
                    JobStatusI status = new JobStatusI();
                    status.setValue(rtypes.rstring("Waiting"));
                    submittedJob.setStatus(status);
                    submittedJob.setMessage(rtypes.rstring("Interactive job. Waiting."));
                    handle.submit((ome.model.jobs.Job)mapper.reverse(submittedJob));
                    ome.model.jobs.Job job = handle.getJob();
                    return job;
                }
                catch (ApiUsageException e) {
                    ome.model.jobs.Job job = null;
                    return job;
                }
                finally {
                    if (handle != null) {
                        handle.close();
                    }
                }
            }
        });
        if (savedJob == null) {
            throw new ApiUsageException(null, null, "Could not submit job. ");
        }
        Job unloadedJob = (Job)mapper.map((Filterable)savedJob);
        unloadedJob.unload();
        ProcessorPrx[] procs = this.registry.lookupProcessors();
        ProcessorPrx server = this.lookup(Arrays.asList(procs), seconds, new ProcessorCheck());
        long timeout = System.currentTimeMillis() + 3600000L;
        InteractiveProcessorI ip = new InteractiveProcessorI(this.sf.principal, this.sf.sessionManager, this.sf.executor, server, unloadedJob, timeout, this.sf.control);
        Identity id = new Identity();
        id.category = current.id.name;
        id.name = Util.generateUUID();
        ObjectPrx rv = this.sf.registerServant(current, id, ip);
        this.allow(rv);
        return InteractiveProcessorPrxHelper.uncheckedCast(rv);
    }

    public ProcessorPrx chooseProcessor() throws ServerError {
        ProcessorPrx[] procs = this.registry.lookupProcessors();
        ProcessorPrx server = this.lookup(Arrays.asList(procs), 15, new ProcessorCheck());
        return server;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultHolder<U> {
        private final CountDownLatch c = new CountDownLatch(1);
        private final int timeout;
        private volatile U rv = null;

        ResultHolder(int timeoutSeconds) {
            this.timeout = timeoutSeconds;
        }

        void set(U obj) {
            if (obj != null) {
                this.rv = obj;
                this.c.countDown();
            }
        }

        U get() {
            try {
                this.c.await(this.timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.rv;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProcessorCheck
    implements RepeatTask<ProcessorPrx> {
        private ProcessorCheck() {
        }

        @Override
        public void requestService(ObjectPrx prx, ResultHolder holder) throws ServerError {
            ProcessorPrx server = ProcessorPrxHelper.checkedCast(prx);
            holder.set(server);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface RepeatTask<U extends ObjectPrx> {
        public void requestService(ObjectPrx var1, ResultHolder var2) throws ServerError;
    }
}

