/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.UserException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ome.model.core.OriginalFile;
import ome.model.roi.Roi;
import ome.parameters.Filter;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.roi.GeomTool;
import ome.services.throttling.Adapter;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import omero.ServerError;
import omero.api.AMD_IRoi_findByAnyIntersection;
import omero.api.AMD_IRoi_findByImage;
import omero.api.AMD_IRoi_findByIntersection;
import omero.api.AMD_IRoi_findByPlane;
import omero.api.AMD_IRoi_findByRoi;
import omero.api.AMD_IRoi_getMeasuredRois;
import omero.api.AMD_IRoi_getMeasuredRoisMap;
import omero.api.AMD_IRoi_getPoints;
import omero.api.AMD_IRoi_getRoiMeasurements;
import omero.api.AMD_IRoi_getRoiStats;
import omero.api.AMD_IRoi_getShapeStats;
import omero.api.AMD_IRoi_getShapeStatsList;
import omero.api.AMD_IRoi_getTable;
import omero.api.RoiOptions;
import omero.api.RoiResult;
import omero.api._IRoiOperations;
import omero.model.OriginalFileI;
import omero.model.Shape;
import omero.util.IceMapper;
import org.apache.commons.collections.map.MultiValueMap;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoiI
extends AbstractAmdServant
implements _IRoiOperations,
ServiceFactoryAware,
BlitzOnly {
    protected ServiceFactoryI factory;
    protected final GeomTool geomTool;

    public RoiI(BlitzExecutor be, GeomTool geomTool) {
        super(null, be);
        this.geomTool = geomTool;
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) {
        this.factory = sf;
    }

    @Override
    public void findByIntersection_async(AMD_IRoi_findByIntersection __cb, final long imageId, final Shape shape, final RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "findByIntersection", new Object[]{imageId, shape}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List<Long> roiIds = RoiI.this.geomTool.findIntersectingRois(imageId, opts, shape);
                if (roiIds == null || roiIds.size() == 0) {
                    return null;
                }
                RoiQueryBuilder qb = new RoiQueryBuilder(roiIds);
                return qb.query(session).list();
            }
        }));
    }

    @Override
    public void findByAnyIntersection_async(AMD_IRoi_findByAnyIntersection __cb, final long imageId, final List<Shape> shapes, final RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "findByAnyIntersection", new Object[]{imageId, shapes}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                if (shapes == null || shapes.size() == 0) {
                    return null;
                }
                List<Long> roiIds = RoiI.this.geomTool.findIntersectingRois(imageId, opts, shapes.toArray(new Shape[shapes.size()]));
                if (roiIds == null || roiIds.size() == 0) {
                    return null;
                }
                RoiQueryBuilder qb = new RoiQueryBuilder(roiIds);
                return qb.query(session).list();
            }
        }));
    }

    @Override
    public void findByImage_async(AMD_IRoi_findByImage __cb, final long imageId, RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "findByImage", new Object[]{imageId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                Query q = session.createQuery("select distinct r from Roi r join r.image i join fetch r.shapes where i.id = :id order by r.id");
                q.setParameter("id", (Object)imageId);
                return q.list();
            }
        }));
    }

    @Override
    public void findByRoi_async(AMD_IRoi_findByRoi __cb, final long roiId, RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "findByRoi", new Object[]{roiId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                RoiQueryBuilder qb = new RoiQueryBuilder(Arrays.asList(roiId));
                return qb.query(session).list();
            }
        }));
    }

    @Override
    public void findByPlane_async(AMD_IRoi_findByPlane __cb, final long imageId, final int z, final int t, RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "findByPlane", new Object[]{imageId, z, t}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                Query q = session.createQuery("select distinct r from Roi r join fetch r.shapes s where r.id = :id and ( s.theZ is null or s.theZ = :z ) and ( s.theT is null or s.theT = :t ) order by r.id");
                q.setParameter("id", (Object)imageId);
                q.setParameter("z", (Object)z);
                q.setParameter("t", (Object)t);
                return q.list();
            }
        }));
    }

    @Override
    public void getPoints_async(AMD_IRoi_getPoints __cb, final long shapeId, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getPoints", new Object[]{shapeId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RoiI.this.geomTool.getPoints(shapeId, session);
            }
        }));
    }

    @Override
    public void getShapeStats_async(AMD_IRoi_getShapeStats __cb, final long shapeId, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getShapeStats", new Object[]{shapeId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RoiI.this.geomTool.getStats(Arrays.asList(new Long[]{Long.valueOf((long)shapeId)})).perShape[0];
            }
        }));
    }

    @Override
    public void getShapeStatsList_async(AMD_IRoi_getShapeStatsList __cb, final List<Long> shapeIdList, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getShapeStatsList", new Object[]{shapeIdList}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return Arrays.asList(RoiI.this.geomTool.getStats((List<Long>)shapeIdList).perShape);
            }
        }));
    }

    @Override
    public void getRoiStats_async(AMD_IRoi_getRoiStats __cb, final long roiId, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getRoiStats", new Object[]{roiId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List<Long> shapesInRoi = RoiI.this.geomTool.getShapeIds(roiId);
                return RoiI.this.geomTool.getStats(shapesInRoi);
            }
        }));
    }

    @Override
    public void getRoiMeasurements_async(AMD_IRoi_getRoiMeasurements __cb, final long imageId, final RoiOptions opts, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.FILTERABLE_COLLECTION);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getRoiMeasurements", new Object[]{imageId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                QueryBuilder qb = new QueryBuilder();
                qb.select(new String[]{"distinct fa"});
                qb.from("Image", "i");
                qb.append(", Roi roi ");
                qb.join("roi.annotationLinks", "rlinks", false, false);
                qb.join("rlinks.child", "rfa", false, false);
                qb.join("i.wellSamples", "ws", false, false);
                qb.join("ws.well", "well", false, false);
                qb.join("well.plate", "plate", false, false);
                qb.join("plate.annotationLinks", "links", false, false);
                qb.join("links.child", "fa", false, false);
                qb.where();
                qb.and("fa.ns = 'openmicroscopy.org/omero/measurement'");
                qb.and("rfa.id = fa.id");
                qb.and("i.id = :id");
                qb.param("id", (Object)imageId);
                qb.filter("fa", RoiI.this.filter(opts));
                return qb.query(session).list();
            }
        }));
    }

    protected List<Roi> loadMeasuredRois(Session session, long imageId, long annotationId) {
        Query q = session.createQuery("select distinct r from Roi r join r.image i join fetch r.shapes join i.wellSamples ws join ws.well well join well.plate plate join plate.annotationLinks links join links.child a where a.id = :aid and i.id = :iid order by r.id");
        q.setParameter("iid", (Object)imageId);
        q.setParameter("aid", (Object)annotationId);
        return q.list();
    }

    @Override
    public void getMeasuredRoisMap_async(AMD_IRoi_getMeasuredRoisMap __cb, final long imageId, final List<Long> annotationIds, RoiOptions opts, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(new RoiResultMapReturnMapper(opts));
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getMeasuredRoisMap", new Object[]{imageId, annotationIds}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                if (annotationIds == null) {
                    return null;
                }
                HashMap<Long, List<Roi>> rv = new HashMap<Long, List<Roi>>();
                for (Long annotationId : annotationIds) {
                    rv.put(annotationId, RoiI.this.loadMeasuredRois(session, imageId, annotationId));
                }
                return rv;
            }
        }));
    }

    @Override
    public void getMeasuredRois_async(AMD_IRoi_getMeasuredRois __cb, final long imageId, final long annotationId, RoiOptions opts, Current __current) throws ServerError {
        RoiResultMapper mapper = new RoiResultMapper(opts);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getMeasuredRois", new Object[]{imageId, annotationId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RoiI.this.loadMeasuredRois(session, imageId, annotationId);
            }
        }));
    }

    @Override
    public void getTable_async(AMD_IRoi_getTable __cb, final long annotationId, final Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getTable", new Object[]{annotationId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                QueryBuilder qb = new QueryBuilder();
                qb.select(new String[]{"f"});
                qb.from("FileAnnotation", "fa");
                qb.join("fa.file", "f", false, false);
                qb.where();
                qb.and("fa.id = :id");
                qb.param("id", (Object)annotationId);
                OriginalFile file = (OriginalFile)qb.query(session).uniqueResult();
                try {
                    return RoiI.this.factory.sharedResources(__current).openTable(new OriginalFileI(file.getId(), false));
                }
                catch (ServerError e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }));
    }

    private Filter filter(RoiOptions opts) {
        Filter f = new Filter();
        if (opts != null) {
            if (opts.userId != null) {
                f.owner(opts.userId.getValue());
            }
            if (opts.groupId != null) {
                f.group(opts.groupId.getValue());
            }
            Integer offset = null;
            Integer limit = null;
            if (opts.offset != null) {
                offset = opts.offset.getValue();
            }
            if (opts.limit != null) {
                limit = opts.limit.getValue();
            }
            if (offset != null || limit != null) {
                f.page(offset, limit);
            }
        }
        return f;
    }

    public static class RoiResultMapReturnMapper
    implements IceMapper.ReturnMapping {
        private final RoiOptions opts;

        public RoiResultMapReturnMapper(RoiOptions opts) {
            this.opts = opts;
        }

        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            HashMap rv = new HashMap();
            Map iv = (Map)value;
            RoiResultMapper m = new RoiResultMapper(this.opts);
            for (Map.Entry entry : iv.entrySet()) {
                rv.put(entry.getKey(), (RoiResult)((Object)m.mapReturnValue(entry.getValue())));
            }
            return rv;
        }
    }

    public static class RoiResultReturnMapper
    implements IceMapper.ReturnMapping {
        private final RoiOptions opts;

        public RoiResultReturnMapper(RoiOptions opts) {
            this.opts = opts;
        }

        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            List rois;
            RoiResult result = new RoiResult();
            result.opts = this.opts;
            if (value == null) {
                result.rois = Collections.emptyList();
                result.byZ = Collections.emptyMap();
                result.byT = Collections.emptyMap();
                result.byG = Collections.emptyMap();
                result.groups = Collections.emptyMap();
                return result;
            }
            result.rois = rois = (List)IceMapper.FILTERABLE_COLLECTION.mapReturnValue(mapper, value);
            MultiValueMap byZ = new MultiValueMap();
            MultiValueMap byT = new MultiValueMap();
            MultiValueMap byG = new MultiValueMap();
            for (omero.model.Roi roi : rois) {
                omero.model.RoiI roii = (omero.model.RoiI)roi;
                Iterator it = roii.iterateShapes();
                while (it.hasNext()) {
                    Shape shape = (Shape)it.next();
                    if (shape.getTheT() != null) {
                        byT.put((Object)shape.getTheT().getValue(), (Object)shape);
                    } else {
                        byT.put((Object)-1, (Object)shape);
                    }
                    if (shape.getTheZ() != null) {
                        byZ.put((Object)shape.getTheZ().getValue(), (Object)shape);
                    } else {
                        byZ.put((Object)-1, (Object)shape);
                    }
                    if (shape.getG() != null) {
                        byG.put((Object)shape.getG().getValue(), (Object)shape);
                        continue;
                    }
                    byG.put((Object)"", (Object)shape);
                }
                result.byG = byG;
                result.byZ = byZ;
                result.byT = byT;
            }
            return result;
        }
    }

    public static class RoiResultMapper
    extends IceMapper {
        public RoiResultMapper(RoiOptions opts) {
            super(new RoiResultReturnMapper(opts));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoiQueryBuilder
    extends QueryBuilder {
        RoiQueryBuilder(List<Long> roiIds) {
            this.paramList("ids", roiIds);
            this.select(new String[]{"distinct r"});
            this.from("Roi", "r");
            this.join("r.shapes", "s", false, true);
            this.where();
        }

        public Query query(Session session) {
            this.and("r.id in (:ids)");
            this.append("order by r.id");
            return super.query(session);
        }
    }
}

