/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.UserException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.InternalException;
import ome.formats.OMEROMetadataStore;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.screen.Plate;
import ome.model.screen.Well;
import ome.model.screen.WellSample;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.roi.PopulateRoiJob;
import ome.services.throttling.Adapter;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.ServiceFactory;
import ome.tools.spring.InternalServiceFactory;
import omero.RBool;
import omero.RDouble;
import omero.RFloat;
import omero.RInt;
import omero.RLong;
import omero.RMap;
import omero.RString;
import omero.ServerError;
import omero.api.AMD_MetadataStore_createRoot;
import omero.api.AMD_MetadataStore_populateMinMax;
import omero.api.AMD_MetadataStore_postProcess;
import omero.api.AMD_MetadataStore_saveToDB;
import omero.api.AMD_MetadataStore_updateObjects;
import omero.api.AMD_MetadataStore_updateReferences;
import omero.api.AMD_StatefulServiceInterface_activate;
import omero.api.AMD_StatefulServiceInterface_close;
import omero.api.AMD_StatefulServiceInterface_getCurrentEventContext;
import omero.api.AMD_StatefulServiceInterface_passivate;
import omero.api._MetadataStoreOperations;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.SharedResourcesPrx;
import omero.metadatastore.IObjectContainer;
import omero.model.ScriptJob;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataStoreI
extends AbstractAmdServant
implements _MetadataStoreOperations,
ServiceFactoryAware,
BlitzOnly {
    private static final Log log = LogFactory.getLog(MetadataStoreI.class);
    protected final Set<Long> savedPlates = new HashSet<Long>();
    protected OMEROMetadataStore store;
    protected ServiceFactoryI sf;
    protected PopulateRoiJob popRoi;

    public MetadataStoreI(BlitzExecutor be, PopulateRoiJob popRoi) throws Exception {
        super(null, be);
        this.popRoi = popRoi;
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.sf = sf;
    }

    @Override
    public void onSetOmeroContext(OmeroContext ctx) throws Exception {
        InternalServiceFactory sf = new InternalServiceFactory(ctx);
        this.store = new OMEROMetadataStore((ServiceFactory)sf);
    }

    private <T extends IObject> T safeReverse(Object o, IceMapper mapper) {
        try {
            return (T)((IObject)mapper.reverse(o));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to safely reverse: " + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePixels(List<Pixels> pixels) {
        Set<Long> set = this.savedPlates;
        synchronized (set) {
            for (Pixels p : pixels) {
                Image i = p.getImage();
                if (i == null) continue;
                for (WellSample ws : i.unmodifiableWellSamples()) {
                    Plate plate;
                    Well w = ws.getWell();
                    if (w == null || (plate = w.getPlate()) == null) continue;
                    this.savedPlates.add(plate.getId());
                }
            }
        }
    }

    @Override
    public void createRoot_async(AMD_MetadataStore_createRoot __cb, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "createRoot", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                MetadataStoreI.this.store.createRoot();
                return null;
            }
        }));
    }

    @Override
    public void populateMinMax_async(AMD_MetadataStore_populateMinMax __cb, final double[][][] imageChannelGlobalMinMax, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "populateMinMax", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                MetadataStoreI.this.store.populateMinMax(imageChannelGlobalMinMax);
                return null;
            }
        }));
    }

    @Override
    public void saveToDB_async(AMD_MetadataStore_saveToDB __cb, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.FILTERABLE_COLLECTION);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "saveToDb", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                List pix = MetadataStoreI.this.store.saveToDB();
                MetadataStoreI.this.parsePixels(pix);
                return pix;
            }
        }));
    }

    @Override
    public void updateObjects_async(AMD_MetadataStore_updateObjects __cb, final IObjectContainer[] objects, Current __current) throws ServerError {
        final IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "updateObjects", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                for (IObjectContainer o : objects) {
                    IObject sourceObject;
                    try {
                        sourceObject = (IObject)mapper.reverse(o.sourceObject);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    MetadataStoreI.this.store.updateObject(o.LSID, sourceObject, o.indexes);
                }
                return null;
            }
        }));
    }

    @Override
    public void updateReferences_async(AMD_MetadataStore_updateReferences __cb, final Map<String, String[]> references, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "updateReferences", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                MetadataStoreI.this.store.updateReferences(references);
                return null;
            }
        }));
    }

    @Override
    public void postProcess_async(AMD_MetadataStore_postProcess __cb, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        final ArrayList copy = new ArrayList();
        final ArrayList procs = new ArrayList();
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "postProcess", new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory _sf) {
                Set<Long> set = MetadataStoreI.this.savedPlates;
                synchronized (set) {
                    copy.addAll(MetadataStoreI.this.savedPlates);
                    if (copy.size() == 0) {
                        return null;
                    }
                    for (Long id : copy) {
                        RMap inputs = rtypes.rmap("plate_id", rtypes.rlong(id));
                        ScriptJob job = MetadataStoreI.this.popRoi.createJob();
                        try {
                            SharedResourcesPrx sr = MetadataStoreI.this.sf.sharedResources();
                            InteractiveProcessorPrx prx = sr.acquireProcessor(job, 15);
                            prx.execute(inputs);
                            prx.setDetach(true);
                            procs.add(prx);
                            log.info((Object)("Launched populateroi.py on plate " + id));
                        }
                        catch (ServerError e) {
                            String msg = "Error acquiring post processor";
                            log.error((Object)msg, (Throwable)((Object)e));
                            throw new InternalException(msg);
                        }
                    }
                    MetadataStoreI.this.savedPlates.clear();
                    return procs;
                }
            }
        }));
    }

    public Integer toJavaType(RInt x) {
        return x == null ? null : Integer.valueOf(x.getValue());
    }

    public Long toJavaType(RLong x) {
        return x == null ? null : Long.valueOf(x.getValue());
    }

    public Boolean toJavaType(RBool x) {
        return x == null ? null : Boolean.valueOf(x.getValue());
    }

    public Float toJavaType(RFloat x) {
        return x == null ? null : Float.valueOf(x.getValue());
    }

    public Double toJavaType(RDouble x) {
        return x == null ? null : Double.valueOf(x.getValue());
    }

    public String toJavaType(RString x) {
        return x == null ? null : x.getValue();
    }

    @Override
    public void activate_async(AMD_StatefulServiceInterface_activate __cb, Current __current) {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "activate", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return null;
            }
        }));
    }

    @Override
    public void passivate_async(AMD_StatefulServiceInterface_passivate __cb, Current __current) {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "passivate", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return null;
            }
        }));
    }

    @Override
    public void close_async(AMD_StatefulServiceInterface_close __cb, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "close", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                MetadataStoreI.this.store = null;
                return null;
            }
        }));
    }

    @Override
    public void getCurrentEventContext_async(AMD_StatefulServiceInterface_getCurrentEventContext __cb, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(new IceMapper.ReturnMapping(){

            public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
                return IceMapper.convert((EventContext)value);
            }
        });
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "getCurrentEventContext", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return null;
            }
        }));
    }
}

