/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import omero.RDouble;
import omero.RInt;
import omero.model.Binning;
import omero.model.DetectorSettings;
import omero.model.DetectorSettingsI;
import omero.model.Dichroic;
import omero.model.Filter;
import omero.model.FilterSet;
import omero.model.LightSettings;
import omero.model.LightSettingsI;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.rtypes;
import pojos.DataObject;
import pojos.DetectorData;
import pojos.DichroicData;
import pojos.FilterData;
import pojos.LightSourceData;

public class ChannelAcquisitionData
extends DataObject {
    private DetectorSettings detectorSettings;
    private LightSettings lightSettings;
    private FilterSet filterSet;
    private FilterData secondaryEmFilter;
    private FilterData secondaryExFilter;
    private FilterData emFilter;
    private FilterData exFilter;
    private DichroicData dichroic;
    private LightSourceData ligthSource;
    private boolean detectorSettingsDirty;
    private boolean ligthSourceSettingsDirty;
    private DetectorData detector;
    private Binning binning;

    public ChannelAcquisitionData(LogicalChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(channel);
        this.detectorSettings = channel.getDetectorSettings();
        this.lightSettings = channel.getLightSourceSettings();
        this.filterSet = channel.getFilterSet();
        Filter f = channel.getSecondaryEmissionFilter();
        if (f != null) {
            this.secondaryEmFilter = new FilterData(f);
        }
        if ((f = channel.getSecondaryExcitationFilter()) != null) {
            this.secondaryExFilter = new FilterData(f);
        }
        if (this.filterSet != null) {
            Dichroic d;
            f = this.filterSet.getEmFilter();
            if (f != null) {
                this.emFilter = new FilterData(f);
            }
            if ((f = this.filterSet.getExFilter()) != null) {
                this.exFilter = new FilterData(f);
            }
            if ((d = this.filterSet.getDichroic()) != null) {
                this.dichroic = new DichroicData(d);
            }
        }
    }

    public FilterData getEmissionFilter() {
        return this.emFilter;
    }

    public FilterData getExcitationFilter() {
        return this.exFilter;
    }

    public DichroicData getDichroic() {
        return this.dichroic;
    }

    public DetectorData getDetector() {
        if (this.detectorSettings == null) {
            return null;
        }
        if (this.detector == null) {
            this.detector = new DetectorData(this.detectorSettings.getDetector());
        }
        return this.detector;
    }

    public Double getDetectorSettingsOffset() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getOffsetValue();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Double getDetectorSettingsGain() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getGain();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Double getDetectorSettingsVoltage() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getVoltage();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Double getDetectorSettingsReadOutRate() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getReadOutRate();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public String getDetectorSettingsBinning() {
        if (this.detectorSettings == null) {
            return "";
        }
        Binning value = this.detectorSettings.getBinning();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public Double getLigthSettingsAttenuation() {
        if (this.lightSettings == null) {
            return null;
        }
        RDouble value = this.lightSettings.getAttenuation();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Integer getLigthSettingsWavelength() {
        if (this.lightSettings == null) {
            return null;
        }
        RInt value = this.lightSettings.getWavelength();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public FilterData getSecondaryEmissionFilter() {
        return this.secondaryEmFilter;
    }

    public FilterData getSecondaryExcitationFilter() {
        return this.secondaryExFilter;
    }

    public boolean hasFilter() {
        return this.filterSet != null;
    }

    public boolean hasDectector() {
        return this.getDetector() != null;
    }

    public void setLigthSettingsAttenuation(double value) {
        this.ligthSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setAttenuation(rtypes.rdouble(value));
    }

    public void setLigthSettingsWavelength(int value) {
        this.ligthSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setWavelength(rtypes.rint(value));
    }

    public void setDetectorSettingOffset(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setOffsetValue(rtypes.rdouble(value));
    }

    public void setDetectorSettingsGain(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setGain(rtypes.rdouble(value));
    }

    public void setDetectorSettingsReadOutRate(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setReadOutRate(rtypes.rdouble(value));
    }

    public void setDetectorSettingsVoltage(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setVoltage(rtypes.rdouble(value));
    }

    public void setDetectorSettingBinning(Binning binning) {
        this.binning = binning;
    }

    public Binning getDetectorBinningAsEnum() {
        return this.binning;
    }

    public boolean isDetectorSettingsDirty() {
        return this.detectorSettingsDirty;
    }

    public boolean isLightSourceSettingsDirty() {
        return this.ligthSourceSettingsDirty;
    }

    public LightSourceData getLightSource() {
        if (this.lightSettings == null) {
            return null;
        }
        if (this.ligthSource != null) {
            return this.ligthSource;
        }
        LightSource src = this.lightSettings.getLightSource();
        if (src != null) {
            this.ligthSource = new LightSourceData(src);
        }
        return this.ligthSource;
    }
}

