/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Dichroic;
import omero.model.IObject;
import omero.model.Instrument;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DichroicI
extends Dichroic
implements ModelBased {
    public static final String MANUFACTURER = "ome.model.acquisition.Dichroic_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Dichroic_model";
    public static final String LOTNUMBER = "ome.model.acquisition.Dichroic_lotNumber";
    public static final String INSTRUMENT = "ome.model.acquisition.Dichroic_instrument";
    public static final String DETAILS = "ome.model.acquisition.Dichroic_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public DichroicI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public DichroicI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public DichroicI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadManufacturer();
        this.unloadModel();
        this.unloadLotNumber();
        this.unloadInstrument();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        DichroicI copy = new DichroicI();
        copy.id = this.id;
        copy.version = this.version;
        copy.manufacturer = this.manufacturer;
        copy.model = this.model;
        copy.lotNumber = this.lotNumber;
        copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new DichroicI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadManufacturer() {
        this.manufacturer = null;
    }

    @Override
    public RString getManufacturer(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(RString manufacturer, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.manufacturer = manufacturer;
    }

    private void copyManufacturer(ome.model.acquisition.Dichroic source, IceMapper mapper) {
        this.manufacturer = source.getManufacturer() == null ? null : rtypes.rstring(source.getManufacturer());
    }

    private void fillManufacturer(ome.model.acquisition.Dichroic target, IceMapper mapper) {
        try {
            target.setManufacturer((String)mapper.fromRType(this.getManufacturer()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadModel() {
        this.model = null;
    }

    @Override
    public RString getModel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.model;
    }

    @Override
    public void setModel(RString model, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.model = model;
    }

    private void copyModel(ome.model.acquisition.Dichroic source, IceMapper mapper) {
        this.model = source.getModel() == null ? null : rtypes.rstring(source.getModel());
    }

    private void fillModel(ome.model.acquisition.Dichroic target, IceMapper mapper) {
        try {
            target.setModel((String)mapper.fromRType(this.getModel()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadLotNumber() {
        this.lotNumber = null;
    }

    @Override
    public RString getLotNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lotNumber;
    }

    @Override
    public void setLotNumber(RString lotNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lotNumber = lotNumber;
    }

    private void copyLotNumber(ome.model.acquisition.Dichroic source, IceMapper mapper) {
        this.lotNumber = source.getLotNumber() == null ? null : rtypes.rstring(source.getLotNumber());
    }

    private void fillLotNumber(ome.model.acquisition.Dichroic target, IceMapper mapper) {
        try {
            target.setLotNumber((String)mapper.fromRType(this.getLotNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.acquisition.Dichroic source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.acquisition.Dichroic target, IceMapper mapper) {
        target.putAt(INSTRUMENT, mapper.reverse((ModelBased)((Object)this.getInstrument())));
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.Dichroic) {
            ome.model.acquisition.Dichroic source = (ome.model.acquisition.Dichroic)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyManufacturer(source, mapper);
                this.copyModel(source, mapper);
                this.copyLotNumber(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Dichroic cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.Dichroic target = new ome.model.acquisition.Dichroic();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillManufacturer(target, mapper);
            this.fillModel(target, mapper);
            this.fillLotNumber(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<DichroicI> cast(List list) {
        return list;
    }
}

