/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.MarshalException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Buffer {
    public ByteBuffer b;
    public ByteBuffer _emptyBuffer;
    private int _size;
    private int _capacity;
    private int _maxCapacity;
    private int _shrinkCounter;
    private static final boolean DIRECT = false;

    public Buffer(int maxCapacity) {
        this.b = this._emptyBuffer = ByteBuffer.allocate(0);
        this._size = 0;
        this._capacity = 0;
        this._maxCapacity = maxCapacity;
    }

    public int size() {
        return this._size;
    }

    public boolean empty() {
        return this._size == 0;
    }

    public void clear() {
        this.b = this._emptyBuffer;
        this._size = 0;
        this._capacity = 0;
    }

    public void expand(int n) {
        int sz;
        int n2 = sz = this.b == this._emptyBuffer ? n : this.b.position() + n;
        if (sz > this._size) {
            this.resize(sz, false);
        }
    }

    public void resize(int n, boolean reading) {
        if (n == 0) {
            this.clear();
        } else if (n > this._capacity) {
            this.reserve(n);
        }
        this._size = n;
        if (reading) {
            this.b.limit(this._size);
        }
    }

    public void reset() {
        if (this._size > 0 && this._size * 2 < this._capacity) {
            if (++this._shrinkCounter > 2) {
                this.reserve(this._size);
                this._shrinkCounter = 0;
            }
        } else {
            this._shrinkCounter = 0;
        }
        this._size = 0;
        if (this.b != this._emptyBuffer) {
            this.b.limit(this.b.capacity());
            this.b.position(0);
        }
    }

    private void reserve(int n) {
        if (n > this._capacity) {
            this._capacity = Math.max(n, Math.min(2 * this._capacity, this._maxCapacity));
            this._capacity = Math.max(240, this._capacity);
        } else if (n < this._capacity) {
            this._capacity = n;
        } else {
            return;
        }
        try {
            ByteBuffer buf = ByteBuffer.allocate(this._capacity);
            if (this.b == this._emptyBuffer) {
                this.b = buf;
            } else {
                int pos = this.b.position();
                this.b.position(0);
                this.b.limit(Math.min(this._capacity, this.b.capacity()));
                buf.put(this.b);
                this.b = buf;
                this.b.limit(this.b.capacity());
                this.b.position(pos);
            }
            this.b.order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (OutOfMemoryError ex) {
            MarshalException e = new MarshalException();
            e.reason = "OutOfMemoryError occurred while allocating a ByteBuffer";
            e.initCause(ex);
            throw e;
        }
    }
}

