/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.ContextHelper;
import Ice.ImplicitContext;
import Ice.InitializationException;
import IceInternal.BasicStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImplicitContextI
implements ImplicitContext {
    public static ImplicitContextI create(String kind) {
        if (kind.equals("None") || kind.equals("")) {
            return null;
        }
        if (kind.equals("Shared")) {
            return new Shared();
        }
        if (kind.equals("PerThread")) {
            return new PerThread();
        }
        throw new InitializationException("'" + kind + "' is not a valid value for Ice.ImplicitContext");
    }

    public abstract void write(Map<String, String> var1, BasicStream var2);

    abstract Map<String, String> combine(Map<String, String> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerThread
    extends ImplicitContextI {
        private Map<Thread, Map<String, String>> _map = Collections.synchronizedMap(new HashMap());

        PerThread() {
        }

        public Map getContext() {
            Map<String, String> threadContext = this._map.get(Thread.currentThread());
            if (threadContext == null) {
                threadContext = new HashMap<String, String>();
            }
            return threadContext;
        }

        public void setContext(Map context) {
            if (context == null || context.isEmpty()) {
                this._map.remove(Thread.currentThread());
            } else {
                HashMap threadContext = new HashMap(context);
                this._map.put(Thread.currentThread(), threadContext);
            }
        }

        @Override
        public boolean containsKey(String key) {
            Map<String, String> threadContext;
            if (key == null) {
                key = "";
            }
            if ((threadContext = this._map.get(Thread.currentThread())) == null) {
                return false;
            }
            return threadContext.containsKey(key);
        }

        @Override
        public String get(String key) {
            Map<String, String> threadContext;
            if (key == null) {
                key = "";
            }
            if ((threadContext = this._map.get(Thread.currentThread())) == null) {
                return "";
            }
            String val = threadContext.get(key);
            if (val == null) {
                val = "";
            }
            return val;
        }

        @Override
        public String put(String key, String value) {
            String oldVal;
            Thread currentThread;
            Map<String, String> threadContext;
            if (key == null) {
                key = "";
            }
            if (value == null) {
                value = "";
            }
            if ((threadContext = this._map.get(currentThread = Thread.currentThread())) == null) {
                threadContext = new HashMap<String, String>();
                this._map.put(currentThread, threadContext);
            }
            if ((oldVal = threadContext.put(key, value)) == null) {
                oldVal = "";
            }
            return oldVal;
        }

        @Override
        public String remove(String key) {
            Map<String, String> threadContext;
            if (key == null) {
                key = "";
            }
            if ((threadContext = this._map.get(Thread.currentThread())) == null) {
                return null;
            }
            String val = threadContext.remove(key);
            if (val == null) {
                val = "";
            }
            return val;
        }

        @Override
        public void write(Map<String, String> prxContext, BasicStream os) {
            Map<String, String> threadContext = this._map.get(Thread.currentThread());
            if (threadContext == null || threadContext.isEmpty()) {
                ContextHelper.write(os, prxContext);
            } else if (prxContext.isEmpty()) {
                ContextHelper.write(os, threadContext);
            } else {
                HashMap<String, String> combined = new HashMap<String, String>(threadContext);
                combined.putAll(prxContext);
                ContextHelper.write(os, combined);
            }
        }

        @Override
        Map<String, String> combine(Map<String, String> prxContext) {
            Map<String, String> threadContext = this._map.get(Thread.currentThread());
            HashMap<String, String> combined = new HashMap<String, String>(threadContext);
            combined.putAll(prxContext);
            return combined;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Shared
    extends ImplicitContextI {
        private Map<String, String> _context = new HashMap<String, String>();

        Shared() {
        }

        public synchronized Map getContext() {
            return new HashMap<String, String>(this._context);
        }

        public synchronized void setContext(Map context) {
            this._context.clear();
            if (context != null && !context.isEmpty()) {
                this._context.putAll(context);
            }
        }

        @Override
        public synchronized boolean containsKey(String key) {
            if (key == null) {
                key = "";
            }
            return this._context.containsKey(key);
        }

        @Override
        public synchronized String get(String key) {
            String val;
            if (key == null) {
                key = "";
            }
            if ((val = this._context.get(key)) == null) {
                val = "";
            }
            return val;
        }

        @Override
        public synchronized String put(String key, String value) {
            String oldVal;
            if (key == null) {
                key = "";
            }
            if (value == null) {
                value = "";
            }
            if ((oldVal = this._context.put(key, value)) == null) {
                oldVal = "";
            }
            return oldVal;
        }

        @Override
        public synchronized String remove(String key) {
            String val;
            if (key == null) {
                key = "";
            }
            if ((val = this._context.remove(key)) == null) {
                val = "";
            }
            return val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Map<String, String> prxContext, BasicStream os) {
            if (prxContext.isEmpty()) {
                Shared shared = this;
                synchronized (shared) {
                    ContextHelper.write(os, this._context);
                }
            }
            Map<String, String> ctx = null;
            Shared shared = this;
            synchronized (shared) {
                ctx = this._context.isEmpty() ? prxContext : this.combine(prxContext);
            }
            ContextHelper.write(os, ctx);
        }

        @Override
        synchronized Map<String, String> combine(Map<String, String> prxContext) {
            HashMap<String, String> combined = new HashMap<String, String>(this._context);
            combined.putAll(prxContext);
            return combined;
        }
    }
}

