/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;

public class MicromanagerReader
extends FormatReader {
    public static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String METADATA = "metadata.txt";
    private MinimalTiffReader tiffReader;
    private Vector<String> tiffs;
    private String metadataFile;
    private String[] channels;
    private String comment;
    private String time;
    private Float exposureTime;
    private Float sliceThickness;
    private Float pixelSize;
    private Float[] timestamps;
    private int gain;
    private String binning;
    private String detectorID;
    private String detectorModel;
    private String detectorManufacturer;
    private float temperature;
    private Vector<Float> voltage;
    private String cameraRef;
    private String cameraMode;

    public MicromanagerReader() {
        super("Micro-Manager", new String[]{"tif", "tiff", "txt"});
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (name.equals(METADATA) || name.endsWith(File.separator + METADATA)) {
            try {
                RandomAccessInputStream stream = new RandomAccessInputStream(name);
                long length = stream.length();
                stream.close();
                return length > 0L;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (!open) {
            return false;
        }
        try {
            Location parent = new Location(name).getAbsoluteFile().getParentFile();
            Location metaFile = new Location(parent, METADATA);
            return metaFile.exists() && metaFile.length() > 0L;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.tiffReader.isThisType(stream);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.add(this.metadataFile);
        if (!noPixels) {
            files.addAll(this.tiffs);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] coords = this.getZCTCoords(no);
        this.tiffReader.setId(this.tiffs.get(no));
        return this.tiffReader.openBytes(0, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReader != null) {
            this.tiffReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiffReader = null;
            this.tiffs = null;
            this.time = null;
            this.comment = null;
            this.pixelSize = null;
            this.sliceThickness = null;
            this.exposureTime = null;
            this.timestamps = null;
            this.metadataFile = null;
            this.channels = null;
            this.gain = 0;
            this.detectorManufacturer = null;
            this.detectorModel = null;
            this.detectorID = null;
            this.binning = null;
            this.temperature = 0.0f;
            this.voltage = null;
            this.cameraMode = null;
            this.cameraRef = null;
        }
    }

    public void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.tiffReader = new MinimalTiffReader();
        this.status("Reading metadata file");
        Location file = new Location(this.currentId).getAbsoluteFile();
        this.metadataFile = file.exists() ? new Location(file.getParentFile(), METADATA).getAbsolutePath() : METADATA;
        this.in = new RandomAccessInputStream(this.metadataFile);
        String parent = file.exists() ? file.getParentFile().getAbsolutePath() + File.separator : "";
        byte[] meta = new byte[(int)this.in.length()];
        this.in.read(meta);
        String s = new String(meta);
        meta = null;
        this.status("Finding image file names");
        String baseTiff = null;
        this.tiffs = new Vector();
        int pos = 0;
        while ((pos = s.indexOf("FileName", pos)) != -1 && (long)pos < this.in.length()) {
            String name = s.substring(s.indexOf(":", pos), s.indexOf(",", pos));
            baseTiff = parent + name.substring(3, name.length() - 1);
            ++pos;
        }
        this.status("Populating metadata");
        Vector<Float> stamps = new Vector<Float>();
        this.voltage = new Vector();
        StringTokenizer st = new StringTokenizer(s, "\n");
        int[] slice = new int[3];
        while (st.hasMoreTokens()) {
            boolean closed;
            String token = st.nextToken().trim();
            boolean open = token.indexOf("[") != -1;
            boolean bl = closed = token.indexOf("]") != -1;
            if (open || !open && !closed && !token.equals("{") && !token.startsWith("}")) {
                int quote = token.indexOf("\"") + 1;
                String key = token.substring(quote, token.indexOf("\"", quote));
                String value = null;
                if (open == closed) {
                    value = token.substring(token.indexOf(":") + 1);
                } else if (!closed) {
                    StringBuffer valueBuffer = new StringBuffer();
                    while (!closed) {
                        token = st.nextToken();
                        closed = token.indexOf("]") != -1;
                        valueBuffer.append(token);
                    }
                    value = valueBuffer.toString();
                    value = value.replaceAll("\n", "");
                }
                int startIndex = value.indexOf("[");
                int endIndex = value.indexOf("]");
                if (endIndex == -1) {
                    endIndex = value.length();
                }
                value = value.substring(startIndex + 1, endIndex).trim();
                value = value.substring(0, value.length() - 1);
                if ((value = value.replaceAll("\"", "")).endsWith(",")) {
                    value = value.substring(0, value.length() - 1);
                }
                this.addGlobalMeta(key, value);
                if (key.equals("Channels")) {
                    this.core[0].sizeC = Integer.parseInt(value);
                } else if (key.equals("ChNames")) {
                    StringTokenizer t = new StringTokenizer(value, ",");
                    int nTokens = t.countTokens();
                    this.channels = new String[nTokens];
                    for (int q = 0; q < nTokens; ++q) {
                        this.channels[q] = t.nextToken().replaceAll("\"", "").trim();
                    }
                } else if (key.equals("Frames")) {
                    this.core[0].sizeT = Integer.parseInt(value);
                } else if (key.equals("Slices")) {
                    this.core[0].sizeZ = Integer.parseInt(value);
                } else if (key.equals("PixelSize_um")) {
                    this.pixelSize = new Float(value);
                } else if (key.equals("z-step_um")) {
                    this.sliceThickness = new Float(value);
                } else if (key.equals("Time")) {
                    this.time = value;
                } else if (key.equals("Comment")) {
                    this.comment = value;
                }
            }
            if (!token.startsWith("\"FrameKey")) continue;
            int dash = token.indexOf("-") + 1;
            int nextDash = token.indexOf("-", dash);
            slice[2] = Integer.parseInt(token.substring(dash, nextDash));
            dash = nextDash + 1;
            nextDash = token.indexOf("-", dash);
            slice[1] = Integer.parseInt(token.substring(dash, nextDash));
            dash = nextDash + 1;
            slice[0] = Integer.parseInt(token.substring(dash, token.indexOf("\"", dash)));
            token = st.nextToken().trim();
            String key = "";
            String value = "";
            while (!token.startsWith("}")) {
                int colon = token.indexOf(":");
                key = token.substring(1, colon).trim();
                value = token.substring(colon + 1, token.length() - 1).trim();
                key = key.replaceAll("\"", "");
                value = value.replaceAll("\"", "");
                this.addGlobalMeta(key, value);
                if (key.equals("Exposure-ms")) {
                    float t = Float.parseFloat(value);
                    this.exposureTime = new Float(t / 1000.0f);
                } else if (key.equals("ElapsedTime-ms")) {
                    float t = Float.parseFloat(value);
                    stamps.add(new Float(t / 1000.0f));
                } else if (key.equals("Core-Camera")) {
                    this.cameraRef = value;
                } else if (key.equals(this.cameraRef + "-Binning")) {
                    this.binning = value.indexOf("x") != -1 ? value : value + "x" + value;
                } else if (key.equals(this.cameraRef + "-CameraID")) {
                    this.detectorID = value;
                } else if (key.equals(this.cameraRef + "-CameraName")) {
                    this.detectorModel = value;
                } else if (key.equals(this.cameraRef + "-Gain")) {
                    this.gain = Integer.parseInt(value);
                } else if (key.equals(this.cameraRef + "-Name")) {
                    this.detectorManufacturer = value;
                } else if (key.equals(this.cameraRef + "-Temperature")) {
                    this.temperature = Float.parseFloat(value);
                } else if (key.equals(this.cameraRef + "-CCDMode")) {
                    this.cameraMode = value;
                } else if (key.startsWith("DAC-") && key.endsWith("-Volts")) {
                    this.voltage.add(new Float(value));
                }
                token = st.nextToken().trim();
            }
        }
        this.timestamps = stamps.toArray(new Float[stamps.size()]);
        Arrays.sort((Object[])this.timestamps);
        String prefix = "";
        if (baseTiff.indexOf(File.separator) != -1) {
            prefix = baseTiff.substring(0, baseTiff.lastIndexOf(File.separator) + 1);
            baseTiff = baseTiff.substring(baseTiff.lastIndexOf(File.separator) + 1);
        }
        String[] blocks = baseTiff.split("_");
        StringBuffer filename = new StringBuffer();
        for (int t = 0; t < this.getSizeT(); ++t) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    int q;
                    filename.append(prefix);
                    filename.append(blocks[0]);
                    filename.append("_");
                    int zeros = blocks[1].length() - String.valueOf(t).length();
                    for (q = 0; q < zeros; ++q) {
                        filename.append("0");
                    }
                    filename.append(t);
                    filename.append("_");
                    filename.append(this.channels[c]);
                    filename.append("_");
                    zeros = blocks[3].length() - String.valueOf(z).length() - 4;
                    for (q = 0; q < zeros; ++q) {
                        filename.append("0");
                    }
                    filename.append(z);
                    filename.append(".tif");
                    this.tiffs.add(filename.toString());
                    filename.delete(0, filename.length());
                }
            }
        }
        this.tiffReader.setId(this.tiffs.get(0));
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = this.tiffs.size() / this.getSizeC();
        }
        this.core[0].sizeX = this.tiffReader.getSizeX();
        this.core[0].sizeY = this.tiffReader.getSizeY();
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].pixelType = this.tiffReader.getPixelType();
        this.core[0].rgb = this.tiffReader.isRGB();
        this.core[0].interleaved = false;
        this.core[0].littleEndian = this.tiffReader.isLittleEndian();
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setImageDescription(this.comment, 0);
        if (this.time != null) {
            long stamp = DateTools.getTime(this.time, DATE_FORMAT);
            String date = DateTools.convertDate(stamp, 0);
            store.setImageCreationDate(date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        for (i = 0; i < this.channels.length; ++i) {
            store.setLogicalChannelName(this.channels[i], 0, i);
        }
        store.setDimensionsPhysicalSizeX(this.pixelSize, 0, 0);
        store.setDimensionsPhysicalSizeY(this.pixelSize, 0, 0);
        store.setDimensionsPhysicalSizeZ(this.sliceThickness, 0, 0);
        for (i = 0; i < this.getImageCount(); ++i) {
            store.setPlaneTimingExposureTime(this.exposureTime, 0, 0, i);
            if (i >= this.timestamps.length) continue;
            store.setPlaneTimingDeltaT(this.timestamps[i], 0, 0, i);
        }
        if (this.detectorID == null) {
            this.detectorID = MetadataTools.createLSID("Detector", 0, 0);
        } else {
            this.detectorID = this.detectorID.substring(this.detectorID.lastIndexOf(":") + 1);
            this.detectorID = "Detector:" + this.detectorID.trim();
        }
        for (i = 0; i < this.channels.length; ++i) {
            store.setDetectorSettingsBinning(this.binning, 0, i);
            store.setDetectorSettingsGain(new Float(this.gain), 0, i);
            if (i < this.voltage.size()) {
                store.setDetectorSettingsVoltage(this.voltage.get(i), 0, i);
            }
            store.setDetectorSettingsDetector(this.detectorID, 0, i);
        }
        store.setDetectorID(this.detectorID, 0, 0);
        if (this.detectorModel != null) {
            store.setDetectorModel(this.detectorModel, 0, 0);
        }
        if (this.detectorManufacturer != null) {
            store.setDetectorManufacturer(this.detectorManufacturer, 0, 0);
        }
        if (this.cameraMode == null) {
            this.cameraMode = "Unknown";
        }
        store.setDetectorType(this.cameraMode, 0, 0);
        store.setImagingEnvironmentTemperature(new Float(this.temperature), 0);
    }
}

