/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Map;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffRational;

public class GelReader
extends BaseTiffReader {
    public static final String DATE_FORMAT = "yyyy:MM:dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "yyyy:MM:dd HH:mm:ss";
    public static final String[] FORMATS = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd", "HH:mm:ss"};
    private static final int MD_FILETAG = 33445;
    private static final int MD_SCALE_PIXEL = 33446;
    private static final int MD_LAB_NAME = 33448;
    private static final int MD_SAMPLE_INFO = 33449;
    private static final int MD_PREP_DATE = 33450;
    private static final int MD_PREP_TIME = 33451;
    private static final int MD_FILE_UNITS = 33452;
    private static final int SQUARE_ROOT = 2;
    private static final int LINEAR = 128;

    public GelReader() {
        super("Amersham Biosciences GEL", new String[]{"gel"});
        this.domains = new String[]{"Gel/Blot Imaging"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean sqrt;
        IFD ifd = (IFD)this.ifds.get(no);
        boolean bl = sqrt = ifd.getIFDLongValue(33445, true, 128L) == 2L;
        if (sqrt) {
            float scale = ((TiffRational)ifd.getIFDValue(33446)).floatValue();
            byte[] tmp = new byte[buf.length];
            super.openBytes(no, tmp, x, y, w, h);
            int originalBytes = ifd.getBitsPerSample()[0] / 8;
            for (int i = 0; i < tmp.length / 4; ++i) {
                long value = DataTools.bytesToShort(tmp, i * originalBytes, originalBytes, this.isLittleEndian());
                long square = value * value;
                float pixel = (float)square * scale;
                DataTools.unpackBytes(Float.floatToIntBits(pixel), buf, i * 4, 4, this.isLittleEndian());
            }
        } else {
            super.openBytes(no, buf, x, y, w, h);
        }
        return buf;
    }

    protected void initMetadata() throws FormatException, IOException {
        this.ifds = this.tiffParser.getIFDs();
        if (this.ifds.size() > 1) {
            IFDList tmpIFDs = this.ifds;
            this.ifds = new IFDList();
            for (int i = 0; i < tmpIFDs.size() / 2; ++i) {
                IFD ifd = new IFD();
                this.ifds.add(ifd);
                ifd.putAll((Map)tmpIFDs.get(i * 2 + 1));
                ifd.putAll((Map)tmpIFDs.get(i * 2));
            }
        }
        super.initStandardMetadata();
        IFD firstIFD = (IFD)this.ifds.get(0);
        long fmt = firstIFD.getIFDLongValue(33445, true, 128L);
        if (fmt == 2L) {
            this.core[0].pixelType = 6;
        }
        this.addGlobalMeta("Data format", fmt == 2L ? "square root" : "linear");
        TiffRational scale = (TiffRational)firstIFD.getIFDValue(33446);
        if (scale == null) {
            scale = new TiffRational(1L, 1L);
        }
        this.addGlobalMeta("Scale factor", scale);
        String lab = firstIFD.getIFDStringValue(33448, false);
        this.addGlobalMeta("Lab name", lab);
        String info = firstIFD.getIFDStringValue(33449, false);
        this.addGlobalMeta("Sample info", info);
        String prepDate = firstIFD.getIFDStringValue(33450, false);
        this.addGlobalMeta("Date prepared", prepDate);
        String prepTime = firstIFD.getIFDStringValue(33451, false);
        this.addGlobalMeta("Time prepared", prepTime);
        String units = firstIFD.getIFDStringValue(33452, false);
        this.addGlobalMeta("File units", units);
        this.core[0].imageCount = this.ifds.size();
        this.core[0].sizeT = this.getImageCount();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageDescription(info, 0);
        String parsedDate = DateTools.formatDate(prepDate, FORMATS);
        String parsedTime = DateTools.formatDate(prepTime, FORMATS);
        if (parsedDate != null) {
            store.setImageCreationDate(parsedDate, 0);
        } else if (parsedTime != null) {
            store.setImageCreationDate(parsedTime, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), 0);
        }
        Float pixelSize = new Float(scale.floatValue());
        store.setDimensionsPhysicalSizeX(pixelSize, 0, 0);
        store.setDimensionsPhysicalSizeY(pixelSize, 0, 0);
    }
}

