/*
 * Decompiled with CFR 0.152.
 */
package ome.model.screen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.WellAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.screen.Plate;
import ome.model.screen.Reagent;
import ome.model.screen.WellReagentLink;
import ome.model.screen.WellSample;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="well_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="well_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="well_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="well_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="well_owner_filter_REAGENTLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="well_group_filter_REAGENTLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="well_event_filter_REAGENTLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="well_perms_filter_REAGENTLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="well_owner_filter_WELLSAMPLES", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="well_group_filter_WELLSAMPLES", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="well_event_filter_WELLSAMPLES", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="well_perms_filter_WELLSAMPLES", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="well_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="well_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="well_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="well_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="well_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="well_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="well_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="well_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="well", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_well", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_well"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Well
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "well_owner_filter";
    public static final String GROUP_FILTER = "well_group_filter";
    public static final String EVENT_FILTER = "well_event_filter";
    public static final String PERMS_FILTER = "well_perms_filter";
    public static final String ID = "ome.model.screen.Well_id";
    protected Long id;
    public static final String VERSION = "ome.model.screen.Well_version";
    protected Integer version = 0;
    protected Integer column = null;
    protected Integer row = null;
    protected Integer red = null;
    protected Integer green = null;
    protected Integer blue = null;
    protected Integer alpha = null;
    protected Set<WellReagentLink> reagentLinks = new HashSet<WellReagentLink>();
    public static final String OWNER_FILTER_REAGENTLINKS = "well_owner_filter_REAGENTLINKS";
    public static final String GROUP_FILTER_REAGENTLINKS = "well_group_filter_REAGENTLINKS";
    public static final String EVENT_FILTER_REAGENTLINKS = "well_event_filter_REAGENTLINKS";
    public static final String PERMS_FILTER_REAGENTLINKS = "well_perms_filter_REAGENTLINKS";
    private Map<Long, Long> reagentLinksCountPerOwner = null;
    protected String externalDescription = null;
    protected String externalIdentifier = null;
    protected String type = null;
    protected List<WellSample> wellSamples = new ArrayList<WellSample>();
    public static final String OWNER_FILTER_WELLSAMPLES = "well_owner_filter_WELLSAMPLES";
    public static final String GROUP_FILTER_WELLSAMPLES = "well_group_filter_WELLSAMPLES";
    public static final String EVENT_FILTER_WELLSAMPLES = "well_event_filter_WELLSAMPLES";
    public static final String PERMS_FILTER_WELLSAMPLES = "well_perms_filter_WELLSAMPLES";
    protected Plate plate = null;
    protected Set<WellAnnotationLink> annotationLinks = new HashSet<WellAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "well_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "well_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "well_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "well_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String COLUMN = "ome.model.screen.Well_column";
    public static final String ROW = "ome.model.screen.Well_row";
    public static final String RED = "ome.model.screen.Well_red";
    public static final String GREEN = "ome.model.screen.Well_green";
    public static final String BLUE = "ome.model.screen.Well_blue";
    public static final String ALPHA = "ome.model.screen.Well_alpha";
    public static final String REAGENTLINKSCOUNTPEROWNER = "ome.model.screen.Well_reagentLinksCountPerOwner";
    public static final String REAGENTLINKS = "ome.model.screen.Well_reagentLinks";
    public static final String EXTERNALDESCRIPTION = "ome.model.screen.Well_externalDescription";
    public static final String EXTERNALIDENTIFIER = "ome.model.screen.Well_externalIdentifier";
    public static final String TYPE = "ome.model.screen.Well_type";
    public static final String WELLSAMPLES = "ome.model.screen.Well_wellSamples";
    public static final String PLATE = "ome.model.screen.Well_plate";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.screen.Well_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Well_annotationLinks";
    public static final String DETAILS = "ome.model.screen.Well_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Well() {
        this(null, true);
    }

    protected Well(Long id) {
        this(id, true);
    }

    public Well(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Well(Plate _plate) {
        this(null, true);
        this.setPlate(_plate);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_well")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="\"column\"", updatable=true)
    public Integer getColumn() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.column;
    }

    public void setColumn(Integer column) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.column = column;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="row", updatable=true)
    public Integer getRow() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.row;
    }

    public void setRow(Integer row) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.row = row;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="red", updatable=true)
    public Integer getRed() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.red;
    }

    public void setRed(Integer red) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.red = red;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="green", updatable=true)
    public Integer getGreen() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.green;
    }

    public void setGreen(Integer green) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.green = green;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="blue", updatable=true)
    public Integer getBlue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.blue;
    }

    public void setBlue(Integer blue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.blue = blue;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="alpha", updatable=true)
    public Integer getAlpha() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.alpha;
    }

    public void setAlpha(Integer alpha) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.alpha = alpha;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="well_owner_filter_REAGENTLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="well_group_filter_REAGENTLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="well_event_filter_REAGENTLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="well_perms_filter_REAGENTLINKS", condition=":permsStr = permissions")})
    protected Set<WellReagentLink> getReagentLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.reagentLinks;
    }

    protected void setReagentLinks(Set<WellReagentLink> reagentLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.reagentLinks = reagentLinks;
    }

    public int sizeOfReagentLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.reagentLinks == null ? -1 : this.reagentLinks.size();
    }

    public Iterator<WellReagentLink> iterateReagentLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            return new EmptyIterator<WellReagentLink>();
        }
        return this.getReagentLinks().iterator();
    }

    public Collection<WellReagentLink> unmodifiableReagentLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getReagentLinks());
    }

    public <E> List<E> collectReagentLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<WellReagentLink> it = this.iterateReagentLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addWellReagentLink(WellReagentLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            this.throwNullCollectionException("ReagentLinks");
        }
        this.getReagentLinks().add(target);
        target.setParent(this);
    }

    public void addWellReagentLinkSet(Collection<WellReagentLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            this.throwNullCollectionException("ReagentLinks");
        }
        this.getReagentLinks().addAll(targets);
        for (WellReagentLink target : targets) {
            target.setParent(this);
        }
    }

    public void removeWellReagentLink(WellReagentLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            this.throwNullCollectionException("ReagentLinks");
        }
        this.getReagentLinks().remove(target);
        target.setParent(null);
    }

    public void removeWellReagentLinkSet(Collection<WellReagentLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            this.throwNullCollectionException("ReagentLinks");
        }
        this.getReagentLinks().removeAll(targets);
        for (WellReagentLink target : targets) {
            target.setParent(null);
        }
    }

    public WellReagentLink linkReagent(Reagent addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        WellReagentLink link = new WellReagentLink();
        link.link(this, addition);
        this.addWellReagentLink(link, true);
        return link;
    }

    public void addWellReagentLink(WellReagentLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            this.throwNullCollectionException("ReagentLinks");
        }
        this.getReagentLinks().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addWellReagentLink(link, false);
        }
    }

    public Iterator<Reagent> linkedReagentIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            return new EmptyIterator<Reagent>();
        }
        final Iterator<WellReagentLink> it = this.getReagentLinks().iterator();
        return new Iterator<Reagent>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Reagent next() {
                if (it == null) {
                    throw new NoSuchElementException("reagentLinks is null; no elements.");
                }
                WellReagentLink link = (WellReagentLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<WellReagentLink> findWellReagentLink(Reagent target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<WellReagentLink> it = this.iterateReagentLinks();
        HashSet<WellReagentLink> result = new HashSet<WellReagentLink>();
        while (it.hasNext()) {
            WellReagentLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Reagent> linkedReagentList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Reagent> it = this.linkedReagentIterator();
        ArrayList<Reagent> list = new ArrayList<Reagent>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedReagent(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Reagent> it = this.linkedReagentIterator();
        while (it.hasNext()) {
            Reagent obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkReagent(Reagent removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<WellReagentLink> toRemove = this.findWellReagentLink(removal);
        Iterator<WellReagentLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeWellReagentLink(it.next(), true);
        }
    }

    public void removeWellReagentLink(WellReagentLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getReagentLinks() == null) {
            this.throwNullCollectionException("ReagentLinks");
        }
        this.getReagentLinks().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeWellReagentLink(link, false);
        }
    }

    public void clearReagentLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<WellReagentLink> list = new ArrayList<WellReagentLink>(this.getReagentLinks());
        for (WellReagentLink link : list) {
            this.removeWellReagentLink(link, true);
        }
    }

    protected void setReagentLinksCountPerOwner(Map<Long, Long> map) {
        this.reagentLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Well_reagentLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Well_reagentLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getReagentLinksCountPerOwner() {
        return this.reagentLinksCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="externalDescription", updatable=true)
    public String getExternalDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.externalDescription;
    }

    public void setExternalDescription(String externalDescription) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.externalDescription = externalDescription;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="externalIdentifier", updatable=true)
    public String getExternalIdentifier() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.externalIdentifier = externalIdentifier;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="type", updatable=true)
    public String getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(String type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @JoinColumn(name="well", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="well_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="well_owner_filter_WELLSAMPLES", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="well_group_filter_WELLSAMPLES", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="well_event_filter_WELLSAMPLES", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="well_perms_filter_WELLSAMPLES", condition=":permsStr = permissions")})
    protected List<WellSample> getWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellSamples;
    }

    protected void setWellSamples(List<WellSample> wellSamples) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wellSamples = wellSamples;
    }

    public int sizeOfWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellSamples == null ? -1 : this.wellSamples.size();
    }

    public Iterator<WellSample> iterateWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            return new EmptyIterator<WellSample>();
        }
        return this.getWellSamples().iterator();
    }

    public Collection<WellSample> unmodifiableWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getWellSamples());
    }

    public <E> List<E> collectWellSamples(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<WellSample> it = this.iterateWellSamples();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addWellSample(WellSample target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().add(target);
        if (target.isLoaded()) {
            target.setWell(this);
        }
    }

    public void addWellSampleSet(Collection<WellSample> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().addAll(targets);
        for (WellSample target : targets) {
            if (!target.isLoaded()) continue;
            target.setWell(this);
        }
    }

    public void removeWellSample(WellSample target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().remove(target);
        if (target.isLoaded()) {
            target.setWell(null);
        }
    }

    public void removeWellSampleSet(Collection<WellSample> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().removeAll(targets);
        for (WellSample target : targets) {
            if (!target.isLoaded()) continue;
            target.setWell(null);
        }
    }

    public void clearWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().clear();
        Iterator<WellSample> it = this.iterateWellSamples();
        while (it.hasNext()) {
            WellSample target = it.next();
            target.setWell(null);
        }
    }

    public WellSample getWellSample(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        return this.getWellSamples().get(index);
    }

    public void setWellSample(int index, WellSample element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().set(index, element);
    }

    @Transient
    public WellSample getPrimaryWellSample() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        return this.getWellSamples().get(0);
    }

    public WellSample setPrimaryWellSample(WellSample element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        List<WellSample> list = this.getWellSamples();
        int index = list.indexOf(element);
        WellSample old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Plate.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="plate", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKwell_plate_plate")
    public Plate getPlate() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.plate;
    }

    public void setPlate(Plate plate) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.plate = plate;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="well_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="well_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="well_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="well_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<WellAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<WellAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<WellAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<WellAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<WellAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<WellAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addWellAnnotationLink(WellAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        target.setParent(this);
    }

    public void addWellAnnotationLinkSet(Collection<WellAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (WellAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    public void removeWellAnnotationLink(WellAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeWellAnnotationLinkSet(Collection<WellAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (WellAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public WellAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        WellAnnotationLink link = new WellAnnotationLink();
        link.link(this, addition);
        this.addWellAnnotationLink(link, true);
        return link;
    }

    public void addWellAnnotationLink(WellAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<WellAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                WellAnnotationLink link = (WellAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<WellAnnotationLink> findWellAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<WellAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<WellAnnotationLink> result = new HashSet<WellAnnotationLink>();
        while (it.hasNext()) {
            WellAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<WellAnnotationLink> toRemove = this.findWellAnnotationLink(removal);
        Iterator<WellAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeWellAnnotationLink(it.next(), true);
        }
    }

    public void removeWellAnnotationLink(WellAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<WellAnnotationLink> list = new ArrayList<WellAnnotationLink>(this.getAnnotationLinks());
        for (WellAnnotationLink link : list) {
            this.removeWellAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Well_annotationLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Well_annotationLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Well newInstance() {
        return new Well();
    }

    public Well proxy() {
        return new Well(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.column = (Integer)__filter.filter(COLUMN, this.column);
            this.row = (Integer)__filter.filter(ROW, this.row);
            this.red = (Integer)__filter.filter(RED, this.red);
            this.green = (Integer)__filter.filter(GREEN, this.green);
            this.blue = (Integer)__filter.filter(BLUE, this.blue);
            this.alpha = (Integer)__filter.filter(ALPHA, this.alpha);
            this.reagentLinksCountPerOwner = __filter.filter(REAGENTLINKSCOUNTPEROWNER, this.reagentLinksCountPerOwner);
            this.reagentLinks = (Set)__filter.filter(REAGENTLINKS, this.reagentLinks);
            this.externalDescription = (String)__filter.filter(EXTERNALDESCRIPTION, this.externalDescription);
            this.externalIdentifier = (String)__filter.filter(EXTERNALIDENTIFIER, this.externalIdentifier);
            this.type = (String)__filter.filter(TYPE, this.type);
            this.wellSamples = (List)__filter.filter(WELLSAMPLES, this.wellSamples);
            this.plate = (Plate)__filter.filter(PLATE, this.plate);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(COLUMN)) {
            return this.getColumn();
        }
        if (field.equals(ROW)) {
            return this.getRow();
        }
        if (field.equals(RED)) {
            return this.getRed();
        }
        if (field.equals(GREEN)) {
            return this.getGreen();
        }
        if (field.equals(BLUE)) {
            return this.getBlue();
        }
        if (field.equals(ALPHA)) {
            return this.getAlpha();
        }
        if (field.equals(REAGENTLINKSCOUNTPEROWNER)) {
            return this.getReagentLinksCountPerOwner();
        }
        if (field.equals(REAGENTLINKS)) {
            return this.getReagentLinks();
        }
        if (field.equals(EXTERNALDESCRIPTION)) {
            return this.getExternalDescription();
        }
        if (field.equals(EXTERNALIDENTIFIER)) {
            return this.getExternalIdentifier();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(WELLSAMPLES)) {
            return this.getWellSamples();
        }
        if (field.equals(PLATE)) {
            return this.getPlate();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(COLUMN)) {
            this.setColumn((Integer)value);
        } else if (field.equals(ROW)) {
            this.setRow((Integer)value);
        } else if (field.equals(RED)) {
            this.setRed((Integer)value);
        } else if (field.equals(GREEN)) {
            this.setGreen((Integer)value);
        } else if (field.equals(BLUE)) {
            this.setBlue((Integer)value);
        } else if (field.equals(ALPHA)) {
            this.setAlpha((Integer)value);
        } else if (field.equals(REAGENTLINKSCOUNTPEROWNER)) {
            this.setReagentLinksCountPerOwner((Map)value);
        } else if (field.equals(REAGENTLINKS)) {
            this.setReagentLinks((Set)value);
        } else if (field.equals(EXTERNALDESCRIPTION)) {
            this.setExternalDescription((String)value);
        } else if (field.equals(EXTERNALIDENTIFIER)) {
            this.setExternalIdentifier((String)value);
        } else if (field.equals(TYPE)) {
            this.setType((String)value);
        } else if (field.equals(WELLSAMPLES)) {
            this.setWellSamples((List)value);
        } else if (field.equals(PLATE)) {
            this.setPlate((Plate)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.column = null;
        this.row = null;
        this.red = null;
        this.green = null;
        this.blue = null;
        this.alpha = null;
        this.reagentLinksCountPerOwner = null;
        this.reagentLinks = null;
        this.externalDescription = null;
        this.externalIdentifier = null;
        this.type = null;
        this.wellSamples = null;
        this.plate = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(COLUMN);
        raw.add(ROW);
        raw.add(RED);
        raw.add(GREEN);
        raw.add(BLUE);
        raw.add(ALPHA);
        raw.add(REAGENTLINKSCOUNTPEROWNER);
        raw.add(REAGENTLINKS);
        raw.add(EXTERNALDESCRIPTION);
        raw.add(EXTERNALIDENTIFIER);
        raw.add(TYPE);
        raw.add(WELLSAMPLES);
        raw.add(PLATE);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKwell_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKwell_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKwell_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKwell_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKwell_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

