/*
 * Decompiled with CFR 0.152.
 */
package ome.model.screen;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.ScreenAcquisitionAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.screen.Screen;
import ome.model.screen.ScreenAcquisitionWellSampleLink;
import ome.model.screen.WellSample;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="screenacquisition_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="screenacquisition_owner_filter_WELLSAMPLELINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_group_filter_WELLSAMPLELINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_event_filter_WELLSAMPLELINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_perms_filter_WELLSAMPLELINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="screenacquisition_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="screenacquisition_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="screenacquisition_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="screenacquisition_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="screenacquisition_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="screenacquisition_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="screenacquisition", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_screenacquisition", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_screenacquisition"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class ScreenAcquisition
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "screenacquisition_owner_filter";
    public static final String GROUP_FILTER = "screenacquisition_group_filter";
    public static final String EVENT_FILTER = "screenacquisition_event_filter";
    public static final String PERMS_FILTER = "screenacquisition_perms_filter";
    public static final String ID = "ome.model.screen.ScreenAcquisition_id";
    protected Long id;
    public static final String VERSION = "ome.model.screen.ScreenAcquisition_version";
    protected Integer version = 0;
    protected Timestamp startTime = null;
    protected Timestamp endTime = null;
    protected Screen screen = null;
    protected Set<ScreenAcquisitionWellSampleLink> wellSampleLinks = new HashSet<ScreenAcquisitionWellSampleLink>();
    public static final String OWNER_FILTER_WELLSAMPLELINKS = "screenacquisition_owner_filter_WELLSAMPLELINKS";
    public static final String GROUP_FILTER_WELLSAMPLELINKS = "screenacquisition_group_filter_WELLSAMPLELINKS";
    public static final String EVENT_FILTER_WELLSAMPLELINKS = "screenacquisition_event_filter_WELLSAMPLELINKS";
    public static final String PERMS_FILTER_WELLSAMPLELINKS = "screenacquisition_perms_filter_WELLSAMPLELINKS";
    private Map<Long, Long> wellSampleLinksCountPerOwner = null;
    protected Set<ScreenAcquisitionAnnotationLink> annotationLinks = new HashSet<ScreenAcquisitionAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "screenacquisition_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "screenacquisition_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "screenacquisition_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "screenacquisition_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String STARTTIME = "ome.model.screen.ScreenAcquisition_startTime";
    public static final String ENDTIME = "ome.model.screen.ScreenAcquisition_endTime";
    public static final String SCREEN = "ome.model.screen.ScreenAcquisition_screen";
    public static final String WELLSAMPLELINKSCOUNTPEROWNER = "ome.model.screen.ScreenAcquisition_wellSampleLinksCountPerOwner";
    public static final String WELLSAMPLELINKS = "ome.model.screen.ScreenAcquisition_wellSampleLinks";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.screen.ScreenAcquisition_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.screen.ScreenAcquisition_annotationLinks";
    public static final String DETAILS = "ome.model.screen.ScreenAcquisition_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public ScreenAcquisition() {
        this(null, true);
    }

    protected ScreenAcquisition(Long id) {
        this(id, true);
    }

    public ScreenAcquisition(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public ScreenAcquisition(Screen _screen) {
        this(null, true);
        this.setScreen(_screen);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_screenacquisition")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="startTime", updatable=true)
    public Timestamp getStartTime() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.startTime = startTime;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="endTime", updatable=true)
    public Timestamp getEndTime() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.endTime;
    }

    public void setEndTime(Timestamp endTime) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.endTime = endTime;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Screen.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="screen", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKscreenacquisition_screen_screen")
    public Screen getScreen() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.screen;
    }

    public void setScreen(Screen screen) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.screen = screen;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="screenacquisition_owner_filter_WELLSAMPLELINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="screenacquisition_group_filter_WELLSAMPLELINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="screenacquisition_event_filter_WELLSAMPLELINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="screenacquisition_perms_filter_WELLSAMPLELINKS", condition=":permsStr = permissions")})
    protected Set<ScreenAcquisitionWellSampleLink> getWellSampleLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellSampleLinks;
    }

    protected void setWellSampleLinks(Set<ScreenAcquisitionWellSampleLink> wellSampleLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wellSampleLinks = wellSampleLinks;
    }

    public int sizeOfWellSampleLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellSampleLinks == null ? -1 : this.wellSampleLinks.size();
    }

    public Iterator<ScreenAcquisitionWellSampleLink> iterateWellSampleLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            return new EmptyIterator<ScreenAcquisitionWellSampleLink>();
        }
        return this.getWellSampleLinks().iterator();
    }

    public Collection<ScreenAcquisitionWellSampleLink> unmodifiableWellSampleLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getWellSampleLinks());
    }

    public <E> List<E> collectWellSampleLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ScreenAcquisitionWellSampleLink> it = this.iterateWellSampleLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addScreenAcquisitionWellSampleLink(ScreenAcquisitionWellSampleLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            this.throwNullCollectionException("WellSampleLinks");
        }
        this.getWellSampleLinks().add(target);
        target.setParent(this);
    }

    public void addScreenAcquisitionWellSampleLinkSet(Collection<ScreenAcquisitionWellSampleLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            this.throwNullCollectionException("WellSampleLinks");
        }
        this.getWellSampleLinks().addAll(targets);
        for (ScreenAcquisitionWellSampleLink target : targets) {
            target.setParent(this);
        }
    }

    public void removeScreenAcquisitionWellSampleLink(ScreenAcquisitionWellSampleLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            this.throwNullCollectionException("WellSampleLinks");
        }
        this.getWellSampleLinks().remove(target);
        target.setParent(null);
    }

    public void removeScreenAcquisitionWellSampleLinkSet(Collection<ScreenAcquisitionWellSampleLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            this.throwNullCollectionException("WellSampleLinks");
        }
        this.getWellSampleLinks().removeAll(targets);
        for (ScreenAcquisitionWellSampleLink target : targets) {
            target.setParent(null);
        }
    }

    public ScreenAcquisitionWellSampleLink linkWellSample(WellSample addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ScreenAcquisitionWellSampleLink link = new ScreenAcquisitionWellSampleLink();
        link.link(this, addition);
        this.addScreenAcquisitionWellSampleLink(link, true);
        return link;
    }

    public void addScreenAcquisitionWellSampleLink(ScreenAcquisitionWellSampleLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            this.throwNullCollectionException("WellSampleLinks");
        }
        this.getWellSampleLinks().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addScreenAcquisitionWellSampleLink(link, false);
        }
    }

    public Iterator<WellSample> linkedWellSampleIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            return new EmptyIterator<WellSample>();
        }
        final Iterator<ScreenAcquisitionWellSampleLink> it = this.getWellSampleLinks().iterator();
        return new Iterator<WellSample>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public WellSample next() {
                if (it == null) {
                    throw new NoSuchElementException("wellSampleLinks is null; no elements.");
                }
                ScreenAcquisitionWellSampleLink link = (ScreenAcquisitionWellSampleLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ScreenAcquisitionWellSampleLink> findScreenAcquisitionWellSampleLink(WellSample target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ScreenAcquisitionWellSampleLink> it = this.iterateWellSampleLinks();
        HashSet<ScreenAcquisitionWellSampleLink> result = new HashSet<ScreenAcquisitionWellSampleLink>();
        while (it.hasNext()) {
            ScreenAcquisitionWellSampleLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<WellSample> linkedWellSampleList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<WellSample> it = this.linkedWellSampleIterator();
        ArrayList<WellSample> list = new ArrayList<WellSample>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedWellSample(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<WellSample> it = this.linkedWellSampleIterator();
        while (it.hasNext()) {
            WellSample obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkWellSample(WellSample removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ScreenAcquisitionWellSampleLink> toRemove = this.findScreenAcquisitionWellSampleLink(removal);
        Iterator<ScreenAcquisitionWellSampleLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenAcquisitionWellSampleLink(it.next(), true);
        }
    }

    public void removeScreenAcquisitionWellSampleLink(ScreenAcquisitionWellSampleLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSampleLinks() == null) {
            this.throwNullCollectionException("WellSampleLinks");
        }
        this.getWellSampleLinks().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeScreenAcquisitionWellSampleLink(link, false);
        }
    }

    public void clearWellSampleLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ScreenAcquisitionWellSampleLink> list = new ArrayList<ScreenAcquisitionWellSampleLink>(this.getWellSampleLinks());
        for (ScreenAcquisitionWellSampleLink link : list) {
            this.removeScreenAcquisitionWellSampleLink(link, true);
        }
    }

    protected void setWellSampleLinksCountPerOwner(Map<Long, Long> map) {
        this.wellSampleLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_ScreenAcquisition_wellSampleLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_ScreenAcquisition_wellSampleLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getWellSampleLinksCountPerOwner() {
        return this.wellSampleLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="screenacquisition_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="screenacquisition_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="screenacquisition_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="screenacquisition_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<ScreenAcquisitionAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<ScreenAcquisitionAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<ScreenAcquisitionAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<ScreenAcquisitionAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<ScreenAcquisitionAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ScreenAcquisitionAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addScreenAcquisitionAnnotationLink(ScreenAcquisitionAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        target.setParent(this);
    }

    public void addScreenAcquisitionAnnotationLinkSet(Collection<ScreenAcquisitionAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (ScreenAcquisitionAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    public void removeScreenAcquisitionAnnotationLink(ScreenAcquisitionAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeScreenAcquisitionAnnotationLinkSet(Collection<ScreenAcquisitionAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (ScreenAcquisitionAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public ScreenAcquisitionAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ScreenAcquisitionAnnotationLink link = new ScreenAcquisitionAnnotationLink();
        link.link(this, addition);
        this.addScreenAcquisitionAnnotationLink(link, true);
        return link;
    }

    public void addScreenAcquisitionAnnotationLink(ScreenAcquisitionAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<ScreenAcquisitionAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                ScreenAcquisitionAnnotationLink link = (ScreenAcquisitionAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ScreenAcquisitionAnnotationLink> findScreenAcquisitionAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ScreenAcquisitionAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<ScreenAcquisitionAnnotationLink> result = new HashSet<ScreenAcquisitionAnnotationLink>();
        while (it.hasNext()) {
            ScreenAcquisitionAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ScreenAcquisitionAnnotationLink> toRemove = this.findScreenAcquisitionAnnotationLink(removal);
        Iterator<ScreenAcquisitionAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenAcquisitionAnnotationLink(it.next(), true);
        }
    }

    public void removeScreenAcquisitionAnnotationLink(ScreenAcquisitionAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ScreenAcquisitionAnnotationLink> list = new ArrayList<ScreenAcquisitionAnnotationLink>(this.getAnnotationLinks());
        for (ScreenAcquisitionAnnotationLink link : list) {
            this.removeScreenAcquisitionAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_ScreenAcquisition_annotationLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_ScreenAcquisition_annotationLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public ScreenAcquisition newInstance() {
        return new ScreenAcquisition();
    }

    public ScreenAcquisition proxy() {
        return new ScreenAcquisition(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.startTime = (Timestamp)__filter.filter(STARTTIME, this.startTime);
            this.endTime = (Timestamp)__filter.filter(ENDTIME, this.endTime);
            this.screen = (Screen)__filter.filter(SCREEN, this.screen);
            this.wellSampleLinksCountPerOwner = __filter.filter(WELLSAMPLELINKSCOUNTPEROWNER, this.wellSampleLinksCountPerOwner);
            this.wellSampleLinks = (Set)__filter.filter(WELLSAMPLELINKS, this.wellSampleLinks);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(STARTTIME)) {
            return this.getStartTime();
        }
        if (field.equals(ENDTIME)) {
            return this.getEndTime();
        }
        if (field.equals(SCREEN)) {
            return this.getScreen();
        }
        if (field.equals(WELLSAMPLELINKSCOUNTPEROWNER)) {
            return this.getWellSampleLinksCountPerOwner();
        }
        if (field.equals(WELLSAMPLELINKS)) {
            return this.getWellSampleLinks();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(STARTTIME)) {
            this.setStartTime((Timestamp)value);
        } else if (field.equals(ENDTIME)) {
            this.setEndTime((Timestamp)value);
        } else if (field.equals(SCREEN)) {
            this.setScreen((Screen)value);
        } else if (field.equals(WELLSAMPLELINKSCOUNTPEROWNER)) {
            this.setWellSampleLinksCountPerOwner((Map)value);
        } else if (field.equals(WELLSAMPLELINKS)) {
            this.setWellSampleLinks((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.startTime = null;
        this.endTime = null;
        this.screen = null;
        this.wellSampleLinksCountPerOwner = null;
        this.wellSampleLinks = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(STARTTIME);
        raw.add(ENDTIME);
        raw.add(SCREEN);
        raw.add(WELLSAMPLELINKSCOUNTPEROWNER);
        raw.add(WELLSAMPLELINKS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKscreenacquisition_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKscreenacquisition_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKscreenacquisition_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKscreenacquisition_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKscreenacquisition_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

