/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.roi.Shape;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="ellipse")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Ellipse
extends Shape
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "ellipse_owner_filter";
    public static final String GROUP_FILTER = "ellipse_group_filter";
    public static final String EVENT_FILTER = "ellipse_event_filter";
    public static final String PERMS_FILTER = "ellipse_perms_filter";
    protected Double cx = null;
    protected Double cy = null;
    protected Double rx = null;
    protected Double ry = null;
    public static final String CX = "ome.model.roi.Ellipse_cx";
    public static final String CY = "ome.model.roi.Ellipse_cy";
    public static final String RX = "ome.model.roi.Ellipse_rx";
    public static final String RY = "ome.model.roi.Ellipse_ry";
    public static final Set<String> FIELDS;

    public Ellipse() {
        this(null, true);
    }

    protected Ellipse(Long id) {
        this(id, true);
    }

    public Ellipse(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="cx", updatable=true)
    public Double getCx() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cx;
    }

    public void setCx(Double cx) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.cx = cx;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="cy", updatable=true)
    public Double getCy() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cy;
    }

    public void setCy(Double cy) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.cy = cy;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="rx", updatable=true)
    public Double getRx() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.rx;
    }

    public void setRx(Double rx) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.rx = rx;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="ry", updatable=true)
    public Double getRy() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.ry;
    }

    public void setRy(Double ry) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.ry = ry;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Ellipse newInstance() {
        return new Ellipse();
    }

    public Ellipse proxy() {
        return new Ellipse(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.cx = (Double)__filter.filter(CX, this.cx);
            this.cy = (Double)__filter.filter(CY, this.cy);
            this.rx = (Double)__filter.filter(RX, this.rx);
            this.ry = (Double)__filter.filter(RY, this.ry);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(CX)) {
            return this.getCx();
        }
        if (field.equals(CY)) {
            return this.getCy();
        }
        if (field.equals(RX)) {
            return this.getRx();
        }
        if (field.equals(RY)) {
            return this.getRy();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(CX)) {
            this.setCx((Double)value);
        } else if (field.equals(CY)) {
            this.setCy((Double)value);
        } else if (field.equals(RX)) {
            this.setRx((Double)value);
        } else if (field.equals(RY)) {
            this.setRy((Double)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.cx = null;
        this.cy = null;
        this.rx = null;
        this.ry = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(CX);
        raw.addAll(Shape.FIELDS);
        raw.add(CY);
        raw.addAll(Shape.FIELDS);
        raw.add(RX);
        raw.addAll(Shape.FIELDS);
        raw.add(RY);
        raw.addAll(Shape.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

