/*
 * Decompiled with CFR 0.152.
 */
package ome.model.annotations;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.TypeAnnotation;
import ome.model.display.Thumbnail;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="/type/Thumbnail/")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class ThumbnailAnnotation
extends TypeAnnotation
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "thumbnailannotation_owner_filter";
    public static final String GROUP_FILTER = "thumbnailannotation_group_filter";
    public static final String EVENT_FILTER = "thumbnailannotation_event_filter";
    public static final String PERMS_FILTER = "thumbnailannotation_perms_filter";
    protected Thumbnail thumbnail = null;
    public static final String THUMBNAIL = "ome.model.annotations.ThumbnailAnnotation_thumbnail";
    public static final Set<String> FIELDS;

    public ThumbnailAnnotation() {
        this(null, true);
    }

    protected ThumbnailAnnotation(Long id) {
        this(id, true);
    }

    public ThumbnailAnnotation(Long id, boolean loaded) {
        super(id, loaded);
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Thumbnail.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="thumbnail", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKthumbnailannotation_thumbnail_thumbnail")
    public Thumbnail getThumbnail() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.thumbnail;
    }

    public void setThumbnail(Thumbnail thumbnail) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.thumbnail = thumbnail;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public ThumbnailAnnotation newInstance() {
        return new ThumbnailAnnotation();
    }

    public ThumbnailAnnotation proxy() {
        return new ThumbnailAnnotation(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.thumbnail = (Thumbnail)__filter.filter(THUMBNAIL, this.thumbnail);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(THUMBNAIL)) {
            return this.getThumbnail();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(THUMBNAIL)) {
            this.setThumbnail((Thumbnail)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.thumbnail = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(THUMBNAIL);
        raw.addAll(TypeAnnotation.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

