/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.BZip2Handle;
import loci.common.FileHandle;
import loci.common.GZipHandle;
import loci.common.IRandomAccess;
import loci.common.URLHandle;
import loci.common.ZipHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location {
    private static HashMap<String, Object> idMap = new HashMap();
    private boolean isURL = true;
    private URL url;
    private File file;

    public Location(String pathname) {
        try {
            this.url = new URL(Location.getMappedId(pathname));
        }
        catch (MalformedURLException e) {
            this.isURL = false;
        }
        if (!this.isURL) {
            this.file = new File(Location.getMappedId(pathname));
        }
    }

    public Location(File file) {
        this.isURL = false;
        this.file = file;
    }

    public Location(String parent, String child) {
        this(parent + "/" + child);
    }

    public Location(Location parent, String child) {
        this(parent.getAbsolutePath(), child);
    }

    public static void mapId(String id, String filename) {
        if (id == null) {
            return;
        }
        if (filename == null) {
            idMap.remove(id);
        } else {
            idMap.put(id, filename);
        }
    }

    public static void mapFile(String id, IRandomAccess ira) {
        if (id == null) {
            return;
        }
        if (ira == null) {
            idMap.remove(id);
        } else {
            idMap.put(id, ira);
        }
    }

    public static String getMappedId(String id) {
        if (idMap == null) {
            return id;
        }
        String filename = null;
        if (id != null && idMap.get(id) instanceof String) {
            filename = (String)idMap.get(id);
        }
        return filename == null ? id : filename;
    }

    public static IRandomAccess getMappedFile(String id) {
        if (idMap == null) {
            return null;
        }
        IRandomAccess ira = null;
        if (id != null && idMap.get(id) instanceof IRandomAccess) {
            ira = (IRandomAccess)idMap.get(id);
        }
        return ira;
    }

    public static HashMap<String, Object> getIdMap() {
        return idMap;
    }

    public static void setIdMap(HashMap<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null");
        }
        idMap = map;
    }

    public static IRandomAccess getHandle(String id) throws IOException {
        return Location.getHandle(id, false);
    }

    public static IRandomAccess getHandle(String id, boolean writable) throws IOException {
        File f = new File(Location.getMappedId(id)).getAbsoluteFile();
        if (Location.getMappedFile(id) != null) {
            return Location.getMappedFile(id);
        }
        IRandomAccess handle = null;
        handle = id.startsWith("http://") ? new URLHandle(Location.getMappedId(id), writable ? "w" : "r") : (ZipHandle.isZipFile(id) ? new ZipHandle(Location.getMappedId(id)) : (GZipHandle.isGZipFile(id) ? new GZipHandle(Location.getMappedId(id)) : (BZip2Handle.isBZip2File(id) ? new BZip2Handle(Location.getMappedId(id)) : new FileHandle(f, writable ? "rw" : "r"))));
        return handle;
    }

    public String[] list(boolean noDotFiles) {
        String[] f;
        ArrayList<String> files = new ArrayList<String>();
        if (this.isURL) {
            if (!this.isDirectory()) {
                return null;
            }
            try {
                URLConnection c = this.url.openConnection();
                InputStream is = c.getInputStream();
                boolean foundEnd = false;
                while (!foundEnd) {
                    byte[] b = new byte[is.available()];
                    is.read(b);
                    String s = new String(b);
                    if (s.toLowerCase().indexOf("</html>") != -1) {
                        foundEnd = true;
                    }
                    while (s.indexOf("a href") != -1) {
                        int ndx = s.indexOf("a href") + 8;
                        String f2 = s.substring(ndx, s.indexOf("\"", ndx));
                        s = s.substring(s.indexOf("\"", ndx) + 1);
                        Location check = new Location(this.getAbsolutePath(), f2);
                        if (!check.exists() || noDotFiles && f2.startsWith(".")) continue;
                        files.add(check.getName());
                    }
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        if ((f = this.file.list()) == null) {
            return null;
        }
        for (String file : f) {
            if (noDotFiles && file.startsWith(".")) continue;
            files.add(file);
        }
        return files.toArray(new String[files.size()]);
    }

    public boolean canRead() {
        return this.isURL ? true : this.file.canRead();
    }

    public boolean canWrite() {
        return this.isURL ? false : this.file.canWrite();
    }

    public boolean createNewFile() throws IOException {
        if (this.isURL) {
            throw new IOException("Unimplemented");
        }
        return this.file.createNewFile();
    }

    public boolean delete() {
        return this.isURL ? false : this.file.delete();
    }

    public void deleteOnExit() {
        if (!this.isURL) {
            this.file.deleteOnExit();
        }
    }

    public boolean equals(Object obj) {
        return this.isURL ? this.url.equals(obj) : this.file.equals(obj);
    }

    public boolean exists() {
        if (this.isURL) {
            try {
                this.url.getContent();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.file.exists();
    }

    public Location getAbsoluteFile() {
        return new Location(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        return this.isURL ? this.url.toExternalForm() : this.file.getAbsolutePath();
    }

    public Location getCanonicalFile() throws IOException {
        return this.getAbsoluteFile();
    }

    public String getCanonicalPath() throws IOException {
        return this.isURL ? this.getAbsolutePath() : this.file.getCanonicalPath();
    }

    public String getName() {
        if (this.isURL) {
            String name = this.url.getFile();
            name = name.substring(name.lastIndexOf("/") + 1);
            return name;
        }
        return this.file.getName();
    }

    public String getParent() {
        if (this.isURL) {
            String absPath = this.getAbsolutePath();
            absPath = absPath.substring(0, absPath.lastIndexOf("/"));
            return absPath;
        }
        return this.file.getParent();
    }

    public Location getParentFile() {
        return new Location(this.getParent());
    }

    public String getPath() {
        return this.isURL ? this.url.getHost() + this.url.getPath() : this.file.getPath();
    }

    public boolean isAbsolute() {
        return this.isURL ? true : this.file.isAbsolute();
    }

    public boolean isDirectory() {
        return this.isURL ? this.lastModified() == 0L : this.file.isDirectory();
    }

    public boolean isFile() {
        return this.isURL ? this.lastModified() > 0L : this.file.isFile();
    }

    public boolean isHidden() {
        return this.isURL ? false : this.file.isHidden();
    }

    public long lastModified() {
        if (this.isURL) {
            try {
                return this.url.openConnection().getLastModified();
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return this.file.lastModified();
    }

    public long length() {
        if (this.isURL) {
            try {
                return this.url.openConnection().getContentLength();
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return this.file.length();
    }

    public String[] list() {
        return this.list(false);
    }

    public Location[] listFiles() {
        String[] s = this.list();
        if (s == null) {
            return null;
        }
        Location[] f = new Location[s.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Location(this.getAbsolutePath(), s[i]);
            f[i] = f[i].getAbsoluteFile();
        }
        return f;
    }

    public URL toURL() throws MalformedURLException {
        return this.isURL ? this.url : this.file.toURI().toURL();
    }

    public String toString() {
        return this.isURL ? this.url.toString() : this.file.toString();
    }
}

