/*
 * Decompiled with CFR 0.152.
 */
package omerobenchmark;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import loci.formats.FormatTools;
import omero.model.IObject;
import omero.model.Image;
import omeroconnect.Main;

public class BenchmarkInstanceThread {
    private Main omero;
    private Date startTime;
    private Date endTime;
    private long elapsed_time;

    public BenchmarkInstanceThread() throws Exception {
        this.doBenchmark();
    }

    public void start_time() {
        this.startTime = new Date();
    }

    public long end_time() {
        this.endTime = new Date();
        this.elapsed_time = this.endTime.getTime() - this.startTime.getTime();
        return this.elapsed_time;
    }

    public void doBenchmark() throws Exception {
        long allocdt = 0L;
        long uploaddt = 0L;
        long downloaddt = 0L;
        long deletedt = 0L;
        int x = 1024;
        int y = 1024;
        int z = 1024;
        int c = 1;
        int t = 1;
        this.omero = new Main();
        this.omero.initConnectionDetails("cmpdartsvr2.nbi.bbsrc.ac.uk", "avondoj", "avondo");
        this.start_time();
        Image img = this.omero.createImage("test", "test", x, y, z, c, t, "uint8");
        allocdt = this.end_time();
        System.out.println("Image alloc: " + allocdt + " ms");
        int pixelType = 1;
        byte[] imgarray = new byte[x * y * FormatTools.getBytesPerPixel((int)pixelType)];
        this.start_time();
        for (int i = 0; i < z; ++i) {
            for (int j = 0; j < c; ++j) {
                for (int k = 0; k < t; ++k) {
                    this.omero.setPlane(img, imgarray, i, j, k);
                }
            }
        }
        uploaddt = this.end_time();
        System.out.println("Image upload: " + uploaddt + " ms");
        img = (Image)this.omero.setToDatabaseAndReturnObject((IObject)img);
        byte[] tempimgarray = null;
        this.start_time();
        for (int i = 0; i < z; ++i) {
            for (int j = 0; j < c; ++j) {
                for (int k = 0; k < t; ++k) {
                    tempimgarray = this.omero.getPlane(img, i, j, k);
                }
            }
        }
        downloaddt = this.end_time();
        System.out.println("Image download: " + downloaddt + " ms");
        img = this.omero.getImage(img.getId().getValue());
        this.start_time();
        try {
            this.omero.removeFromDatabase((IObject)img);
        }
        catch (Exception exp) {
            // empty catch block
        }
        deletedt = this.end_time();
        System.out.println("Image deletion: " + deletedt + " ms");
        FileOutputStream fos = new FileOutputStream("results.txt", true);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        String text = allocdt + "\t" + uploaddt + "\t" + downloaddt + "\t" + deletedt + "\r\n";
        out.write(text);
        out.close();
        fos.close();
        System.out.println(text);
        this.omero.closeConnection();
    }
}

