// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public interface _MonitorServerOperations
{
    String createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy, Ice.Current __current)
        throws OmeroFSError;

    void startMonitor(String id, Ice.Current __current)
        throws OmeroFSError;

    void stopMonitor(String id, Ice.Current __current)
        throws OmeroFSError;

    void destroyMonitor(String id, Ice.Current __current)
        throws OmeroFSError;

    MonitorState getMonitorState(String id, Ice.Current __current)
        throws OmeroFSError;

    String[] getMonitorDirectory(String id, String relPath, String filter, Ice.Current __current)
        throws OmeroFSError;

    String[] getDirectory(String absPath, String filter, Ice.Current __current)
        throws OmeroFSError;

    String getBaseName(String fileId, Ice.Current __current)
        throws OmeroFSError;

    FileStats getStats(String fileId, Ice.Current __current)
        throws OmeroFSError;

    long getSize(String fileId, Ice.Current __current)
        throws OmeroFSError;

    String getOwner(String fileId, Ice.Current __current)
        throws OmeroFSError;

    float getCTime(String fileId, Ice.Current __current)
        throws OmeroFSError;

    float getMTime(String fileId, Ice.Current __current)
        throws OmeroFSError;

    float getATime(String fileId, Ice.Current __current)
        throws OmeroFSError;

    boolean isDir(String fileId, Ice.Current __current)
        throws OmeroFSError;

    boolean isFile(String fileId, Ice.Current __current)
        throws OmeroFSError;

    String getSHA1(String fileId, Ice.Current __current)
        throws OmeroFSError;

    byte[] readBlock(String fileId, long offset, int size, Ice.Current __current)
        throws OmeroFSError;
}
