// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public enum PathMode
{
    Flat,
    Recurse,
    Follow;

    public static final int _Flat = 0;
    public static final int _Recurse = 1;
    public static final int _Follow = 2;

    public static PathMode
    convert(int val)
    {
        assert val >= 0 && val < 3;
        return values()[val];
    }

    public static PathMode
    convert(String val)
    {
        try
        {
            return valueOf(val);
        }
        catch(java.lang.IllegalArgumentException ex)
        {
            return null;
        }
    }

    public int
    value()
    {
        return ordinal();
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeByte((byte)value());
    }

    public static PathMode
    __read(IceInternal.BasicStream __is)
    {
        int __v = __is.readByte(3);
        return PathMode.convert(__v);
    }
}
