// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public final class MonitorServerPrxHelper extends Ice.ObjectPrxHelperBase implements MonitorServerPrx
{
    public String
    createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy)
        throws OmeroFSError
    {
        return createMonitor(eType, pathString, whitelist, blacklist, pMode, proxy, null, false);
    }

    public String
    createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return createMonitor(eType, pathString, whitelist, blacklist, pMode, proxy, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private String
    createMonitor(EventType eType, String pathString, String[] whitelist, String[] blacklist, PathMode pMode, MonitorClientPrx proxy, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("createMonitor");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.createMonitor(eType, pathString, whitelist, blacklist, pMode, proxy, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex, null);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public void
    destroyMonitor(String id)
        throws OmeroFSError
    {
        destroyMonitor(id, null, false);
    }

    public void
    destroyMonitor(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        destroyMonitor(id, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private void
    destroyMonitor(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("destroyMonitor");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                __del.destroyMonitor(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public float
    getATime(String fileId)
        throws OmeroFSError
    {
        return getATime(fileId, null, false);
    }

    public float
    getATime(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getATime(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private float
    getATime(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getATime");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getATime(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public String
    getBaseName(String fileId)
        throws OmeroFSError
    {
        return getBaseName(fileId, null, false);
    }

    public String
    getBaseName(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getBaseName(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private String
    getBaseName(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getBaseName");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getBaseName(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public float
    getCTime(String fileId)
        throws OmeroFSError
    {
        return getCTime(fileId, null, false);
    }

    public float
    getCTime(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getCTime(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private float
    getCTime(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getCTime");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getCTime(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public String[]
    getDirectory(String absPath, String filter)
        throws OmeroFSError
    {
        return getDirectory(absPath, filter, null, false);
    }

    public String[]
    getDirectory(String absPath, String filter, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getDirectory(absPath, filter, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private String[]
    getDirectory(String absPath, String filter, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getDirectory");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getDirectory(absPath, filter, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public float
    getMTime(String fileId)
        throws OmeroFSError
    {
        return getMTime(fileId, null, false);
    }

    public float
    getMTime(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getMTime(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private float
    getMTime(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getMTime");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getMTime(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public String[]
    getMonitorDirectory(String id, String relPath, String filter)
        throws OmeroFSError
    {
        return getMonitorDirectory(id, relPath, filter, null, false);
    }

    public String[]
    getMonitorDirectory(String id, String relPath, String filter, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getMonitorDirectory(id, relPath, filter, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private String[]
    getMonitorDirectory(String id, String relPath, String filter, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getMonitorDirectory");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getMonitorDirectory(id, relPath, filter, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public MonitorState
    getMonitorState(String id)
        throws OmeroFSError
    {
        return getMonitorState(id, null, false);
    }

    public MonitorState
    getMonitorState(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getMonitorState(id, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private MonitorState
    getMonitorState(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getMonitorState");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getMonitorState(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public String
    getOwner(String fileId)
        throws OmeroFSError
    {
        return getOwner(fileId, null, false);
    }

    public String
    getOwner(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getOwner(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private String
    getOwner(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getOwner");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getOwner(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public String
    getSHA1(String fileId)
        throws OmeroFSError
    {
        return getSHA1(fileId, null, false);
    }

    public String
    getSHA1(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getSHA1(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private String
    getSHA1(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getSHA1");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getSHA1(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public long
    getSize(String fileId)
        throws OmeroFSError
    {
        return getSize(fileId, null, false);
    }

    public long
    getSize(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getSize(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private long
    getSize(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getSize");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getSize(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public FileStats
    getStats(String fileId)
        throws OmeroFSError
    {
        return getStats(fileId, null, false);
    }

    public FileStats
    getStats(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return getStats(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private FileStats
    getStats(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getStats");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.getStats(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public boolean
    isDir(String fileId)
        throws OmeroFSError
    {
        return isDir(fileId, null, false);
    }

    public boolean
    isDir(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return isDir(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private boolean
    isDir(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("isDir");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.isDir(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public boolean
    isFile(String fileId)
        throws OmeroFSError
    {
        return isFile(fileId, null, false);
    }

    public boolean
    isFile(String fileId, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return isFile(fileId, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private boolean
    isFile(String fileId, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("isFile");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.isFile(fileId, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public byte[]
    readBlock(String fileId, long offset, int size)
        throws OmeroFSError
    {
        return readBlock(fileId, offset, size, null, false);
    }

    public byte[]
    readBlock(String fileId, long offset, int size, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        return readBlock(fileId, offset, size, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private byte[]
    readBlock(String fileId, long offset, int size, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("readBlock");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                return __del.readBlock(fileId, offset, size, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public void
    startMonitor(String id)
        throws OmeroFSError
    {
        startMonitor(id, null, false);
    }

    public void
    startMonitor(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        startMonitor(id, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private void
    startMonitor(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("startMonitor");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                __del.startMonitor(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public void
    stopMonitor(String id)
        throws OmeroFSError
    {
        stopMonitor(id, null, false);
    }

    public void
    stopMonitor(String id, java.util.Map<String, String> __ctx)
        throws OmeroFSError
    {
        stopMonitor(id, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private void
    stopMonitor(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws OmeroFSError
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("stopMonitor");
                __delBase = __getDelegate(false);
                _MonitorServerDel __del = (_MonitorServerDel)__delBase;
                __del.stopMonitor(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public static MonitorServerPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        MonitorServerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (MonitorServerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::monitors::MonitorServer"))
                {
                    MonitorServerPrxHelper __h = new MonitorServerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static MonitorServerPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        MonitorServerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (MonitorServerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::monitors::MonitorServer", __ctx))
                {
                    MonitorServerPrxHelper __h = new MonitorServerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static MonitorServerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        MonitorServerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::monitors::MonitorServer"))
                {
                    MonitorServerPrxHelper __h = new MonitorServerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static MonitorServerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        MonitorServerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::monitors::MonitorServer", __ctx))
                {
                    MonitorServerPrxHelper __h = new MonitorServerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static MonitorServerPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        MonitorServerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (MonitorServerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                MonitorServerPrxHelper __h = new MonitorServerPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static MonitorServerPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        MonitorServerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            MonitorServerPrxHelper __h = new MonitorServerPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _MonitorServerDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _MonitorServerDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, MonitorServerPrx v)
    {
        __os.writeProxy(v);
    }

    public static MonitorServerPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            MonitorServerPrxHelper result = new MonitorServerPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
