// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public final class MonitorServerHolder
{
    public
    MonitorServerHolder()
    {
    }

    public
    MonitorServerHolder(MonitorServer value)
    {
        this.value = value;
    }

    public class Patcher implements IceInternal.Patcher
    {
        public void
        patch(Ice.Object v)
        {
            try
            {
                value = (MonitorServer)v;
            }
            catch(ClassCastException ex)
            {
                IceInternal.Ex.throwUOE(type(), v.ice_id());
            }
        }

        public String
        type()
        {
            return "::monitors::MonitorServer";
        }
    }

    public Patcher
    getPatcher()
    {
        return new Patcher();
    }

    public MonitorServer value;
}
