// **********************************************************************
//
// Copyright (c) 2003-2008 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.0

package monitors;

public final class FileStats implements java.lang.Cloneable
{
    public String baseName;

    public String owner;

    public long size;

    public float mTime;

    public float cTime;

    public float aTime;

    public FileType type;

    public FileStats()
    {
    }

    public FileStats(String baseName, String owner, long size, float mTime, float cTime, float aTime, FileType type)
    {
        this.baseName = baseName;
        this.owner = owner;
        this.size = size;
        this.mTime = mTime;
        this.cTime = cTime;
        this.aTime = aTime;
        this.type = type;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        FileStats _r = null;
        try
        {
            _r = (FileStats)rhs;
        }
        catch(ClassCastException ex)
        {
        }

        if(_r != null)
        {
            if(baseName != _r.baseName && baseName != null && !baseName.equals(_r.baseName))
            {
                return false;
            }
            if(owner != _r.owner && owner != null && !owner.equals(_r.owner))
            {
                return false;
            }
            if(size != _r.size)
            {
                return false;
            }
            if(mTime != _r.mTime)
            {
                return false;
            }
            if(cTime != _r.cTime)
            {
                return false;
            }
            if(aTime != _r.aTime)
            {
                return false;
            }
            if(type != _r.type && type != null && !type.equals(_r.type))
            {
                return false;
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 0;
        if(baseName != null)
        {
            __h = 5 * __h + baseName.hashCode();
        }
        if(owner != null)
        {
            __h = 5 * __h + owner.hashCode();
        }
        __h = 5 * __h + (int)size;
        __h = 5 * __h + java.lang.Float.floatToIntBits(mTime);
        __h = 5 * __h + java.lang.Float.floatToIntBits(cTime);
        __h = 5 * __h + java.lang.Float.floatToIntBits(aTime);
        if(type != null)
        {
            __h = 5 * __h + type.hashCode();
        }
        return __h;
    }

    public java.lang.Object
    clone()
    {
        java.lang.Object o = null;
        try
        {
            o = super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return o;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(baseName);
        __os.writeString(owner);
        __os.writeLong(size);
        __os.writeFloat(mTime);
        __os.writeFloat(cTime);
        __os.writeFloat(aTime);
        type.__write(__os);
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        baseName = __is.readString();
        owner = __is.readString();
        size = __is.readLong();
        mTime = __is.readFloat();
        cTime = __is.readFloat();
        aTime = __is.readFloat();
        type = FileType.__read(__is);
    }
}
