/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import loci.common.CBZip2InputStream;
import loci.common.HandleException;
import loci.common.StreamHandle;

public class BZip2Handle
extends StreamHandle {
    public BZip2Handle(String file) throws IOException {
        int skip;
        this.file = file;
        if (!BZip2Handle.isBZip2File(file)) {
            throw new HandleException(file + " is not a BZip2 file.");
        }
        this.resetStream();
        this.length = 0L;
        while ((skip = this.stream.skipBytes(1024)) > 0) {
            this.length += (long)skip;
        }
        this.resetStream();
    }

    public static boolean isBZip2File(String file) throws IOException {
        if (!file.toLowerCase().endsWith(".bz2")) {
            return false;
        }
        FileInputStream s = new FileInputStream(file);
        byte[] b = new byte[2];
        s.read(b);
        s.close();
        return new String(b).equals("BZ");
    }

    protected void resetStream() throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
        int skipped = 0;
        while (skipped < 2) {
            skipped = (int)((long)skipped + bis.skip(2 - skipped));
        }
        this.stream = new DataInputStream(new CBZip2InputStream(bis));
    }
}

