/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.ArrayList;
import java.util.List;
import omero.RString;
import omero.model.Namespace;
import omero.model.NamespaceI;
import omero.rtypes;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowData
extends DataObject {
    public static String DEFAULTWORKFLOW = "Default";

    private List<String> CSVToList(String str) {
        String[] valueString;
        ArrayList<String> list = new ArrayList<String>();
        for (String keyword : valueString = str.split(",")) {
            if (keyword.equals("[]")) continue;
            list.add(keyword);
        }
        return list;
    }

    public WorkflowData(Namespace workflow) {
        if (workflow == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(workflow);
    }

    public WorkflowData(String nameSpace, List<String> keywords) {
        this.setDirty(true);
        this.setValue(new NamespaceI());
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        workflow.setName(rtypes.rstring(nameSpace));
        workflow.setKeywords((String[])keywords.toArray());
    }

    public WorkflowData(String nameSpace, String keywords) {
        this.setDirty(true);
        this.setValue(new NamespaceI());
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        workflow.setName(rtypes.rstring(nameSpace));
        workflow.setKeywords((String[])this.CSVToList(keywords).toArray());
    }

    public WorkflowData() {
        this.setDirty(true);
        this.setValue(new NamespaceI());
    }

    public String getNameSpace() {
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        RString namespace = workflow.getName();
        if (namespace != null) {
            return namespace.getValue();
        }
        return "";
    }

    public String getKeywords() {
        Namespace workflow = (Namespace)this.asIObject();
        String keywordString = "";
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        String[] keywords = workflow.getKeywords();
        for (int i = 0; i < keywords.length; ++i) {
            keywordString = keywordString + keywords[i];
            if (i >= keywords.length - 1) continue;
            keywordString = keywordString + ",";
        }
        return keywordString;
    }

    public List<String> getKeywordsAsList() {
        Namespace workflow = (Namespace)this.asIObject();
        ArrayList<String> keywordList = new ArrayList<String>();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        String[] keywords = workflow.getKeywords();
        if (keywords != null) {
            for (String keyword : keywords) {
                keywordList.add(keyword);
            }
        }
        return keywordList;
    }

    public void addKeyword(String keyword) {
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        if (this.contains(keyword)) {
            throw new IllegalArgumentException("Keyword already exists.");
        }
        List<String> keywords = this.getKeywordsAsList();
        keywords.add(keyword);
        this.setKeywords(keywords);
    }

    public void setKeywords(String keywords) {
        List<String> keywordObject;
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        this.setDirty(true);
        List<String> keywordsList = keywordObject = this.CSVToList(keywords);
        String[] keywordsArray = new String[keywordsList.size()];
        for (int i = 0; i < keywordsList.size(); ++i) {
            keywordsArray[i] = keywordsList.get(i);
        }
        workflow.setKeywords(keywordsArray);
    }

    public void setKeywords(List<String> keywords) {
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        this.setDirty(true);
        String[] keywordString = new String[keywords.size()];
        for (int i = 0; i < keywords.size(); ++i) {
            keywordString[i] = keywords.get(i);
        }
        workflow.setKeywords(keywordString);
    }

    public boolean contains(String value) {
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        String[] keywords = workflow.getKeywords();
        if (keywords == null) {
            return false;
        }
        for (String keyword : keywords) {
            if (!value.equals(keyword)) continue;
            return true;
        }
        return false;
    }

    public void setNamespace(String namespace) {
        Namespace workflow = (Namespace)this.asIObject();
        if (workflow == null) {
            throw new IllegalArgumentException("No workflow specified.");
        }
        this.setDirty(true);
        workflow.setName(rtypes.rstring(namespace));
    }
}

