/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Correction;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Immersion;
import omero.model.Instrument;
import omero.model.Objective;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveI
extends Objective
implements ModelBased {
    public static final String MANUFACTURER = "ome.model.acquisition.Objective_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Objective_model";
    public static final String SERIALNUMBER = "ome.model.acquisition.Objective_serialNumber";
    public static final String NOMINALMAGNIFICATION = "ome.model.acquisition.Objective_nominalMagnification";
    public static final String CALIBRATEDMAGNIFICATION = "ome.model.acquisition.Objective_calibratedMagnification";
    public static final String LENSNA = "ome.model.acquisition.Objective_lensNA";
    public static final String IMMERSION = "ome.model.acquisition.Objective_immersion";
    public static final String CORRECTION = "ome.model.acquisition.Objective_correction";
    public static final String WORKINGDISTANCE = "ome.model.acquisition.Objective_workingDistance";
    public static final String IRIS = "ome.model.acquisition.Objective_iris";
    public static final String INSTRUMENT = "ome.model.acquisition.Objective_instrument";
    public static final String DETAILS = "ome.model.acquisition.Objective_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public ObjectiveI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ObjectiveI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ObjectiveI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadManufacturer();
        this.unloadModel();
        this.unloadSerialNumber();
        this.unloadNominalMagnification();
        this.unloadCalibratedMagnification();
        this.unloadLensNA();
        this.unloadImmersion();
        this.unloadCorrection();
        this.unloadWorkingDistance();
        this.unloadIris();
        this.unloadInstrument();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ObjectiveI copy = new ObjectiveI();
        copy.id = this.id;
        copy.version = this.version;
        copy.manufacturer = this.manufacturer;
        copy.model = this.model;
        copy.serialNumber = this.serialNumber;
        copy.nominalMagnification = this.nominalMagnification;
        copy.calibratedMagnification = this.calibratedMagnification;
        copy.lensNA = this.lensNA;
        copy.immersion = this.immersion == null ? null : (Immersion)this.immersion.proxy();
        copy.correction = this.correction == null ? null : (Correction)this.correction.proxy();
        copy.workingDistance = this.workingDistance;
        copy.iris = this.iris;
        copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ObjectiveI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadManufacturer() {
        this.manufacturer = null;
    }

    @Override
    public RString getManufacturer(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(RString manufacturer, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.manufacturer = manufacturer;
    }

    private void copyManufacturer(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.manufacturer = source.getManufacturer() == null ? null : rtypes.rstring(source.getManufacturer());
    }

    private void fillManufacturer(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setManufacturer((String)mapper.fromRType(this.getManufacturer()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadModel() {
        this.model = null;
    }

    @Override
    public RString getModel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.model;
    }

    @Override
    public void setModel(RString model, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.model = model;
    }

    private void copyModel(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.model = source.getModel() == null ? null : rtypes.rstring(source.getModel());
    }

    private void fillModel(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setModel((String)mapper.fromRType(this.getModel()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSerialNumber() {
        this.serialNumber = null;
    }

    @Override
    public RString getSerialNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.serialNumber;
    }

    @Override
    public void setSerialNumber(RString serialNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.serialNumber = serialNumber;
    }

    private void copySerialNumber(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.serialNumber = source.getSerialNumber() == null ? null : rtypes.rstring(source.getSerialNumber());
    }

    private void fillSerialNumber(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setSerialNumber((String)mapper.fromRType(this.getSerialNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadNominalMagnification() {
        this.nominalMagnification = null;
    }

    @Override
    public RInt getNominalMagnification(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.nominalMagnification;
    }

    @Override
    public void setNominalMagnification(RInt nominalMagnification, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.nominalMagnification = nominalMagnification;
    }

    private void copyNominalMagnification(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.nominalMagnification = source.getNominalMagnification() == null ? null : rtypes.rint(source.getNominalMagnification());
    }

    private void fillNominalMagnification(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setNominalMagnification((Integer)mapper.fromRType(this.getNominalMagnification()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadCalibratedMagnification() {
        this.calibratedMagnification = null;
    }

    @Override
    public RDouble getCalibratedMagnification(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.calibratedMagnification;
    }

    @Override
    public void setCalibratedMagnification(RDouble calibratedMagnification, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.calibratedMagnification = calibratedMagnification;
    }

    private void copyCalibratedMagnification(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.calibratedMagnification = source.getCalibratedMagnification() == null ? null : rtypes.rdouble(source.getCalibratedMagnification());
    }

    private void fillCalibratedMagnification(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setCalibratedMagnification((Double)mapper.fromRType(this.getCalibratedMagnification()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadLensNA() {
        this.lensNA = null;
    }

    @Override
    public RDouble getLensNA(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lensNA;
    }

    @Override
    public void setLensNA(RDouble lensNA, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lensNA = lensNA;
    }

    private void copyLensNA(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.lensNA = source.getLensNA() == null ? null : rtypes.rdouble(source.getLensNA());
    }

    private void fillLensNA(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setLensNA((Double)mapper.fromRType(this.getLensNA()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadImmersion() {
        this.immersion = null;
    }

    @Override
    public Immersion getImmersion(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.immersion;
    }

    @Override
    public void setImmersion(Immersion immersion, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.immersion = immersion;
    }

    private void copyImmersion(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.immersion = (Immersion)mapper.findTarget(source.getImmersion());
    }

    private void fillImmersion(ome.model.acquisition.Objective target, IceMapper mapper) {
        target.putAt(IMMERSION, mapper.reverse((ModelBased)((Object)this.getImmersion())));
    }

    public void unloadCorrection() {
        this.correction = null;
    }

    @Override
    public Correction getCorrection(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.correction;
    }

    @Override
    public void setCorrection(Correction correction, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.correction = correction;
    }

    private void copyCorrection(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.correction = (Correction)mapper.findTarget(source.getCorrection());
    }

    private void fillCorrection(ome.model.acquisition.Objective target, IceMapper mapper) {
        target.putAt(CORRECTION, mapper.reverse((ModelBased)((Object)this.getCorrection())));
    }

    public void unloadWorkingDistance() {
        this.workingDistance = null;
    }

    @Override
    public RDouble getWorkingDistance(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.workingDistance;
    }

    @Override
    public void setWorkingDistance(RDouble workingDistance, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.workingDistance = workingDistance;
    }

    private void copyWorkingDistance(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.workingDistance = source.getWorkingDistance() == null ? null : rtypes.rdouble(source.getWorkingDistance());
    }

    private void fillWorkingDistance(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setWorkingDistance((Double)mapper.fromRType(this.getWorkingDistance()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadIris() {
        this.iris = null;
    }

    @Override
    public RBool getIris(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.iris;
    }

    @Override
    public void setIris(RBool iris, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.iris = iris;
    }

    private void copyIris(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.iris = source.getIris() == null ? null : rtypes.rbool(source.getIris());
    }

    private void fillIris(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setIris((Boolean)mapper.fromRType(this.getIris()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.acquisition.Objective target, IceMapper mapper) {
        target.putAt(INSTRUMENT, mapper.reverse((ModelBased)((Object)this.getInstrument())));
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.Objective) {
            ome.model.acquisition.Objective source = (ome.model.acquisition.Objective)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyManufacturer(source, mapper);
                this.copyModel(source, mapper);
                this.copySerialNumber(source, mapper);
                this.copyNominalMagnification(source, mapper);
                this.copyCalibratedMagnification(source, mapper);
                this.copyLensNA(source, mapper);
                this.copyImmersion(source, mapper);
                this.copyCorrection(source, mapper);
                this.copyWorkingDistance(source, mapper);
                this.copyIris(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Objective cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.Objective target = new ome.model.acquisition.Objective();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillManufacturer(target, mapper);
            this.fillModel(target, mapper);
            this.fillSerialNumber(target, mapper);
            this.fillNominalMagnification(target, mapper);
            this.fillCalibratedMagnification(target, mapper);
            this.fillLensNA(target, mapper);
            this.fillImmersion(target, mapper);
            this.fillCorrection(target, mapper);
            this.fillWorkingDistance(target, mapper);
            this.fillIris(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<ObjectiveI> cast(List list) {
        return list;
    }
}

