/*
 * Decompiled with CFR 0.152.
 */
package omero.grid.monitors;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.InputStream;
import Ice.MarshalException;
import Ice.ObjectImpl;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import Ice.StringSeqHelper;
import IceInternal.BasicStream;
import IceInternal.Incoming;
import java.util.Arrays;
import omero.OmeroFSError;
import omero.grid.monitors.MonitorClientPrx;
import omero.grid.monitors.MonitorClientPrxHelper;
import omero.grid.monitors.MonitorServer;
import omero.grid.monitors.MonitorState;
import omero.grid.monitors.MonitorType;
import omero.grid.monitors.PathMode;
import omero.grid.monitors.WatchEventListHelper;
import omero.grid.monitors.WatchEventType;

public abstract class _MonitorServerDisp
extends ObjectImpl
implements MonitorServer {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::grid::monitors::MonitorServer"};
    private static final String[] __all = new String[]{"createMonitor", "destroyMonitor", "getMonitorState", "ice_id", "ice_ids", "ice_isA", "ice_ping", "startMonitor", "stopMonitor"};

    protected void ice_copyStateFrom(Ice.Object __obj) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids() {
        return __ids;
    }

    public String[] ice_ids(Current __current) {
        return __ids;
    }

    public String ice_id() {
        return __ids[1];
    }

    public String ice_id(Current __current) {
        return __ids[1];
    }

    public static String ice_staticId() {
        return __ids[1];
    }

    public final String createMonitor(MonitorType mType, WatchEventType[] eTypes, PathMode pMode, String pathString, String[] whitelist, String[] blacklist, float timeout, int blockSize, boolean ignoreSysFiles, boolean ignoreDirEvents, MonitorClientPrx proxy) throws OmeroFSError {
        return this.createMonitor(mType, eTypes, pMode, pathString, whitelist, blacklist, timeout, blockSize, ignoreSysFiles, ignoreDirEvents, proxy, null);
    }

    public final void destroyMonitor(String id) throws OmeroFSError {
        this.destroyMonitor(id, null);
    }

    public final MonitorState getMonitorState(String id) throws OmeroFSError {
        return this.getMonitorState(id, null);
    }

    public final void startMonitor(String id) throws OmeroFSError {
        this.startMonitor(id, null);
    }

    public final void stopMonitor(String id) throws OmeroFSError {
        this.stopMonitor(id, null);
    }

    public static DispatchStatus ___createMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        MonitorType mType = MonitorType.__read(__is);
        WatchEventType[] eTypes = WatchEventListHelper.read(__is);
        PathMode pMode = PathMode.__read(__is);
        String pathString = __is.readString();
        String[] whitelist = StringSeqHelper.read(__is);
        String[] blacklist = StringSeqHelper.read(__is);
        float timeout = __is.readFloat();
        int blockSize = __is.readInt();
        boolean ignoreSysFiles = __is.readBool();
        boolean ignoreDirEvents = __is.readBool();
        MonitorClientPrx proxy = MonitorClientPrxHelper.__read(__is);
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            String __ret = __obj.createMonitor(mType, eTypes, pMode, pathString, whitelist, blacklist, timeout, blockSize, ignoreSysFiles, ignoreDirEvents, proxy, __current);
            __os.writeString(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___startMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode(OperationMode.Idempotent, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.startMonitor(id, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___stopMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode(OperationMode.Idempotent, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.stopMonitor(id, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___destroyMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode(OperationMode.Idempotent, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.destroyMonitor(id, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getMonitorState(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode(OperationMode.Idempotent, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            MonitorState __ret = __obj.getMonitorState(id, __current);
            __ret.__write(__os);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return _MonitorServerDisp.___createMonitor(this, in, __current);
            }
            case 1: {
                return _MonitorServerDisp.___destroyMonitor(this, in, __current);
            }
            case 2: {
                return _MonitorServerDisp.___getMonitorState(this, in, __current);
            }
            case 3: {
                return _MonitorServerDisp.___ice_id(this, in, __current);
            }
            case 4: {
                return _MonitorServerDisp.___ice_ids(this, in, __current);
            }
            case 5: {
                return _MonitorServerDisp.___ice_isA(this, in, __current);
            }
            case 6: {
                return _MonitorServerDisp.___ice_ping(this, in, __current);
            }
            case 7: {
                return _MonitorServerDisp.___startMonitor(this, in, __current);
            }
            case 8: {
                return _MonitorServerDisp.___stopMonitor(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    public void __write(BasicStream __os) {
        __os.writeTypeId(_MonitorServerDisp.ice_staticId());
        __os.startWriteSlice();
        __os.endWriteSlice();
        super.__write(__os);
    }

    public void __read(BasicStream __is, boolean __rid) {
        if (__rid) {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.endReadSlice();
        super.__read(__is, true);
    }

    public void __write(OutputStream __outS) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::grid::monitors::MonitorServer was not generated with stream support";
        throw ex;
    }

    public void __read(InputStream __inS, boolean __rid) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::grid::monitors::MonitorServer was not generated with stream support";
        throw ex;
    }
}

