/*
 * Decompiled with CFR 0.152.
 */
package ome.model.jobs;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.jobs.JobOriginalFileLink;
import ome.model.jobs.JobStatus;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="job_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="job_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="job_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="job_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="job_owner_filter_ORIGINALFILELINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="job_group_filter_ORIGINALFILELINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="job_event_filter_ORIGINALFILELINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="job_perms_filter_ORIGINALFILELINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="job_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="job_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="job_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="job_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="job", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_job", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_job"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public abstract class Job
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "job_owner_filter";
    public static final String GROUP_FILTER = "job_group_filter";
    public static final String EVENT_FILTER = "job_event_filter";
    public static final String PERMS_FILTER = "job_perms_filter";
    public static final String ID = "ome.model.jobs.Job_id";
    protected Long id;
    public static final String VERSION = "ome.model.jobs.Job_version";
    protected Integer version = 0;
    protected String username = null;
    protected String groupname = null;
    protected String type = null;
    protected String message = null;
    protected JobStatus status = null;
    protected Timestamp submitted = null;
    protected Timestamp scheduledFor = null;
    protected Timestamp started = null;
    protected Timestamp finished = null;
    protected Set<JobOriginalFileLink> originalFileLinks = new HashSet<JobOriginalFileLink>();
    public static final String OWNER_FILTER_ORIGINALFILELINKS = "job_owner_filter_ORIGINALFILELINKS";
    public static final String GROUP_FILTER_ORIGINALFILELINKS = "job_group_filter_ORIGINALFILELINKS";
    public static final String EVENT_FILTER_ORIGINALFILELINKS = "job_event_filter_ORIGINALFILELINKS";
    public static final String PERMS_FILTER_ORIGINALFILELINKS = "job_perms_filter_ORIGINALFILELINKS";
    private Map<Long, Long> originalFileLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String USERNAME = "ome.model.jobs.Job_username";
    public static final String GROUPNAME = "ome.model.jobs.Job_groupname";
    public static final String TYPE = "ome.model.jobs.Job_type";
    public static final String MESSAGE = "ome.model.jobs.Job_message";
    public static final String STATUS = "ome.model.jobs.Job_status";
    public static final String SUBMITTED = "ome.model.jobs.Job_submitted";
    public static final String SCHEDULEDFOR = "ome.model.jobs.Job_scheduledFor";
    public static final String STARTED = "ome.model.jobs.Job_started";
    public static final String FINISHED = "ome.model.jobs.Job_finished";
    public static final String ORIGINALFILELINKSCOUNTPEROWNER = "ome.model.jobs.Job_originalFileLinksCountPerOwner";
    public static final String ORIGINALFILELINKS = "ome.model.jobs.Job_originalFileLinks";
    public static final String DETAILS = "ome.model.jobs.Job_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Job() {
        this(null, true);
    }

    protected Job(Long id) {
        this(id, true);
    }

    public Job(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Job(String _username, String _groupname, String _type, String _message, JobStatus _status, Timestamp _submitted, Timestamp _scheduledFor) {
        this(null, true);
        this.setUsername(_username);
        this.setGroupname(_groupname);
        this.setType(_type);
        this.setMessage(_message);
        this.setStatus(_status);
        this.setSubmitted(_submitted);
        this.setScheduledFor(_scheduledFor);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_job")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="username", updatable=true)
    public String getUsername() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.username;
    }

    public void setUsername(String username) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.username = username;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="groupname", updatable=true)
    public String getGroupname() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.groupname = groupname;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="type", updatable=true)
    public String getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(String type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="message", updatable=true)
    public String getMessage() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.message;
    }

    public void setMessage(String message) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.message = message;
    }

    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=JobStatus.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="status", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKjob_status_jobstatus")
    public JobStatus getStatus() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.status;
    }

    public void setStatus(JobStatus status) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.status = status;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="submitted", updatable=true)
    public Timestamp getSubmitted() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.submitted;
    }

    public void setSubmitted(Timestamp submitted) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.submitted = submitted;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="scheduledFor", updatable=true)
    public Timestamp getScheduledFor() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.scheduledFor;
    }

    public void setScheduledFor(Timestamp scheduledFor) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.scheduledFor = scheduledFor;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="started", updatable=true)
    public Timestamp getStarted() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.started;
    }

    public void setStarted(Timestamp started) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.started = started;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="finished", updatable=true)
    public Timestamp getFinished() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.finished;
    }

    public void setFinished(Timestamp finished) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.finished = finished;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="job_owner_filter_ORIGINALFILELINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="job_group_filter_ORIGINALFILELINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="job_event_filter_ORIGINALFILELINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="job_perms_filter_ORIGINALFILELINKS", condition=":permsStr = permissions")})
    protected Set<JobOriginalFileLink> getOriginalFileLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.originalFileLinks;
    }

    protected void setOriginalFileLinks(Set<JobOriginalFileLink> originalFileLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.originalFileLinks = originalFileLinks;
    }

    public int sizeOfOriginalFileLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.originalFileLinks == null ? -1 : this.originalFileLinks.size();
    }

    public Iterator<JobOriginalFileLink> iterateOriginalFileLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            return new EmptyIterator<JobOriginalFileLink>();
        }
        return this.getOriginalFileLinks().iterator();
    }

    public Collection<JobOriginalFileLink> unmodifiableOriginalFileLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getOriginalFileLinks());
    }

    public <E> List<E> collectOriginalFileLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<JobOriginalFileLink> it = this.iterateOriginalFileLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addJobOriginalFileLink(JobOriginalFileLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            this.throwNullCollectionException("OriginalFileLinks");
        }
        this.getOriginalFileLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addJobOriginalFileLinkSet(Collection<JobOriginalFileLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            this.throwNullCollectionException("OriginalFileLinks");
        }
        this.getOriginalFileLinks().addAll(targets);
        for (JobOriginalFileLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeJobOriginalFileLink(JobOriginalFileLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            this.throwNullCollectionException("OriginalFileLinks");
        }
        this.getOriginalFileLinks().remove(target);
        target.setParent(null);
    }

    public void removeJobOriginalFileLinkSet(Collection<JobOriginalFileLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            this.throwNullCollectionException("OriginalFileLinks");
        }
        this.getOriginalFileLinks().removeAll(targets);
        for (JobOriginalFileLink target : targets) {
            target.setParent(null);
        }
    }

    public JobOriginalFileLink linkOriginalFile(OriginalFile addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        JobOriginalFileLink link = new JobOriginalFileLink();
        link.link(this, addition);
        this.addJobOriginalFileLink(link, true);
        return link;
    }

    public void addJobOriginalFileLink(JobOriginalFileLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            this.throwNullCollectionException("OriginalFileLinks");
        }
        this.getOriginalFileLinks().add(link);
    }

    public Iterator<OriginalFile> linkedOriginalFileIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            return new EmptyIterator<OriginalFile>();
        }
        final Iterator<JobOriginalFileLink> it = this.getOriginalFileLinks().iterator();
        return new Iterator<OriginalFile>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public OriginalFile next() {
                if (it == null) {
                    throw new NoSuchElementException("originalFileLinks is null; no elements.");
                }
                JobOriginalFileLink link = (JobOriginalFileLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<JobOriginalFileLink> findJobOriginalFileLink(OriginalFile target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<JobOriginalFileLink> it = this.iterateOriginalFileLinks();
        HashSet<JobOriginalFileLink> result = new HashSet<JobOriginalFileLink>();
        while (it.hasNext()) {
            JobOriginalFileLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<OriginalFile> linkedOriginalFileList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<OriginalFile> it = this.linkedOriginalFileIterator();
        ArrayList<OriginalFile> list = new ArrayList<OriginalFile>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedOriginalFile(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<OriginalFile> it = this.linkedOriginalFileIterator();
        while (it.hasNext()) {
            OriginalFile obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkOriginalFile(OriginalFile removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<JobOriginalFileLink> toRemove = this.findJobOriginalFileLink(removal);
        Iterator<JobOriginalFileLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeJobOriginalFileLink(it.next(), true);
        }
    }

    public void removeJobOriginalFileLink(JobOriginalFileLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOriginalFileLinks() == null) {
            this.throwNullCollectionException("OriginalFileLinks");
        }
        this.getOriginalFileLinks().remove(link);
    }

    public void clearOriginalFileLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<JobOriginalFileLink> list = new ArrayList<JobOriginalFileLink>(this.getOriginalFileLinks());
        for (JobOriginalFileLink link : list) {
            this.removeJobOriginalFileLink(link, true);
        }
    }

    protected void setOriginalFileLinksCountPerOwner(Map<Long, Long> map) {
        this.originalFileLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Job_originalFileLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Job_originalFileLinks_by_owner", joinColumns={@JoinColumn(name="Job_id")})
    public Map<Long, Long> getOriginalFileLinksCountPerOwner() {
        return this.originalFileLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.username = (String)__filter.filter(USERNAME, this.username);
            this.groupname = (String)__filter.filter(GROUPNAME, this.groupname);
            this.type = (String)__filter.filter(TYPE, this.type);
            this.message = (String)__filter.filter(MESSAGE, this.message);
            this.status = (JobStatus)__filter.filter(STATUS, this.status);
            this.submitted = (Timestamp)__filter.filter(SUBMITTED, this.submitted);
            this.scheduledFor = (Timestamp)__filter.filter(SCHEDULEDFOR, this.scheduledFor);
            this.started = (Timestamp)__filter.filter(STARTED, this.started);
            this.finished = (Timestamp)__filter.filter(FINISHED, this.finished);
            this.originalFileLinksCountPerOwner = __filter.filter(ORIGINALFILELINKSCOUNTPEROWNER, this.originalFileLinksCountPerOwner);
            this.originalFileLinks = (Set)__filter.filter(ORIGINALFILELINKS, this.originalFileLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(USERNAME)) {
            return this.getUsername();
        }
        if (field.equals(GROUPNAME)) {
            return this.getGroupname();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(MESSAGE)) {
            return this.getMessage();
        }
        if (field.equals(STATUS)) {
            return this.getStatus();
        }
        if (field.equals(SUBMITTED)) {
            return this.getSubmitted();
        }
        if (field.equals(SCHEDULEDFOR)) {
            return this.getScheduledFor();
        }
        if (field.equals(STARTED)) {
            return this.getStarted();
        }
        if (field.equals(FINISHED)) {
            return this.getFinished();
        }
        if (field.equals(ORIGINALFILELINKSCOUNTPEROWNER)) {
            return this.getOriginalFileLinksCountPerOwner();
        }
        if (field.equals(ORIGINALFILELINKS)) {
            return this.getOriginalFileLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(USERNAME)) {
            this.setUsername((String)value);
        } else if (field.equals(GROUPNAME)) {
            this.setGroupname((String)value);
        } else if (field.equals(TYPE)) {
            this.setType((String)value);
        } else if (field.equals(MESSAGE)) {
            this.setMessage((String)value);
        } else if (field.equals(STATUS)) {
            this.setStatus((JobStatus)value);
        } else if (field.equals(SUBMITTED)) {
            this.setSubmitted((Timestamp)value);
        } else if (field.equals(SCHEDULEDFOR)) {
            this.setScheduledFor((Timestamp)value);
        } else if (field.equals(STARTED)) {
            this.setStarted((Timestamp)value);
        } else if (field.equals(FINISHED)) {
            this.setFinished((Timestamp)value);
        } else if (field.equals(ORIGINALFILELINKSCOUNTPEROWNER)) {
            this.setOriginalFileLinksCountPerOwner((Map)value);
        } else if (field.equals(ORIGINALFILELINKS)) {
            this.setOriginalFileLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.username = null;
        this.groupname = null;
        this.type = null;
        this.message = null;
        this.status = null;
        this.submitted = null;
        this.scheduledFor = null;
        this.started = null;
        this.finished = null;
        this.originalFileLinksCountPerOwner = null;
        this.originalFileLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(USERNAME);
        raw.add(GROUPNAME);
        raw.add(TYPE);
        raw.add(MESSAGE);
        raw.add(STATUS);
        raw.add(SUBMITTED);
        raw.add(SCHEDULEDFOR);
        raw.add(STARTED);
        raw.add(FINISHED);
        raw.add(ORIGINALFILELINKSCOUNTPEROWNER);
        raw.add(ORIGINALFILELINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKjob_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKjob_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKjob_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKjob_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKjob_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

