/*
 * Decompiled with CFR 0.152.
 */
package ome.model.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import ome.model.IObject;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.Filter;
import ome.util.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class Details
implements Filterable,
Serializable {
    private static final long serialVersionUID = 1176546684904748977L;
    public static final String PERMISSIONS = "Details_permissions";
    public static final String EXTERNALINFO = "Details_externalInfo";
    public static final String CREATIONEVENT = "Details_creationEvent";
    public static final String OWNER = "Details_owner";
    public static final String GROUP = "Details_group";
    public static final String UPDATEEVENT = "Details_updateEvent";
    protected Event _update;
    protected IObject _context;
    protected Permissions _perms;
    protected ExternalInfo _externalInfo;
    protected Event _creation;
    protected Experimenter _owner;
    protected ExperimenterGroup _group;
    @Transient
    Set<String> _filteredCollections;
    @Transient
    Map _dynamicFields;

    public static final Details create() {
        return new Details(){
            private static final long serialVersionUID = 1176546684904748977L;

            public Details newInstance() {
                return Details.create();
            }
        };
    }

    public Details() {
    }

    public Details(Details copy) {
        this.copy(copy);
    }

    public Details shallowCopy() {
        Details d = this.newInstance();
        d.shallowCopy(this);
        return d;
    }

    public Details copy() {
        Details d = this.newInstance();
        d.copy(this);
        return d;
    }

    public void copy(Details copy) {
        if (copy == null) {
            throw new IllegalArgumentException("argument may not be null");
        }
        this.setContext(copy.getContext());
        Permissions p = null;
        if (copy.getPermissions() != null) {
            p = new Permissions().revokeAll(copy.getPermissions());
        }
        this.setPermissions(p);
        this.setCreationEvent(copy.getCreationEvent());
        this.setOwner(copy.getOwner());
        this.setGroup(copy.getGroup());
        this.setUpdateEvent(copy.getUpdateEvent());
        this._filteredCollections = copy.filteredSet();
    }

    public void shallowCopy(Details copy) {
        if (copy == null) {
            throw new IllegalArgumentException("argument may not be null");
        }
        this.setOwner(copy.getOwner() == null ? null : new Experimenter(copy.getOwner().getId(), false));
        this.setGroup(copy.getGroup() == null ? null : new ExperimenterGroup(copy.getGroup().getId(), false));
        this.setCreationEvent(copy.getCreationEvent() == null ? null : new Event(copy.getCreationEvent().getId(), false));
        this.setPermissions(copy.getPermissions() == null ? null : new Permissions().revokeAll(copy.getPermissions()));
        this.setExternalInfo(copy.getExternalInfo() == null ? null : new ExternalInfo(copy.getExternalInfo().getId(), false));
        this.setUpdateEvent(copy.getUpdateEvent() == null ? null : new Event(copy.getUpdateEvent().getId(), false));
        this._filteredCollections = copy.filteredSet();
    }

    public void addFiltered(String collectionName) {
        if (this._filteredCollections == null) {
            this._filteredCollections = new HashSet<String>();
        }
        this._filteredCollections.add(collectionName);
    }

    public void addFiltered(Collection<String> collection) {
        if (this._filteredCollections == null) {
            this._filteredCollections = new HashSet<String>();
        }
        this._filteredCollections.addAll(collection);
    }

    public boolean isFiltered(String collectionName) {
        if (this._filteredCollections == null) {
            return false;
        }
        return this._filteredCollections.contains(collectionName);
    }

    public void clearFiltered() {
        this._filteredCollections = null;
    }

    public int filteredSize() {
        if (this._filteredCollections == null) {
            return 0;
        }
        return this._filteredCollections.size();
    }

    public Set<String> filteredSet() {
        if (this._filteredCollections == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(this._filteredCollections);
    }

    @Transient
    public IObject getContext() {
        return this._context;
    }

    public void setContext(IObject myContext) {
        this._context = myContext;
    }

    public abstract Details newInstance();

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Details:{");
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(";perm=");
        sb.append(this._perms == null ? null : this._perms.toString());
        if (this._externalInfo != null) {
            sb.append(";external=" + this._externalInfo.getId());
        }
        sb.append("user=");
        sb.append(this._owner == null ? null : this._owner.getId());
        sb.append(";group=");
        sb.append(this._group == null ? null : this._group.getId());
        sb.append(";create=");
        sb.append(this._creation == null ? null : this._creation.getId());
        sb.append(";update=");
        sb.append(this._update == null ? null : this._update.getId());
    }

    @Transient
    public Permissions getPermissions() {
        return this._perms;
    }

    public void setPermissions(Permissions perms) {
        this._perms = perms;
    }

    @Transient
    public ExternalInfo getExternalInfo() {
        return this._externalInfo;
    }

    public void setExternalInfo(ExternalInfo info) {
        this._externalInfo = info;
    }

    @Transient
    public Experimenter getOwner() {
        return this._owner;
    }

    public void setOwner(Experimenter exp) {
        this._owner = exp;
    }

    @Transient
    public Event getCreationEvent() {
        return this._creation;
    }

    public void setCreationEvent(Event e) {
        this._creation = e;
    }

    @Transient
    public ExperimenterGroup getGroup() {
        return this._group;
    }

    public void setGroup(ExperimenterGroup _group) {
        this._group = _group;
    }

    @Transient
    public Event getUpdateEvent() {
        return this._update;
    }

    public void setUpdateEvent(Event e) {
        this._update = e;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.setPermissions((Permissions)filter.filter(PERMISSIONS, this.getPermissions()));
        this.setExternalInfo((ExternalInfo)filter.filter(EXTERNALINFO, this.getExternalInfo()));
        this.setOwner((Experimenter)filter.filter(OWNER, this.getOwner()));
        this.setGroup((ExperimenterGroup)filter.filter(GROUP, this.getGroup()));
        this.setCreationEvent((Event)filter.filter(CREATIONEVENT, this.getCreationEvent()));
        this.setUpdateEvent((Event)filter.filter(UPDATEEVENT, this.getUpdateEvent()));
        return true;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(OWNER)) {
            return this.getOwner();
        }
        if (field.equals(GROUP)) {
            return this.getGroup();
        }
        if (field.equals(CREATIONEVENT)) {
            return this.getCreationEvent();
        }
        if (field.equals(PERMISSIONS)) {
            return this.getPermissions();
        }
        if (field.equals(EXTERNALINFO)) {
            return this.getExternalInfo();
        }
        if (field.equals(UPDATEEVENT)) {
            return this.getUpdateEvent();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(OWNER)) {
            this.setOwner((Experimenter)value);
        } else if (field.equals(GROUP)) {
            this.setGroup((ExperimenterGroup)value);
        } else if (field.equals(CREATIONEVENT)) {
            this.setCreationEvent((Event)value);
        } else if (field.equals(PERMISSIONS)) {
            this.setPermissions((Permissions)value);
        } else if (field.equals(EXTERNALINFO)) {
            this.setExternalInfo((ExternalInfo)value);
        } else if (field.equals(UPDATEEVENT)) {
            this.setUpdateEvent((Event)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }
}

