/*
 * Decompiled with CFR 0.152.
 */
package ome.model.display;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import ome.model.display.CodomainMapContext;
import ome.model.display.QuantumDef;
import ome.model.enums.RenderingModel;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="renderingdef_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="renderingdef_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="renderingdef_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="renderingdef_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="renderingdef_owner_filter_WAVERENDERING", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="renderingdef_group_filter_WAVERENDERING", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="renderingdef_event_filter_WAVERENDERING", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="renderingdef_perms_filter_WAVERENDERING", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="renderingdef_owner_filter_SPATIALDOMAINENHANCEMENT", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="renderingdef_group_filter_SPATIALDOMAINENHANCEMENT", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="renderingdef_event_filter_SPATIALDOMAINENHANCEMENT", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="renderingdef_perms_filter_SPATIALDOMAINENHANCEMENT", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="renderingdef_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="renderingdef_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="renderingdef_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="renderingdef_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="renderingdef", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_renderingdef", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_renderingdef"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class RenderingDef
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "renderingdef_owner_filter";
    public static final String GROUP_FILTER = "renderingdef_group_filter";
    public static final String EVENT_FILTER = "renderingdef_event_filter";
    public static final String PERMS_FILTER = "renderingdef_perms_filter";
    public static final String ID = "ome.model.display.RenderingDef_id";
    protected Long id;
    public static final String VERSION = "ome.model.display.RenderingDef_version";
    protected Integer version = 0;
    protected Pixels pixels = null;
    protected Integer defaultZ = null;
    protected Integer defaultT = null;
    protected RenderingModel model = null;
    protected List<ChannelBinding> waveRendering = new ArrayList<ChannelBinding>();
    public static final String OWNER_FILTER_WAVERENDERING = "renderingdef_owner_filter_WAVERENDERING";
    public static final String GROUP_FILTER_WAVERENDERING = "renderingdef_group_filter_WAVERENDERING";
    public static final String EVENT_FILTER_WAVERENDERING = "renderingdef_event_filter_WAVERENDERING";
    public static final String PERMS_FILTER_WAVERENDERING = "renderingdef_perms_filter_WAVERENDERING";
    protected String name = null;
    protected Double compression = null;
    protected QuantumDef quantization = null;
    protected List<CodomainMapContext> spatialDomainEnhancement = new ArrayList<CodomainMapContext>();
    public static final String OWNER_FILTER_SPATIALDOMAINENHANCEMENT = "renderingdef_owner_filter_SPATIALDOMAINENHANCEMENT";
    public static final String GROUP_FILTER_SPATIALDOMAINENHANCEMENT = "renderingdef_group_filter_SPATIALDOMAINENHANCEMENT";
    public static final String EVENT_FILTER_SPATIALDOMAINENHANCEMENT = "renderingdef_event_filter_SPATIALDOMAINENHANCEMENT";
    public static final String PERMS_FILTER_SPATIALDOMAINENHANCEMENT = "renderingdef_perms_filter_SPATIALDOMAINENHANCEMENT";
    protected ome.model.internal.Details details = new Details();
    public static final String PIXELS = "ome.model.display.RenderingDef_pixels";
    public static final String DEFAULTZ = "ome.model.display.RenderingDef_defaultZ";
    public static final String DEFAULTT = "ome.model.display.RenderingDef_defaultT";
    public static final String MODEL = "ome.model.display.RenderingDef_model";
    public static final String WAVERENDERING = "ome.model.display.RenderingDef_waveRendering";
    public static final String NAME = "ome.model.display.RenderingDef_name";
    public static final String COMPRESSION = "ome.model.display.RenderingDef_compression";
    public static final String QUANTIZATION = "ome.model.display.RenderingDef_quantization";
    public static final String SPATIALDOMAINENHANCEMENT = "ome.model.display.RenderingDef_spatialDomainEnhancement";
    public static final String DETAILS = "ome.model.display.RenderingDef_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public RenderingDef() {
        this(null, true);
    }

    protected RenderingDef(Long id) {
        this(id, true);
    }

    public RenderingDef(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public RenderingDef(Pixels _pixels, Integer _defaultZ, Integer _defaultT, RenderingModel _model, QuantumDef _quantization) {
        this(null, true);
        this.setPixels(_pixels);
        this.setDefaultZ(_defaultZ);
        this.setDefaultT(_defaultT);
        this.setModel(_model);
        this.setQuantization(_quantization);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_renderingdef")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Pixels.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="pixels", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKrenderingdef_pixels_pixels")
    public Pixels getPixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixels;
    }

    public void setPixels(Pixels pixels) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixels = pixels;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="defaultZ", updatable=true)
    public Integer getDefaultZ() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.defaultZ;
    }

    public void setDefaultZ(Integer defaultZ) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.defaultZ = defaultZ;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="defaultT", updatable=true)
    public Integer getDefaultT() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.defaultT;
    }

    public void setDefaultT(Integer defaultT) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.defaultT = defaultT;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=RenderingModel.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="model", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKrenderingdef_model_renderingmodel")
    public RenderingModel getModel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.model;
    }

    public void setModel(RenderingModel model) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.model = model;
    }

    @JoinColumn(name="renderingDef", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="renderingDef_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="renderingdef_owner_filter_WAVERENDERING", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="renderingdef_group_filter_WAVERENDERING", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="renderingdef_event_filter_WAVERENDERING", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="renderingdef_perms_filter_WAVERENDERING", condition=":permsStr = permissions")})
    protected List<ChannelBinding> getWaveRendering() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.waveRendering;
    }

    protected void setWaveRendering(List<ChannelBinding> waveRendering) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.waveRendering = waveRendering;
    }

    public int sizeOfWaveRendering() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.waveRendering == null ? -1 : this.waveRendering.size();
    }

    public Iterator<ChannelBinding> iterateWaveRendering() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            return new EmptyIterator<ChannelBinding>();
        }
        return this.getWaveRendering().iterator();
    }

    public Collection<ChannelBinding> unmodifiableWaveRendering() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getWaveRendering());
    }

    public <E> List<E> collectWaveRendering(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ChannelBinding> it = this.iterateWaveRendering();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addChannelBinding(ChannelBinding target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        this.getWaveRendering().add(target);
        if (target != null && target.isLoaded()) {
            target.setRenderingDef(this);
        }
    }

    public void addChannelBindingSet(Collection<ChannelBinding> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        this.getWaveRendering().addAll(targets);
        for (ChannelBinding target : targets) {
            if (target == null || !target.isLoaded()) continue;
            target.setRenderingDef(this);
        }
    }

    public void removeChannelBinding(ChannelBinding target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        this.getWaveRendering().remove(target);
        if (target.isLoaded()) {
            target.setRenderingDef(null);
        }
    }

    public void removeChannelBindingSet(Collection<ChannelBinding> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        this.getWaveRendering().removeAll(targets);
        for (ChannelBinding target : targets) {
            if (!target.isLoaded()) continue;
            target.setRenderingDef(null);
        }
    }

    public void clearWaveRendering() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        this.getWaveRendering().clear();
        Iterator<ChannelBinding> it = this.iterateWaveRendering();
        while (it.hasNext()) {
            ChannelBinding target = it.next();
            target.setRenderingDef(null);
        }
    }

    public ChannelBinding getChannelBinding(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        return this.getWaveRendering().get(index);
    }

    public ChannelBinding setChannelBinding(int index, ChannelBinding element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        ChannelBinding old = this.getWaveRendering().set(index, element);
        if (element != null && element.isLoaded()) {
            element.setRenderingDef(this);
        }
        return old;
    }

    @Transient
    public ChannelBinding getPrimaryChannelBinding() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        return this.getWaveRendering().get(0);
    }

    public ChannelBinding setPrimaryChannelBinding(ChannelBinding element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWaveRendering() == null) {
            this.throwNullCollectionException("WaveRendering");
        }
        List<ChannelBinding> list = this.getWaveRendering();
        int index = list.indexOf(element);
        ChannelBinding old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="compression", updatable=true)
    public Double getCompression() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.compression;
    }

    public void setCompression(Double compression) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.compression = compression;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=QuantumDef.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="quantization", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKrenderingdef_quantization_quantumdef")
    public QuantumDef getQuantization() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.quantization;
    }

    public void setQuantization(QuantumDef quantization) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.quantization = quantization;
    }

    @JoinColumn(name="renderingDef", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="renderingDef_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="renderingdef_owner_filter_SPATIALDOMAINENHANCEMENT", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="renderingdef_group_filter_SPATIALDOMAINENHANCEMENT", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="renderingdef_event_filter_SPATIALDOMAINENHANCEMENT", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="renderingdef_perms_filter_SPATIALDOMAINENHANCEMENT", condition=":permsStr = permissions")})
    protected List<CodomainMapContext> getSpatialDomainEnhancement() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.spatialDomainEnhancement;
    }

    protected void setSpatialDomainEnhancement(List<CodomainMapContext> spatialDomainEnhancement) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.spatialDomainEnhancement = spatialDomainEnhancement;
    }

    public int sizeOfSpatialDomainEnhancement() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.spatialDomainEnhancement == null ? -1 : this.spatialDomainEnhancement.size();
    }

    public Iterator<CodomainMapContext> iterateSpatialDomainEnhancement() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            return new EmptyIterator<CodomainMapContext>();
        }
        return this.getSpatialDomainEnhancement().iterator();
    }

    public Collection<CodomainMapContext> unmodifiableSpatialDomainEnhancement() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getSpatialDomainEnhancement());
    }

    public <E> List<E> collectSpatialDomainEnhancement(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<CodomainMapContext> it = this.iterateSpatialDomainEnhancement();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addCodomainMapContext(CodomainMapContext target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        this.getSpatialDomainEnhancement().add(target);
        if (target != null && target.isLoaded()) {
            target.setRenderingDef(this);
        }
    }

    public void addCodomainMapContextSet(Collection<CodomainMapContext> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        this.getSpatialDomainEnhancement().addAll(targets);
        for (CodomainMapContext target : targets) {
            if (target == null || !target.isLoaded()) continue;
            target.setRenderingDef(this);
        }
    }

    public void removeCodomainMapContext(CodomainMapContext target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        this.getSpatialDomainEnhancement().remove(target);
        if (target.isLoaded()) {
            target.setRenderingDef(null);
        }
    }

    public void removeCodomainMapContextSet(Collection<CodomainMapContext> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        this.getSpatialDomainEnhancement().removeAll(targets);
        for (CodomainMapContext target : targets) {
            if (!target.isLoaded()) continue;
            target.setRenderingDef(null);
        }
    }

    public void clearSpatialDomainEnhancement() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        this.getSpatialDomainEnhancement().clear();
        Iterator<CodomainMapContext> it = this.iterateSpatialDomainEnhancement();
        while (it.hasNext()) {
            CodomainMapContext target = it.next();
            target.setRenderingDef(null);
        }
    }

    public CodomainMapContext getCodomainMapContext(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        return this.getSpatialDomainEnhancement().get(index);
    }

    public CodomainMapContext setCodomainMapContext(int index, CodomainMapContext element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        CodomainMapContext old = this.getSpatialDomainEnhancement().set(index, element);
        if (element != null && element.isLoaded()) {
            element.setRenderingDef(this);
        }
        return old;
    }

    @Transient
    public CodomainMapContext getPrimaryCodomainMapContext() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        return this.getSpatialDomainEnhancement().get(0);
    }

    public CodomainMapContext setPrimaryCodomainMapContext(CodomainMapContext element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSpatialDomainEnhancement() == null) {
            this.throwNullCollectionException("SpatialDomainEnhancement");
        }
        List<CodomainMapContext> list = this.getSpatialDomainEnhancement();
        int index = list.indexOf(element);
        CodomainMapContext old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public RenderingDef newInstance() {
        return new RenderingDef();
    }

    public RenderingDef proxy() {
        return new RenderingDef(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.pixels = (Pixels)__filter.filter(PIXELS, this.pixels);
            this.defaultZ = (Integer)__filter.filter(DEFAULTZ, this.defaultZ);
            this.defaultT = (Integer)__filter.filter(DEFAULTT, this.defaultT);
            this.model = (RenderingModel)__filter.filter(MODEL, this.model);
            this.waveRendering = (List)__filter.filter(WAVERENDERING, this.waveRendering);
            this.name = (String)__filter.filter(NAME, this.name);
            this.compression = (Double)__filter.filter(COMPRESSION, this.compression);
            this.quantization = (QuantumDef)__filter.filter(QUANTIZATION, this.quantization);
            this.spatialDomainEnhancement = (List)__filter.filter(SPATIALDOMAINENHANCEMENT, this.spatialDomainEnhancement);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(PIXELS)) {
            return this.getPixels();
        }
        if (field.equals(DEFAULTZ)) {
            return this.getDefaultZ();
        }
        if (field.equals(DEFAULTT)) {
            return this.getDefaultT();
        }
        if (field.equals(MODEL)) {
            return this.getModel();
        }
        if (field.equals(WAVERENDERING)) {
            return this.getWaveRendering();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(COMPRESSION)) {
            return this.getCompression();
        }
        if (field.equals(QUANTIZATION)) {
            return this.getQuantization();
        }
        if (field.equals(SPATIALDOMAINENHANCEMENT)) {
            return this.getSpatialDomainEnhancement();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(PIXELS)) {
            this.setPixels((Pixels)value);
        } else if (field.equals(DEFAULTZ)) {
            this.setDefaultZ((Integer)value);
        } else if (field.equals(DEFAULTT)) {
            this.setDefaultT((Integer)value);
        } else if (field.equals(MODEL)) {
            this.setModel((RenderingModel)value);
        } else if (field.equals(WAVERENDERING)) {
            this.setWaveRendering((List)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(COMPRESSION)) {
            this.setCompression((Double)value);
        } else if (field.equals(QUANTIZATION)) {
            this.setQuantization((QuantumDef)value);
        } else if (field.equals(SPATIALDOMAINENHANCEMENT)) {
            this.setSpatialDomainEnhancement((List)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.pixels = null;
        this.defaultZ = null;
        this.defaultT = null;
        this.model = null;
        this.waveRendering = null;
        this.name = null;
        this.compression = null;
        this.quantization = null;
        this.spatialDomainEnhancement = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(PIXELS);
        raw.add(DEFAULTZ);
        raw.add(DEFAULTT);
        raw.add(MODEL);
        raw.add(WAVERENDERING);
        raw.add(NAME);
        raw.add(COMPRESSION);
        raw.add(QUANTIZATION);
        raw.add(SPATIALDOMAINENHANCEMENT);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKrenderingdef_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKrenderingdef_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKrenderingdef_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKrenderingdef_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKrenderingdef_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

