/*
 * Decompiled with CFR 0.152.
 */
package ome.model.annotations;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.BasicAnnotation;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="/basic/time/")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class TimestampAnnotation
extends BasicAnnotation
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "timestampannotation_owner_filter";
    public static final String GROUP_FILTER = "timestampannotation_group_filter";
    public static final String EVENT_FILTER = "timestampannotation_event_filter";
    public static final String PERMS_FILTER = "timestampannotation_perms_filter";
    protected Timestamp timeValue = null;
    public static final String TIMEVALUE = "ome.model.annotations.TimestampAnnotation_timeValue";
    public static final Set<String> FIELDS;

    public TimestampAnnotation() {
        this(null, true);
    }

    protected TimestampAnnotation(Long id) {
        this(id, true);
    }

    public TimestampAnnotation(Long id, boolean loaded) {
        super(id, loaded);
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="timeValue", updatable=true)
    public Timestamp getTimeValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.timeValue;
    }

    public void setTimeValue(Timestamp timeValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.timeValue = timeValue;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public TimestampAnnotation newInstance() {
        return new TimestampAnnotation();
    }

    public TimestampAnnotation proxy() {
        return new TimestampAnnotation(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.timeValue = (Timestamp)__filter.filter(TIMEVALUE, this.timeValue);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(TIMEVALUE)) {
            return this.getTimeValue();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(TIMEVALUE)) {
            this.setTimeValue((Timestamp)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.timeValue = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(TIMEVALUE);
        raw.addAll(BasicAnnotation.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

