/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.ConnectionI;
import Ice.ObjectPrx;
import Ice.OperationMode;
import IceInternal.BasicStream;
import IceInternal.BatchOutgoing;
import IceInternal.BatchOutgoingAsync;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Outgoing;
import IceInternal.OutgoingAsync;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RouterInfo;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionRequestHandler
implements RequestHandler {
    private final Reference _reference;
    private final boolean _response;
    private final ConnectionI _connection;
    private final boolean _compress;

    @Override
    public void prepareBatchRequest(BasicStream out) {
        this._connection.prepareBatchRequest(out);
    }

    @Override
    public void finishBatchRequest(BasicStream out) {
        this._connection.finishBatchRequest(out, this._compress);
    }

    @Override
    public void abortBatchRequest() {
        this._connection.abortBatchRequest();
    }

    @Override
    public ConnectionI sendRequest(Outgoing out) throws LocalExceptionWrapper {
        if (!this._connection.sendRequest(out, this._compress, this._response) || this._response) {
            return this._connection;
        }
        return null;
    }

    @Override
    public boolean sendAsyncRequest(OutgoingAsync out) throws LocalExceptionWrapper {
        return this._connection.sendAsyncRequest(out, this._compress, this._response);
    }

    @Override
    public boolean flushBatchRequests(BatchOutgoing out) {
        return this._connection.flushBatchRequests(out);
    }

    @Override
    public boolean flushAsyncBatchRequests(BatchOutgoingAsync out) {
        return this._connection.flushAsyncBatchRequests(out);
    }

    @Override
    public Outgoing getOutgoing(String operation, OperationMode mode, Map<String, String> context) throws LocalExceptionWrapper {
        return this._connection.getOutgoing(this, operation, mode, context);
    }

    @Override
    public void reclaimOutgoing(Outgoing out) {
        this._connection.reclaimOutgoing(out);
    }

    @Override
    public Reference getReference() {
        return this._reference;
    }

    @Override
    public ConnectionI getConnection(boolean wait) {
        return this._connection;
    }

    public ConnectionRequestHandler(Reference ref, ObjectPrx proxy) {
        this._reference = ref;
        this._response = this._reference.getMode() == 0;
        BooleanHolder compress = new BooleanHolder();
        this._connection = this._reference.getConnection(compress);
        this._compress = compress.value;
        RouterInfo ri = this._reference.getRouterInfo();
        if (ri != null) {
            ri.addProxy(proxy);
        }
    }

    public ConnectionRequestHandler(Reference ref, ConnectionI connection, boolean compress) {
        this._reference = ref;
        this._response = this._reference.getMode() == 0;
        this._connection = connection;
        this._compress = compress;
    }
}

