/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedList {
    private Entry _header = new Entry(null, null, null);
    private int _size = 0;

    public LinkedList() {
        this._header.next = this._header.previous = this._header;
    }

    public Object getFirst() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._header.next.element;
    }

    public Object getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._header.previous.element;
    }

    public void addFirst(Object o) {
        this.addBefore(o, this._header.next);
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public Iterator iterator() {
        return new ForwardIterator();
    }

    public Iterator riterator() {
        return new ReverseIterator();
    }

    private Entry addBefore(Object o, Entry e) {
        Entry newEntry;
        newEntry.previous.next = newEntry = new Entry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this._size;
        return newEntry;
    }

    private void remove(Entry e) {
        if (e == this._header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this._size;
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }

    private class ReverseIterator
    implements Iterator {
        private Entry _current;
        private Entry _next;

        public boolean hasNext() {
            return this._next != null;
        }

        public Object next() {
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next.previous != LinkedList.this._header ? this._next.previous : null;
            return this._current.element;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            LinkedList.this.remove(this._current);
            this._current = null;
        }

        ReverseIterator() {
            this._next = ((LinkedList)LinkedList.this)._header.next == LinkedList.this._header ? null : ((LinkedList)LinkedList.this)._header.previous;
            this._current = null;
        }
    }

    private class ForwardIterator
    implements Iterator {
        private Entry _current;
        private Entry _next;

        public boolean hasNext() {
            return this._next != null;
        }

        public Object next() {
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next.next != LinkedList.this._header ? this._next.next : null;
            return this._current.element;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            LinkedList.this.remove(this._current);
            this._current = null;
        }

        ForwardIterator() {
            this._next = ((LinkedList)LinkedList.this)._header.next == LinkedList.this._header ? null : ((LinkedList)LinkedList.this)._header.next;
            this._current = null;
        }
    }
}

