/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

public final class SmartStringArray {
    private int sp = 0;
    private String[] array;
    private final int growthSize;
    private static final int START = 64;

    private SmartStringArray() {
        this(64);
    }

    private SmartStringArray(int initialSize) {
        this(initialSize, initialSize / 4);
    }

    private SmartStringArray(int initialSize, int growthSize) {
        this.growthSize = growthSize;
        this.array = new String[initialSize];
    }

    private void add(String str) {
        if (this.sp >= this.array.length) {
            String[] tmpArray = new String[this.array.length + this.growthSize];
            System.arraycopy(this.array, 0, tmpArray, 0, this.array.length);
            this.array = tmpArray;
        }
        this.array[this.sp] = str;
        ++this.sp;
    }

    private String[] toArray() {
        String[] trimmedArray = new String[this.sp];
        System.arraycopy(this.array, 0, trimmedArray, 0, trimmedArray.length);
        return trimmedArray;
    }

    public static String[] split(String token, String string) {
        SmartStringArray ssa = new SmartStringArray();
        int previousLoc = 0;
        int loc = string.indexOf(token, previousLoc);
        if (loc == -1) {
            ssa.add(string);
            return ssa.toArray();
        }
        do {
            ssa.add(string.substring(previousLoc, loc));
        } while ((loc = string.indexOf(token, previousLoc = loc + token.length())) != -1 && previousLoc < string.length());
        ssa.add(string.substring(previousLoc));
        return ssa.toArray();
    }

    private static void printArr(String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            System.out.print(arr[i]);
            if (i == arr.length - 1) continue;
            System.out.print(" . ");
        }
        System.out.println();
    }

    public static void main(String[] argv) {
        String s1 = "aaa.bbb.ccc";
        String s2 = "aaa..";
        String s3 = "...";
        String token = ".";
        SmartStringArray.printArr(SmartStringArray.split(token, s1));
        SmartStringArray.printArr(SmartStringArray.split(token, s2));
        SmartStringArray.printArr(SmartStringArray.split(token, s3));
    }
}

