/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.HashMap;
import java.util.Iterator;
import uk.ac.ebi.ook.web.services.Query;
import uk.ac.ebi.ook.web.services.QueryServiceLocator;

public class QuickSoapTest {
    private static void getTermXrefs(String term, String ontology) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getTermXrefs(term, ontology);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key));
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getPrefixedTermsByName(String term) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getPrefixedTermsByName(term, false);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key));
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getTermsByName(String term, String ontName) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getTermsByName(term, ontName, false);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key));
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getTermRelations(String term, String ontName) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getTermRelations(term, ontName);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key));
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getTermsMetadata(String term, String ontName) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getTermMetadata(term, ontName);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key));
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getTermById(String termId, String ontology) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            System.out.println("Term-> " + qs.getTermById(termId, ontology));
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getOntologies() {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getOntologyNames();
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key));
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getAllChildren(String termId, String ontology, int distance, int[] relations) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            String trmName = qs.getTermById(termId, ontology);
            HashMap map = qs.getTermChildren(termId, ontology, distance, relations);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key) + " related to '" + trmName + "'");
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getTermParents(String termId, String ontology) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getTermParents(termId, ontology);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key) + " parent of '" + termId + "'");
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getOntologyTerms(String ontology) {
        try {
            long currTime = System.currentTimeMillis();
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            HashMap map = qs.getAllTermsFromOntology(ontology);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                System.out.println(key + " -> " + map.get(key));
            }
            currTime = System.currentTimeMillis() - currTime;
            System.out.println("Execution took: " + currTime / 1000L + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        QueryServiceLocator locator = new QueryServiceLocator();
        System.out.println(locator.getOntologyQueryAddress());
        System.out.println("-------------------------------- term relations ");
        QuickSoapTest.getTermRelations("185752", "NEWT");
    }
}

