/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import loci.formats.ome.AbstractOMEXMLMetadata;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Arc;
import ome.xml.model.BinData;
import ome.xml.model.BinaryFile;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.Channel;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.Contact;
import ome.xml.model.Dataset;
import ome.xml.model.DatasetRef;
import ome.xml.model.Detector;
import ome.xml.model.DetectorSettings;
import ome.xml.model.Dichroic;
import ome.xml.model.DichroicRef;
import ome.xml.model.DoubleAnnotation;
import ome.xml.model.Ellipse;
import ome.xml.model.EmissionFilterRef;
import ome.xml.model.ExcitationFilterRef;
import ome.xml.model.Experiment;
import ome.xml.model.ExperimentRef;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Filament;
import ome.xml.model.FileAnnotation;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.FilterSetRef;
import ome.xml.model.Group;
import ome.xml.model.GroupRef;
import ome.xml.model.Image;
import ome.xml.model.ImageRef;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.Instrument;
import ome.xml.model.InstrumentRef;
import ome.xml.model.Laser;
import ome.xml.model.Leader;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightPath;
import ome.xml.model.LightSource;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.Line;
import ome.xml.model.ListAnnotation;
import ome.xml.model.LongAnnotation;
import ome.xml.model.Mask;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.MicrobeamManipulationRef;
import ome.xml.model.Microscope;
import ome.xml.model.OME;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.OMEModelObject;
import ome.xml.model.OTF;
import ome.xml.model.OTFRef;
import ome.xml.model.Objective;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Path;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.PlateRef;
import ome.xml.model.Point;
import ome.xml.model.Polyline;
import ome.xml.model.Project;
import ome.xml.model.ProjectRef;
import ome.xml.model.Pump;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reagent;
import ome.xml.model.ReagentRef;
import ome.xml.model.Rectangle;
import ome.xml.model.Reference;
import ome.xml.model.Screen;
import ome.xml.model.ScreenRef;
import ome.xml.model.Shape;
import ome.xml.model.StageLabel;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TagAnnotation;
import ome.xml.model.TermAnnotation;
import ome.xml.model.Text;
import ome.xml.model.TiffData;
import ome.xml.model.TimestampAnnotation;
import ome.xml.model.TransmittanceRange;
import ome.xml.model.UUID;
import ome.xml.model.Union;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.WellSampleRef;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;

public class OMEXMLMetadataImpl
extends AbstractOMEXMLMetadata {
    private OME root;
    private OMEModel model;

    public OMEXMLMetadataImpl() {
        this.createRoot();
    }

    public void createRoot() {
        this.root = new OME();
        this.model = new OMEModelImpl();
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        if (!(root instanceof OME)) {
            throw new IllegalArgumentException("Expecting OME class or subclass.");
        }
        this.root = (OME)root;
        this.model = new OMEModelImpl();
    }

    public String dumpXML() {
        this.resolveReferences();
        return super.dumpXML();
    }

    public int resolveReferences() {
        return this.model.resolveReferences();
    }

    public int getPixelsBinDataCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfBinDataList();
    }

    public String getLightSourceType(int instrumentIndex, int lightSourceIndex) {
        LightSource o = this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        String className = o.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    public int getROIAnnotationRefCount(int ROIIndex) {
        return this.root.getROI(ROIIndex).sizeOfLinkedAnnotationList();
    }

    public int getPlateAcquisitionAnnotationRefCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedAnnotationList();
    }

    public int getPlateAnnotationRefCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfLinkedAnnotationList();
    }

    public int getImageAnnotationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedAnnotationList();
    }

    public int getScreenAnnotationRefCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfLinkedAnnotationList();
    }

    public int getWellAnnotationRefCount(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).sizeOfLinkedAnnotationList();
    }

    public int getDatasetAnnotationRefCount(int datasetIndex) {
        return this.root.getDataset(datasetIndex).sizeOfLinkedAnnotationList();
    }

    public int getProjectAnnotationRefCount(int projectIndex) {
        return this.root.getProject(projectIndex).sizeOfLinkedAnnotationList();
    }

    public int getReagentAnnotationRefCount(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).sizeOfLinkedAnnotationList();
    }

    public int getPlaneAnnotationRefCount(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).sizeOfLinkedAnnotationList();
    }

    public int getExperimenterAnnotationRefCount(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).sizeOfLinkedAnnotationList();
    }

    public int getWellSampleAnnotationRefCount(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).sizeOfLinkedAnnotationList();
    }

    public int getPixelsAnnotationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfLinkedAnnotationList();
    }

    public int getChannelAnnotationRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).sizeOfLinkedAnnotationList();
    }

    public int getBooleanAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfBooleanAnnotationList();
    }

    public int getChannelCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfChannelList();
    }

    public int getCommentAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfCommentAnnotationList();
    }

    public int getDatasetCount() {
        return this.root.sizeOfDatasetList();
    }

    public int getDatasetRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedDatasetList();
    }

    public int getDetectorCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfDetectorList();
    }

    public int getDichroicCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfDichroicList();
    }

    public int getDoubleAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfDoubleAnnotationList();
    }

    public int getLightPathEmissionFilterRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedEmissionFilterList();
    }

    public int getFilterSetEmissionFilterRefCount(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedEmissionFilterList();
    }

    public int getLightPathExcitationFilterRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedExcitationFilterList();
    }

    public int getFilterSetExcitationFilterRefCount(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedExcitationFilterList();
    }

    public int getExperimentCount() {
        return this.root.sizeOfExperimentList();
    }

    public int getExperimenterCount() {
        return this.root.sizeOfExperimenterList();
    }

    public int getFileAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfFileAnnotationList();
    }

    public int getFilterCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfFilterList();
    }

    public int getFilterSetCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfFilterSetList();
    }

    public int getGroupCount() {
        return this.root.sizeOfGroupList();
    }

    public int getExperimenterGroupRefCount(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).sizeOfLinkedGroupList();
    }

    public int getImageCount() {
        return this.root.sizeOfImageList();
    }

    public int getInstrumentCount() {
        return this.root.sizeOfInstrumentList();
    }

    public int getLightSourceCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfLightSourceList();
    }

    public int getMicrobeamManipulationLightSourceSettingsCount(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLightSourceSettingsList();
    }

    public int getListAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfListAnnotationList();
    }

    public int getLongAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfLongAnnotationList();
    }

    public int getMicrobeamManipulationCount(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).sizeOfMicrobeamManipulationList();
    }

    public int getMicrobeamManipulationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedMicrobeamManipulationList();
    }

    public int getOTFCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfOTFList();
    }

    public int getObjectiveCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfObjectiveList();
    }

    public int getPlaneCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfPlaneList();
    }

    public int getPlateCount() {
        return this.root.sizeOfPlateList();
    }

    public int getPlateAcquisitionCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfPlateAcquisitionList();
    }

    public int getPlateRefCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfLinkedPlateList();
    }

    public int getProjectCount() {
        return this.root.sizeOfProjectList();
    }

    public int getProjectRefCount(int datasetIndex) {
        return this.root.getDataset(datasetIndex).sizeOfLinkedProjectList();
    }

    public int getROICount() {
        return this.root.sizeOfROIList();
    }

    public int getImageROIRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedROIList();
    }

    public int getMicrobeamManipulationROIRefCount(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLinkedROIList();
    }

    public int getReagentCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfReagentList();
    }

    public int getScreenCount() {
        return this.root.sizeOfScreenList();
    }

    public int getScreenRefCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfLinkedScreenList();
    }

    public int getShapeCount(int ROIIndex) {
        return this.root.getROI(ROIIndex).getUnion().sizeOfShapeList();
    }

    public int getTagAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTagAnnotationList();
    }

    public int getTermAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTermAnnotationList();
    }

    public int getTiffDataCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfTiffDataList();
    }

    public int getTimestampAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTimestampAnnotationList();
    }

    public void setUUIDValue(String value, int imageIndex, int tiffDataIndex) {
        TiffData o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        if ((o3 = o2.getTiffData(tiffDataIndex)).getUUID() == null) {
            o3.setUUID(new UUID());
        }
        UUID o4 = o3.getUUID();
        o4.setValue(value);
    }

    public String getUUIDValue(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getValue();
    }

    public int getWellCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfWellList();
    }

    public int getWellSampleCount(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).sizeOfWellSampleList();
    }

    public int getWellSampleRefCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedWellSampleList();
    }

    public int getXMLAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfXMLAnnotationList();
    }

    public Boolean getPixelsBinDataBigEndian(int imageIndex, int binDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getBinData(binDataIndex).getBigEndian();
    }

    public String getUUID() {
        return this.root.getUUID();
    }

    public String getArcID(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getArcLotNumber(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getArcManufacturer(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getArcModel(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getArcPower(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getArcSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public ArcType getArcType(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    public String getFileAnnotationBinaryFileFileName(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getFileName();
    }

    public String getOTFBinaryFileFileName(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getBinaryFile().getFileName();
    }

    public String getFileAnnotationBinaryFileMIMEType(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getMIMEType();
    }

    public String getOTFBinaryFileMIMEType(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getBinaryFile().getMIMEType();
    }

    public NonNegativeLong getFileAnnotationBinaryFileSize(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getSize();
    }

    public NonNegativeLong getOTFBinaryFileSize(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getBinaryFile().getSize();
    }

    public String getBooleanAnnotationAnnotationRef(int booleanAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getBooleanAnnotationDescription(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getDescription();
    }

    public String getBooleanAnnotationID(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getID();
    }

    public String getBooleanAnnotationNamespace(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getNamespace();
    }

    public Boolean getBooleanAnnotationValue(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getValue();
    }

    public AcquisitionMode getChannelAcquisitionMode(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getAcquisitionMode();
    }

    public String getChannelAnnotationRef(int imageIndex, int channelIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public Integer getChannelColor(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getColor();
    }

    public ContrastMethod getChannelContrastMethod(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getContrastMethod();
    }

    public PositiveInteger getChannelEmissionWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getEmissionWavelength();
    }

    public PositiveInteger getChannelExcitationWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getExcitationWavelength();
    }

    public String getChannelFilterSetRef(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedFilterSet().getID();
    }

    public String getChannelFluor(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getFluor();
    }

    public String getChannelID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getID();
    }

    public IlluminationType getChannelIlluminationType(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getIlluminationType();
    }

    public Double getChannelNDFilter(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getNDFilter();
    }

    public String getChannelName(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getName();
    }

    public String getChannelOTFRef(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedOTF().getID();
    }

    public Double getChannelPinholeSize(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPinholeSize();
    }

    public Integer getChannelPockelCellSetting(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPockelCellSetting();
    }

    public PositiveInteger getChannelSamplesPerPixel(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getSamplesPerPixel();
    }

    public String getCommentAnnotationAnnotationRef(int commentAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getCommentAnnotationDescription(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getDescription();
    }

    public String getCommentAnnotationID(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getID();
    }

    public String getCommentAnnotationNamespace(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getNamespace();
    }

    public String getCommentAnnotationValue(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getValue();
    }

    public String getDatasetAnnotationRef(int datasetIndex, int annotationRefIndex) {
        return this.root.getDataset(datasetIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getDatasetDescription(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getDescription();
    }

    public String getDatasetExperimenterRef(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getLinkedExperimenter().getID();
    }

    public String getDatasetGroupRef(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getLinkedGroup().getID();
    }

    public String getDatasetID(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getID();
    }

    public String getDatasetName(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getName();
    }

    public String getDatasetProjectRef(int datasetIndex, int projectRefIndex) {
        return this.root.getDataset(datasetIndex).getLinkedProject(projectRefIndex).getID();
    }

    public Double getDetectorAmplificationGain(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getAmplificationGain();
    }

    public Double getDetectorGain(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getGain();
    }

    public String getDetectorID(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getID();
    }

    public String getDetectorLotNumber(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getLotNumber();
    }

    public String getDetectorManufacturer(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getManufacturer();
    }

    public String getDetectorModel(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getModel();
    }

    public Double getDetectorOffset(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getOffset();
    }

    public String getDetectorSerialNumber(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getSerialNumber();
    }

    public DetectorType getDetectorType(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getType();
    }

    public Double getDetectorVoltage(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getVoltage();
    }

    public Double getDetectorZoom(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getZoom();
    }

    public Binning getDetectorSettingsBinning(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getBinning();
    }

    public Double getDetectorSettingsGain(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getGain();
    }

    public String getDetectorSettingsID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getID();
    }

    public Double getDetectorSettingsOffset(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getOffset();
    }

    public Double getDetectorSettingsReadOutRate(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getReadOutRate();
    }

    public Double getDetectorSettingsVoltage(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getVoltage();
    }

    public String getDichroicID(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getID();
    }

    public String getDichroicLotNumber(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getLotNumber();
    }

    public String getDichroicManufacturer(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getManufacturer();
    }

    public String getDichroicModel(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getModel();
    }

    public String getDichroicSerialNumber(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getSerialNumber();
    }

    public String getDoubleAnnotationAnnotationRef(int doubleAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getDoubleAnnotationDescription(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getDescription();
    }

    public String getDoubleAnnotationID(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getID();
    }

    public String getDoubleAnnotationNamespace(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getNamespace();
    }

    public Double getDoubleAnnotationValue(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getValue();
    }

    public String getEllipseDescription(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getEllipseFill(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getEllipseFontSize(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getEllipseID(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getEllipseLabel(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getEllipseName(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getEllipseStroke(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getEllipseStrokeDashArray(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getEllipseStrokeWidth(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getEllipseTheC(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getEllipseTheT(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getEllipseTheZ(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getEllipseTransform(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Double getEllipseRadiusX(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getRadiusX();
    }

    public Double getEllipseRadiusY(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getRadiusY();
    }

    public Double getEllipseX(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getEllipseY(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getExperimentDescription(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getDescription();
    }

    public String getExperimentExperimenterRef(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getLinkedExperimenter().getID();
    }

    public String getExperimentID(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getID();
    }

    public ExperimentType getExperimentType(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getType();
    }

    public String getExperimenterAnnotationRef(int experimenterIndex, int annotationRefIndex) {
        return this.root.getExperimenter(experimenterIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getExperimenterDisplayName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getDisplayName();
    }

    public String getExperimenterEmail(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getEmail();
    }

    public String getExperimenterFirstName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getFirstName();
    }

    public String getExperimenterGroupRef(int experimenterIndex, int groupRefIndex) {
        return this.root.getExperimenter(experimenterIndex).getLinkedGroup(groupRefIndex).getID();
    }

    public String getExperimenterID(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getID();
    }

    public String getExperimenterInstitution(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getInstitution();
    }

    public String getExperimenterLastName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getLastName();
    }

    public String getExperimenterMiddleName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getMiddleName();
    }

    public String getExperimenterUserName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getUserName();
    }

    public String getFilamentID(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getFilamentLotNumber(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getFilamentManufacturer(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getFilamentModel(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getFilamentPower(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getFilamentSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public FilamentType getFilamentType(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    public String getFileAnnotationAnnotationRef(int fileAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getFileAnnotationDescription(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getDescription();
    }

    public String getFileAnnotationID(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getID();
    }

    public String getFileAnnotationNamespace(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getNamespace();
    }

    public String getFilterFilterWheel(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getFilterWheel();
    }

    public String getFilterID(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getID();
    }

    public String getFilterLotNumber(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getLotNumber();
    }

    public String getFilterManufacturer(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getManufacturer();
    }

    public String getFilterModel(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getModel();
    }

    public String getFilterSerialNumber(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getSerialNumber();
    }

    public FilterType getFilterType(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getType();
    }

    public String getFilterSetDichroicRef(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedDichroic().getID();
    }

    public String getFilterSetEmissionFilterRef(int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedEmissionFilter(emissionFilterRefIndex).getID();
    }

    public String getFilterSetExcitationFilterRef(int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedExcitationFilter(excitationFilterRefIndex).getID();
    }

    public String getFilterSetID(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getID();
    }

    public String getFilterSetLotNumber(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLotNumber();
    }

    public String getFilterSetManufacturer(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getManufacturer();
    }

    public String getFilterSetModel(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getModel();
    }

    public String getFilterSetSerialNumber(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getSerialNumber();
    }

    public String getGroupContact(int groupIndex) {
        return this.root.getGroup(groupIndex).getLinkedContact().getID();
    }

    public String getGroupDescription(int groupIndex) {
        return this.root.getGroup(groupIndex).getDescription();
    }

    public String getGroupID(int groupIndex) {
        return this.root.getGroup(groupIndex).getID();
    }

    public String getGroupLeader(int groupIndex) {
        return this.root.getGroup(groupIndex).getLinkedLeader().getID();
    }

    public String getGroupName(int groupIndex) {
        return this.root.getGroup(groupIndex).getName();
    }

    public String getImageAcquiredDate(int imageIndex) {
        return this.root.getImage(imageIndex).getAcquiredDate();
    }

    public String getImageAnnotationRef(int imageIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getImageDatasetRef(int imageIndex, int datasetRefIndex) {
        return this.root.getImage(imageIndex).getLinkedDataset(datasetRefIndex).getID();
    }

    public String getImageDescription(int imageIndex) {
        return this.root.getImage(imageIndex).getDescription();
    }

    public String getImageExperimentRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperiment().getID();
    }

    public String getImageExperimenterRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperimenter().getID();
    }

    public String getImageGroupRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedGroup().getID();
    }

    public String getImageID(int imageIndex) {
        return this.root.getImage(imageIndex).getID();
    }

    public String getImageInstrumentRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedInstrument().getID();
    }

    public String getImageMicrobeamManipulationRef(int imageIndex, int microbeamManipulationRefIndex) {
        return this.root.getImage(imageIndex).getLinkedMicrobeamManipulation(microbeamManipulationRefIndex).getID();
    }

    public String getImageName(int imageIndex) {
        return this.root.getImage(imageIndex).getName();
    }

    public String getImageROIRef(int imageIndex, int ROIRefIndex) {
        return this.root.getImage(imageIndex).getLinkedROI(ROIRefIndex).getID();
    }

    public Double getImagingEnvironmentAirPressure(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getAirPressure();
    }

    public PercentFraction getImagingEnvironmentCO2Percent(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getCO2Percent();
    }

    public PercentFraction getImagingEnvironmentHumidity(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getHumidity();
    }

    public Double getImagingEnvironmentTemperature(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getTemperature();
    }

    public String getInstrumentID(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getID();
    }

    public String getLaserID(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getLaserLotNumber(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getLaserManufacturer(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getLaserModel(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getLaserPower(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getLaserSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public PositiveInteger getLaserFrequencyMultiplication(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getFrequencyMultiplication();
    }

    public LaserMedium getLaserLaserMedium(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLaserMedium();
    }

    public Boolean getLaserPockelCell(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPockelCell();
    }

    public Pulse getLaserPulse(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPulse();
    }

    public String getLaserPump(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedPump().getID();
    }

    public Double getLaserRepetitionRate(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getRepetitionRate();
    }

    public Boolean getLaserTuneable(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getTuneable();
    }

    public LaserType getLaserType(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    public PositiveInteger getLaserWavelength(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getWavelength();
    }

    public String getLightEmittingDiodeID(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getLightEmittingDiodeLotNumber(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getLightEmittingDiodeManufacturer(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getLightEmittingDiodeModel(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getLightEmittingDiodePower(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getLightEmittingDiodeSerialNumber(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public String getLightPathDichroicRef(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedDichroic().getID();
    }

    public String getLightPathEmissionFilterRef(int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedEmissionFilter(emissionFilterRefIndex).getID();
    }

    public String getLightPathExcitationFilterRef(int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedExcitationFilter(excitationFilterRefIndex).getID();
    }

    public PercentFraction getChannelLightSourceSettingsAttenuation(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getAttenuation();
    }

    public PercentFraction getMicrobeamManipulationLightSourceSettingsAttenuation(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getAttenuation();
    }

    public String getChannelLightSourceSettingsID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getID();
    }

    public String getMicrobeamManipulationLightSourceSettingsID(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getID();
    }

    public PositiveInteger getChannelLightSourceSettingsWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getWavelength();
    }

    public PositiveInteger getMicrobeamManipulationLightSourceSettingsWavelength(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getWavelength();
    }

    public String getLineDescription(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getLineFill(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getLineFontSize(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getLineID(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getLineLabel(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getLineName(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getLineStroke(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getLineStrokeDashArray(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getLineStrokeWidth(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getLineTheC(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getLineTheT(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getLineTheZ(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getLineTransform(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Double getLineX1(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX1();
    }

    public Double getLineX2(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX2();
    }

    public Double getLineY1(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY1();
    }

    public Double getLineY2(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY2();
    }

    public String getListAnnotationAnnotationRef(int listAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getListAnnotationDescription(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getDescription();
    }

    public String getListAnnotationID(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getID();
    }

    public String getListAnnotationNamespace(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getNamespace();
    }

    public String getLongAnnotationAnnotationRef(int longAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getLongAnnotationDescription(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getDescription();
    }

    public String getLongAnnotationID(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getID();
    }

    public String getLongAnnotationNamespace(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getNamespace();
    }

    public Long getLongAnnotationValue(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getValue();
    }

    public String getMaskDescription(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getMaskFill(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getMaskFontSize(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getMaskID(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getMaskLabel(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getMaskName(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getMaskStroke(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getMaskStrokeDashArray(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getMaskStrokeWidth(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getMaskTheC(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getMaskTheT(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getMaskTheZ(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getMaskTransform(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Double getMaskHeight(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getHeight();
    }

    public Double getMaskWidth(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getWidth();
    }

    public Double getMaskX(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getMaskY(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getMicrobeamManipulationExperimenterRef(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedExperimenter().getID();
    }

    public String getMicrobeamManipulationID(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getID();
    }

    public String getMicrobeamManipulationROIRef(int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedROI(ROIRefIndex).getID();
    }

    public MicrobeamManipulationType getMicrobeamManipulationType(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getType();
    }

    public String getMicroscopeLotNumber(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getLotNumber();
    }

    public String getMicroscopeManufacturer(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getManufacturer();
    }

    public String getMicroscopeModel(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getModel();
    }

    public String getMicroscopeSerialNumber(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getSerialNumber();
    }

    public MicroscopeType getMicroscopeType(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getType();
    }

    public String getOTFFilterSetRef(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getLinkedFilterSet().getID();
    }

    public String getOTFID(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getID();
    }

    public Boolean getOTFOpticalAxisAveraged(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getOpticalAxisAveraged();
    }

    public PositiveInteger getOTFSizeX(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getSizeX();
    }

    public PositiveInteger getOTFSizeY(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getSizeY();
    }

    public PixelType getOTFType(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getType();
    }

    public Double getObjectiveCalibratedMagnification(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCalibratedMagnification();
    }

    public Correction getObjectiveCorrection(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCorrection();
    }

    public String getObjectiveID(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getID();
    }

    public Immersion getObjectiveImmersion(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getImmersion();
    }

    public Boolean getObjectiveIris(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getIris();
    }

    public Double getObjectiveLensNA(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLensNA();
    }

    public String getObjectiveLotNumber(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLotNumber();
    }

    public String getObjectiveManufacturer(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getManufacturer();
    }

    public String getObjectiveModel(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getModel();
    }

    public PositiveInteger getObjectiveNominalMagnification(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getNominalMagnification();
    }

    public String getObjectiveSerialNumber(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getSerialNumber();
    }

    public Double getObjectiveWorkingDistance(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getWorkingDistance();
    }

    public Double getImageObjectiveSettingsCorrectionCollar(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getCorrectionCollar();
    }

    public Double getOTFObjectiveSettingsCorrectionCollar(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getObjectiveSettings().getCorrectionCollar();
    }

    public String getImageObjectiveSettingsID(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getID();
    }

    public String getOTFObjectiveSettingsID(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getObjectiveSettings().getID();
    }

    public Medium getImageObjectiveSettingsMedium(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getMedium();
    }

    public Medium getOTFObjectiveSettingsMedium(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getObjectiveSettings().getMedium();
    }

    public Double getImageObjectiveSettingsRefractiveIndex(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getRefractiveIndex();
    }

    public Double getOTFObjectiveSettingsRefractiveIndex(int instrumentIndex, int OTFIndex) {
        return this.root.getInstrument(instrumentIndex).getOTF(OTFIndex).getObjectiveSettings().getRefractiveIndex();
    }

    public String getPathDescription(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getPathFill(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getPathFontSize(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getPathID(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getPathLabel(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getPathName(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getPathStroke(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getPathStrokeDashArray(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getPathStrokeWidth(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getPathTheC(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getPathTheT(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getPathTheZ(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getPathTransform(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public String getPathDefinition(int ROIIndex, int shapeIndex) {
        Path o = (Path)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDefinition();
    }

    public String getPixelsAnnotationRef(int imageIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getLinkedAnnotation(annotationRefIndex).getID();
    }

    public DimensionOrder getPixelsDimensionOrder(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getDimensionOrder();
    }

    public String getPixelsID(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getID();
    }

    public Double getPixelsPhysicalSizeX(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeX();
    }

    public Double getPixelsPhysicalSizeY(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeY();
    }

    public Double getPixelsPhysicalSizeZ(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeZ();
    }

    public PositiveInteger getPixelsSizeC(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeC();
    }

    public PositiveInteger getPixelsSizeT(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeT();
    }

    public PositiveInteger getPixelsSizeX(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeX();
    }

    public PositiveInteger getPixelsSizeY(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeY();
    }

    public PositiveInteger getPixelsSizeZ(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeZ();
    }

    public Double getPixelsTimeIncrement(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getTimeIncrement();
    }

    public PixelType getPixelsType(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getType();
    }

    public String getPlaneAnnotationRef(int imageIndex, int planeIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public Double getPlaneDeltaT(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getDeltaT();
    }

    public Double getPlaneExposureTime(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getExposureTime();
    }

    public String getPlaneHashSHA1(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getHashSHA1();
    }

    public Double getPlanePositionX(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionX();
    }

    public Double getPlanePositionY(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionY();
    }

    public Double getPlanePositionZ(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionZ();
    }

    public NonNegativeInteger getPlaneTheC(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheC();
    }

    public NonNegativeInteger getPlaneTheT(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheT();
    }

    public NonNegativeInteger getPlaneTheZ(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheZ();
    }

    public String getPlateAnnotationRef(int plateIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public NamingConvention getPlateColumnNamingConvention(int plateIndex) {
        return this.root.getPlate(plateIndex).getColumnNamingConvention();
    }

    public PositiveInteger getPlateColumns(int plateIndex) {
        return this.root.getPlate(plateIndex).getColumns();
    }

    public String getPlateDescription(int plateIndex) {
        return this.root.getPlate(plateIndex).getDescription();
    }

    public String getPlateExternalIdentifier(int plateIndex) {
        return this.root.getPlate(plateIndex).getExternalIdentifier();
    }

    public String getPlateID(int plateIndex) {
        return this.root.getPlate(plateIndex).getID();
    }

    public String getPlateName(int plateIndex) {
        return this.root.getPlate(plateIndex).getName();
    }

    public NamingConvention getPlateRowNamingConvention(int plateIndex) {
        return this.root.getPlate(plateIndex).getRowNamingConvention();
    }

    public PositiveInteger getPlateRows(int plateIndex) {
        return this.root.getPlate(plateIndex).getRows();
    }

    public String getPlateScreenRef(int plateIndex, int screenRefIndex) {
        return this.root.getPlate(plateIndex).getLinkedScreen(screenRefIndex).getID();
    }

    public String getPlateStatus(int plateIndex) {
        return this.root.getPlate(plateIndex).getStatus();
    }

    public Double getPlateWellOriginX(int plateIndex) {
        return this.root.getPlate(plateIndex).getWellOriginX();
    }

    public Double getPlateWellOriginY(int plateIndex) {
        return this.root.getPlate(plateIndex).getWellOriginY();
    }

    public String getPlateAcquisitionAnnotationRef(int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getPlateAcquisitionDescription(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getDescription();
    }

    public String getPlateAcquisitionEndTime(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getEndTime();
    }

    public String getPlateAcquisitionID(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getID();
    }

    public PositiveInteger getPlateAcquisitionMaximumFieldCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getMaximumFieldCount();
    }

    public String getPlateAcquisitionName(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getName();
    }

    public String getPlateAcquisitionStartTime(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getStartTime();
    }

    public String getPlateAcquisitionWellSampleRef(int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedWellSample(wellSampleRefIndex).getID();
    }

    public String getPointDescription(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getPointFill(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getPointFontSize(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getPointID(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getPointLabel(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getPointName(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getPointStroke(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getPointStrokeDashArray(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getPointStrokeWidth(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getPointTheC(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getPointTheT(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getPointTheZ(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getPointTransform(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Double getPointX(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getPointY(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getPolylineDescription(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getPolylineFill(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getPolylineFontSize(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getPolylineID(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getPolylineLabel(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getPolylineName(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getPolylineStroke(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getPolylineStrokeDashArray(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getPolylineStrokeWidth(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getPolylineTheC(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getPolylineTheT(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getPolylineTheZ(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getPolylineTransform(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getPolylineClosed(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getClosed();
    }

    public String getPolylinePoints(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getPoints();
    }

    public String getProjectAnnotationRef(int projectIndex, int annotationRefIndex) {
        return this.root.getProject(projectIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getProjectDescription(int projectIndex) {
        return this.root.getProject(projectIndex).getDescription();
    }

    public String getProjectExperimenterRef(int projectIndex) {
        return this.root.getProject(projectIndex).getLinkedExperimenter().getID();
    }

    public String getProjectGroupRef(int projectIndex) {
        return this.root.getProject(projectIndex).getLinkedGroup().getID();
    }

    public String getProjectID(int projectIndex) {
        return this.root.getProject(projectIndex).getID();
    }

    public String getProjectName(int projectIndex) {
        return this.root.getProject(projectIndex).getName();
    }

    public String getROIAnnotationRef(int ROIIndex, int annotationRefIndex) {
        return this.root.getROI(ROIIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getROIDescription(int ROIIndex) {
        return this.root.getROI(ROIIndex).getDescription();
    }

    public String getROIID(int ROIIndex) {
        return this.root.getROI(ROIIndex).getID();
    }

    public String getROIName(int ROIIndex) {
        return this.root.getROI(ROIIndex).getName();
    }

    public String getROINamespace(int ROIIndex) {
        return this.root.getROI(ROIIndex).getNamespace();
    }

    public String getReagentAnnotationRef(int screenIndex, int reagentIndex, int annotationRefIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getReagentDescription(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getDescription();
    }

    public String getReagentID(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getID();
    }

    public String getReagentName(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getName();
    }

    public String getReagentReagentIdentifier(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getReagentIdentifier();
    }

    public String getRectangleDescription(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getRectangleFill(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getRectangleFontSize(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getRectangleID(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getRectangleLabel(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getRectangleName(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getRectangleStroke(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getRectangleStrokeDashArray(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getRectangleStrokeWidth(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getRectangleTheC(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getRectangleTheT(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getRectangleTheZ(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getRectangleTransform(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Double getRectangleHeight(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getHeight();
    }

    public Double getRectangleWidth(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getWidth();
    }

    public Double getRectangleX(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getRectangleY(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getScreenAnnotationRef(int screenIndex, int annotationRefIndex) {
        return this.root.getScreen(screenIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getScreenDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getDescription();
    }

    public String getScreenID(int screenIndex) {
        return this.root.getScreen(screenIndex).getID();
    }

    public String getScreenName(int screenIndex) {
        return this.root.getScreen(screenIndex).getName();
    }

    public String getScreenPlateRef(int screenIndex, int plateRefIndex) {
        return this.root.getScreen(screenIndex).getLinkedPlate(plateRefIndex).getID();
    }

    public String getScreenProtocolDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getProtocolDescription();
    }

    public String getScreenProtocolIdentifier(int screenIndex) {
        return this.root.getScreen(screenIndex).getProtocolIdentifier();
    }

    public String getScreenReagentSetDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getReagentSetDescription();
    }

    public String getScreenReagentSetIdentifier(int screenIndex) {
        return this.root.getScreen(screenIndex).getReagentSetIdentifier();
    }

    public String getScreenType(int screenIndex) {
        return this.root.getScreen(screenIndex).getType();
    }

    public String getStageLabelName(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getName();
    }

    public Double getStageLabelX(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getX();
    }

    public Double getStageLabelY(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getY();
    }

    public Double getStageLabelZ(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getZ();
    }

    public String getTagAnnotationAnnotationRef(int tagAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getTagAnnotationDescription(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getDescription();
    }

    public String getTagAnnotationID(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getID();
    }

    public String getTagAnnotationNamespace(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getNamespace();
    }

    public String getTagAnnotationValue(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getValue();
    }

    public String getTermAnnotationAnnotationRef(int termAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getTermAnnotationDescription(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getDescription();
    }

    public String getTermAnnotationID(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getID();
    }

    public String getTermAnnotationNamespace(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getNamespace();
    }

    public String getTermAnnotationValue(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getValue();
    }

    public String getTextDescription(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getDescription();
    }

    public Integer getTextFill(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFill();
    }

    public NonNegativeInteger getTextFontSize(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public String getTextID(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public String getTextLabel(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLabel();
    }

    public String getTextName(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getName();
    }

    public Integer getTextStroke(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStroke();
    }

    public String getTextStrokeDashArray(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getTextStrokeWidth(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public NonNegativeInteger getTextTheC(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getTextTheT(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getTextTheZ(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public String getTextTransform(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public String getTextValue(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getValue();
    }

    public Double getTextX(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getTextY(int ROIIndex, int shapeIndex) {
        Text o = (Text)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public NonNegativeInteger getTiffDataFirstC(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstC();
    }

    public NonNegativeInteger getTiffDataFirstT(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstT();
    }

    public NonNegativeInteger getTiffDataFirstZ(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstZ();
    }

    public NonNegativeInteger getTiffDataIFD(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getIFD();
    }

    public NonNegativeInteger getTiffDataPlaneCount(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getPlaneCount();
    }

    public String getTimestampAnnotationAnnotationRef(int timestampAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getTimestampAnnotationDescription(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getDescription();
    }

    public String getTimestampAnnotationID(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getID();
    }

    public String getTimestampAnnotationNamespace(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getNamespace();
    }

    public String getTimestampAnnotationValue(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getValue();
    }

    public PositiveInteger getTransmittanceRangeCutIn(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutIn();
    }

    public NonNegativeInteger getTransmittanceRangeCutInTolerance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutInTolerance();
    }

    public PositiveInteger getTransmittanceRangeCutOut(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOut();
    }

    public NonNegativeInteger getTransmittanceRangeCutOutTolerance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOutTolerance();
    }

    public PercentFraction getTransmittanceRangeTransmittance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getTransmittance();
    }

    public String getUUIDFileName(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getFileName();
    }

    public String getWellAnnotationRef(int plateIndex, int wellIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public Integer getWellColor(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getColor();
    }

    public NonNegativeInteger getWellColumn(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getColumn();
    }

    public String getWellExternalDescription(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getExternalDescription();
    }

    public String getWellExternalIdentifier(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getExternalIdentifier();
    }

    public String getWellID(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getID();
    }

    public String getWellReagentRef(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getLinkedReagent().getID();
    }

    public NonNegativeInteger getWellRow(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getRow();
    }

    public String getWellStatus(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getStatus();
    }

    public String getWellSampleAnnotationRef(int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getWellSampleID(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getID();
    }

    public String getWellSampleImageRef(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getLinkedImage().getID();
    }

    public NonNegativeInteger getWellSampleIndex(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getIndex();
    }

    public Double getWellSamplePositionX(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionX();
    }

    public Double getWellSamplePositionY(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionY();
    }

    public String getWellSampleTimepoint(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getTimepoint();
    }

    public String getXMLAnnotationAnnotationRef(int XMLAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getXMLAnnotationDescription(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getDescription();
    }

    public String getXMLAnnotationID(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getID();
    }

    public String getXMLAnnotationNamespace(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getNamespace();
    }

    public String getXMLAnnotationValue(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getValue();
    }

    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfBinDataList() == binDataIndex) {
            o2.addBinData(new BinData());
        }
        BinData o3 = o2.getBinData(binDataIndex);
        o3.setBigEndian(bigEndian);
    }

    public void setMaskBinData(byte[] binData, int ROIIndex, int shapeIndex) {
    }

    public void setUUID(String uuid) {
        this.root.setUUID(uuid);
    }

    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        ((Arc)o2).setID(id);
    }

    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setLotNumber(lotNumber);
    }

    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setManufacturer(manufacturer);
    }

    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setModel(model);
    }

    public void setArcPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setPower(power);
    }

    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setSerialNumber(serialNumber);
    }

    public void setArcType(ArcType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setType(type);
    }

    public void setFileAnnotationBinaryFileFileName(String fileName, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setFileName(fileName);
    }

    public void setOTFBinaryFileFileName(String fileName, int instrumentIndex, int OTFIndex) {
        OTF o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        if ((o2 = o1.getOTF(OTFIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setFileName(fileName);
    }

    public void setFileAnnotationBinaryFileMIMEType(String mimetype, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setMIMEType(mimetype);
    }

    public void setOTFBinaryFileMIMEType(String mimetype, int instrumentIndex, int OTFIndex) {
        OTF o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        if ((o2 = o1.getOTF(OTFIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setMIMEType(mimetype);
    }

    public void setFileAnnotationBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setSize(size);
    }

    public void setOTFBinaryFileSize(NonNegativeLong size, int instrumentIndex, int OTFIndex) {
        OTF o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        if ((o2 = o1.getOTF(OTFIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setSize(size);
    }

    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setDescription(description);
    }

    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setValue(value);
    }

    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setAcquisitionMode(acquisitionMode);
    }

    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels().getChannel(channelIndex), (Reference)annotationList_reference);
    }

    public void setChannelColor(Integer color, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setColor(color);
    }

    public void setChannelContrastMethod(ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setContrastMethod(contrastMethod);
    }

    public void setChannelEmissionWavelength(PositiveInteger emissionWavelength, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setEmissionWavelength(emissionWavelength);
    }

    public void setChannelExcitationWavelength(PositiveInteger excitationWavelength, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setExcitationWavelength(excitationWavelength);
    }

    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        FilterSetRef filterSet_reference = new FilterSetRef();
        filterSet_reference.setID(filterSet);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels().getChannel(channelIndex), (Reference)filterSet_reference);
    }

    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setFluor(fluor);
    }

    public void setChannelID(String id, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        o3.setID(id);
        if (o3.getLightPath() == null) {
            o3.setLightPath(new LightPath());
        }
    }

    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setIlluminationType(illuminationType);
    }

    public void setChannelNDFilter(Double ndfilter, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setNDFilter(ndfilter);
    }

    public void setChannelName(String name, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setName(name);
    }

    public void setChannelOTFRef(String otf, int imageIndex, int channelIndex) {
        OTFRef otf_reference = new OTFRef();
        otf_reference.setID(otf);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels().getChannel(channelIndex), (Reference)otf_reference);
    }

    public void setChannelPinholeSize(Double pinholeSize, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setPinholeSize(pinholeSize);
    }

    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setPockelCellSetting(pockelCellSetting);
    }

    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setSamplesPerPixel(samplesPerPixel);
    }

    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setDescription(description);
    }

    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setValue(value);
    }

    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getDataset(datasetIndex), (Reference)annotationList_reference);
    }

    public void setDatasetDescription(String description, int datasetIndex) {
        OME o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        o1.setDescription(description);
    }

    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference((OMEModelObject)this.root.getDataset(datasetIndex), (Reference)experimenter_reference);
    }

    public void setDatasetGroupRef(String group, int datasetIndex) {
        GroupRef group_reference = new GroupRef();
        group_reference.setID(group);
        this.model.addReference((OMEModelObject)this.root.getDataset(datasetIndex), (Reference)group_reference);
    }

    public void setDatasetID(String id, int datasetIndex) {
        OME o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setDatasetName(String name, int datasetIndex) {
        OME o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        o1.setName(name);
    }

    public void setDatasetProjectRef(String project, int datasetIndex, int projectRefIndex) {
        ProjectRef projectList_reference = new ProjectRef();
        projectList_reference.setID(project);
        this.model.addReference((OMEModelObject)this.root.getDataset(datasetIndex), (Reference)projectList_reference);
    }

    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setAmplificationGain(amplificationGain);
    }

    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setGain(gain);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setModel(model);
    }

    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setOffset(offset);
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setType(type);
    }

    public void setDetectorVoltage(Double voltage, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setVoltage(voltage);
    }

    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setZoom(zoom);
    }

    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setBinning(binning);
    }

    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setGain(gain);
    }

    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        this.model.addModelObject(id, (OMEModelObject)o4);
        o4.setID(id);
    }

    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setOffset(offset);
    }

    public void setDetectorSettingsReadOutRate(Double readOutRate, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setReadOutRate(readOutRate);
    }

    public void setDetectorSettingsVoltage(Double voltage, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setVoltage(voltage);
    }

    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setModel(model);
    }

    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setDescription(description);
    }

    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setValue(value);
    }

    public void setEllipseDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setDescription(description);
    }

    public void setEllipseFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFill(fill);
    }

    public void setEllipseFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFontSize(fontSize);
    }

    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Ellipse)o3).setID(id);
    }

    public void setEllipseLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setLabel(label);
    }

    public void setEllipseName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setName(name);
    }

    public void setEllipseStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStroke(stroke);
    }

    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setEllipseStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeWidth(strokeWidth);
    }

    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheC(theC);
    }

    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheT(theT);
    }

    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheZ(theZ);
    }

    public void setEllipseTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTransform(transform);
    }

    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setRadiusX(radiusX);
    }

    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setRadiusY(radiusY);
    }

    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setX(x);
    }

    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setY(y);
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        o1.setDescription(description);
    }

    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference((OMEModelObject)this.root.getExperiment(experimentIndex), (Reference)experimenter_reference);
    }

    public void setExperimentID(String id, int experimentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setExperimentType(ExperimentType type, int experimentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        o1.setType(type);
    }

    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getExperimenter(experimenterIndex), (Reference)annotationList_reference);
    }

    public void setExperimenterDisplayName(String displayName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setDisplayName(displayName);
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setEmail(email);
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setFirstName(firstName);
    }

    public void setExperimenterGroupRef(String group, int experimenterIndex, int groupRefIndex) {
        GroupRef groupList_reference = new GroupRef();
        groupList_reference.setID(group);
        this.model.addReference((OMEModelObject)this.root.getExperimenter(experimenterIndex), (Reference)groupList_reference);
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setInstitution(institution);
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setLastName(lastName);
    }

    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setMiddleName(middleName);
    }

    public void setExperimenterUserName(String userName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setUserName(userName);
    }

    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        ((Filament)o2).setID(id);
    }

    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setLotNumber(lotNumber);
    }

    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setManufacturer(manufacturer);
    }

    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setModel(model);
    }

    public void setFilamentPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setPower(power);
    }

    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setSerialNumber(serialNumber);
    }

    public void setFilamentType(FilamentType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setType(type);
    }

    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        o2.setDescription(description);
    }

    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setFilterWheel(filterWheel);
    }

    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setModel(model);
    }

    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setType(type);
    }

    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        DichroicRef dichroic_reference = new DichroicRef();
        dichroic_reference.setID(dichroic);
        this.model.addReference((OMEModelObject)this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), (Reference)dichroic_reference);
    }

    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        EmissionFilterRef emissionFilterList_reference = new EmissionFilterRef();
        emissionFilterList_reference.setID(emissionFilter);
        this.model.addReference((OMEModelObject)this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), (Reference)emissionFilterList_reference);
    }

    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        ExcitationFilterRef excitationFilterList_reference = new ExcitationFilterRef();
        excitationFilterList_reference.setID(excitationFilter);
        this.model.addReference((OMEModelObject)this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), (Reference)excitationFilterList_reference);
    }

    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setModel(model);
    }

    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setGroupContact(String contact, int groupIndex) {
        Contact contact_reference = new Contact();
        contact_reference.setID(contact);
        this.model.addReference((OMEModelObject)this.root.getGroup(groupIndex), (Reference)contact_reference);
    }

    public void setGroupDescription(String description, int groupIndex) {
        OME o0 = this.root;
        if (o0.sizeOfGroupList() == groupIndex) {
            o0.addGroup(new Group());
        }
        Group o1 = o0.getGroup(groupIndex);
        o1.setDescription(description);
    }

    public void setGroupID(String id, int groupIndex) {
        OME o0 = this.root;
        if (o0.sizeOfGroupList() == groupIndex) {
            o0.addGroup(new Group());
        }
        Group o1 = o0.getGroup(groupIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setGroupLeader(String leader, int groupIndex) {
        Leader leader_reference = new Leader();
        leader_reference.setID(leader);
        this.model.addReference((OMEModelObject)this.root.getGroup(groupIndex), (Reference)leader_reference);
    }

    public void setGroupName(String name, int groupIndex) {
        OME o0 = this.root;
        if (o0.sizeOfGroupList() == groupIndex) {
            o0.addGroup(new Group());
        }
        Group o1 = o0.getGroup(groupIndex);
        o1.setName(name);
    }

    public void setImageAcquiredDate(String acquiredDate, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setAcquiredDate(acquiredDate);
    }

    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)annotationList_reference);
    }

    public void setImageDatasetRef(String dataset, int imageIndex, int datasetRefIndex) {
        DatasetRef datasetList_reference = new DatasetRef();
        datasetList_reference.setID(dataset);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)datasetList_reference);
    }

    public void setImageDescription(String description, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setDescription(description);
    }

    public void setImageExperimentRef(String experiment, int imageIndex) {
        ExperimentRef experiment_reference = new ExperimentRef();
        experiment_reference.setID(experiment);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)experiment_reference);
    }

    public void setImageExperimenterRef(String experimenter, int imageIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)experimenter_reference);
    }

    public void setImageGroupRef(String group, int imageIndex) {
        GroupRef group_reference = new GroupRef();
        group_reference.setID(group);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)group_reference);
    }

    public void setImageID(String id, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setImageInstrumentRef(String instrument, int imageIndex) {
        InstrumentRef instrument_reference = new InstrumentRef();
        instrument_reference.setID(instrument);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)instrument_reference);
    }

    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        MicrobeamManipulationRef microbeamManipulationList_reference = new MicrobeamManipulationRef();
        microbeamManipulationList_reference.setID(microbeamManipulation);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)microbeamManipulationList_reference);
    }

    public void setImageName(String name, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setName(name);
    }

    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        ROIRef roiList_reference = new ROIRef();
        roiList_reference.setID(roi);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex), (Reference)roiList_reference);
    }

    public void setImagingEnvironmentAirPressure(Double airPressure, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setAirPressure(airPressure);
    }

    public void setImagingEnvironmentCO2Percent(PercentFraction co2percent, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setCO2Percent(co2percent);
    }

    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setHumidity(humidity);
    }

    public void setImagingEnvironmentTemperature(Double temperature, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setTemperature(temperature);
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        Instrument o1 = o0.getInstrument(instrumentIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        ((Laser)o2).setID(id);
    }

    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setLotNumber(lotNumber);
    }

    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setManufacturer(manufacturer);
    }

    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setModel(model);
    }

    public void setLaserPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPower(power);
    }

    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setSerialNumber(serialNumber);
    }

    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setFrequencyMultiplication(frequencyMultiplication);
    }

    public void setLaserLaserMedium(LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setLaserMedium(laserMedium);
    }

    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPockelCell(pockelCell);
    }

    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPulse(pulse);
    }

    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        Pump pump_reference = new Pump();
        pump_reference.setID(pump);
        this.model.addReference((OMEModelObject)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), (Reference)pump_reference);
    }

    public void setLaserRepetitionRate(Double repetitionRate, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setRepetitionRate(repetitionRate);
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setTuneable(tuneable);
    }

    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setType(type);
    }

    public void setLaserWavelength(PositiveInteger wavelength, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setWavelength(wavelength);
    }

    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        ((LightEmittingDiode)o2).setID(id);
    }

    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setLotNumber(lotNumber);
    }

    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setManufacturer(manufacturer);
    }

    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setModel(model);
    }

    public void setLightEmittingDiodePower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setPower(power);
    }

    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource((LightSource)new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setSerialNumber(serialNumber);
    }

    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        DichroicRef dichroic_reference = new DichroicRef();
        dichroic_reference.setID(dichroic);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), (Reference)dichroic_reference);
    }

    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        EmissionFilterRef emissionFilterList_reference = new EmissionFilterRef();
        emissionFilterList_reference.setID(emissionFilter);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), (Reference)emissionFilterList_reference);
    }

    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        ExcitationFilterRef excitationFilterList_reference = new ExcitationFilterRef();
        excitationFilterList_reference.setID(excitationFilter);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), (Reference)excitationFilterList_reference);
    }

    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        o4.setAttenuation(attenuation);
    }

    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        o3.setAttenuation(attenuation);
    }

    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        this.model.addModelObject(id, (OMEModelObject)o4);
        o4.setID(id);
    }

    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        o3.setID(id);
    }

    public void setChannelLightSourceSettingsWavelength(PositiveInteger wavelength, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        o4.setWavelength(wavelength);
    }

    public void setMicrobeamManipulationLightSourceSettingsWavelength(PositiveInteger wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        o3.setWavelength(wavelength);
    }

    public void setLineDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setDescription(description);
    }

    public void setLineFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFill(fill);
    }

    public void setLineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFontSize(fontSize);
    }

    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Line)o3).setID(id);
    }

    public void setLineLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setLabel(label);
    }

    public void setLineName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setName(name);
    }

    public void setLineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStroke(stroke);
    }

    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setLineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeWidth(strokeWidth);
    }

    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheC(theC);
    }

    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheT(theT);
    }

    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheZ(theZ);
    }

    public void setLineTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTransform(transform);
    }

    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setX1(x1);
    }

    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setX2(x2);
    }

    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setY1(y1);
    }

    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setY2(y2);
    }

    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        o2.setDescription(description);
    }

    public void setListAnnotationID(String id, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setDescription(description);
    }

    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setValue(value);
    }

    public void setMaskDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setDescription(description);
    }

    public void setMaskFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFill(fill);
    }

    public void setMaskFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFontSize(fontSize);
    }

    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Mask)o3).setID(id);
    }

    public void setMaskLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setLabel(label);
    }

    public void setMaskName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setName(name);
    }

    public void setMaskStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStroke(stroke);
    }

    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setMaskStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeWidth(strokeWidth);
    }

    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheC(theC);
    }

    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheT(theT);
    }

    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheZ(theZ);
    }

    public void setMaskTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTransform(transform);
    }

    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setHeight(height);
    }

    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setWidth(width);
    }

    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setX(x);
    }

    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setY(y);
    }

    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference((OMEModelObject)this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex), (Reference)experimenter_reference);
    }

    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        ROIRef roiList_reference = new ROIRef();
        roiList_reference.setID(roi);
        this.model.addReference((OMEModelObject)this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex), (Reference)roiList_reference);
    }

    public void setMicrobeamManipulationType(MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        o2.setType(type);
    }

    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setLotNumber(lotNumber);
    }

    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setManufacturer(manufacturer);
    }

    public void setMicroscopeModel(String model, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setModel(model);
    }

    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setSerialNumber(serialNumber);
    }

    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setType(type);
    }

    public void setOTFFilterSetRef(String filterSet, int instrumentIndex, int OTFIndex) {
        FilterSetRef filterSet_reference = new FilterSetRef();
        filterSet_reference.setID(filterSet);
        this.model.addReference((OMEModelObject)this.root.getInstrument(instrumentIndex).getOTF(OTFIndex), (Reference)filterSet_reference);
    }

    public void setOTFID(String id, int instrumentIndex, int OTFIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        OTF o2 = o1.getOTF(OTFIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int OTFIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        OTF o2 = o1.getOTF(OTFIndex);
        o2.setOpticalAxisAveraged(opticalAxisAveraged);
    }

    public void setOTFSizeX(PositiveInteger sizeX, int instrumentIndex, int OTFIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        OTF o2 = o1.getOTF(OTFIndex);
        o2.setSizeX(sizeX);
    }

    public void setOTFSizeY(PositiveInteger sizeY, int instrumentIndex, int OTFIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        OTF o2 = o1.getOTF(OTFIndex);
        o2.setSizeY(sizeY);
    }

    public void setOTFType(PixelType type, int instrumentIndex, int OTFIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        OTF o2 = o1.getOTF(OTFIndex);
        o2.setType(type);
    }

    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setCalibratedMagnification(calibratedMagnification);
    }

    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setCorrection(correction);
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setObjectiveImmersion(Immersion immersion, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setImmersion(immersion);
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setIris(iris);
    }

    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setLensNA(lensNA);
    }

    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setModel(model);
    }

    public void setObjectiveNominalMagnification(PositiveInteger nominalMagnification, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setNominalMagnification(nominalMagnification);
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setObjectiveWorkingDistance(Double workingDistance, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setWorkingDistance(workingDistance);
    }

    public void setImageObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setCorrectionCollar(correctionCollar);
    }

    public void setOTFObjectiveSettingsCorrectionCollar(Double correctionCollar, int instrumentIndex, int OTFIndex) {
        OTF o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        if ((o2 = o1.getOTF(OTFIndex)).getObjectiveSettings() == null) {
            o2.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o3 = o2.getObjectiveSettings();
        o3.setCorrectionCollar(correctionCollar);
    }

    public void setImageObjectiveSettingsID(String id, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setOTFObjectiveSettingsID(String id, int instrumentIndex, int OTFIndex) {
        OTF o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        if ((o2 = o1.getOTF(OTFIndex)).getObjectiveSettings() == null) {
            o2.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o3 = o2.getObjectiveSettings();
        this.model.addModelObject(id, (OMEModelObject)o3);
        o3.setID(id);
    }

    public void setImageObjectiveSettingsMedium(Medium medium, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setMedium(medium);
    }

    public void setOTFObjectiveSettingsMedium(Medium medium, int instrumentIndex, int OTFIndex) {
        OTF o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        if ((o2 = o1.getOTF(OTFIndex)).getObjectiveSettings() == null) {
            o2.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o3 = o2.getObjectiveSettings();
        o3.setMedium(medium);
    }

    public void setImageObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setRefractiveIndex(refractiveIndex);
    }

    public void setOTFObjectiveSettingsRefractiveIndex(Double refractiveIndex, int instrumentIndex, int OTFIndex) {
        OTF o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfOTFList() == OTFIndex) {
            o1.addOTF(new OTF());
        }
        if ((o2 = o1.getOTF(OTFIndex)).getObjectiveSettings() == null) {
            o2.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o3 = o2.getObjectiveSettings();
        o3.setRefractiveIndex(refractiveIndex);
    }

    public void setPathDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setDescription(description);
    }

    public void setPathFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setFill(fill);
    }

    public void setPathFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setFontSize(fontSize);
    }

    public void setPathID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Path)o3).setID(id);
    }

    public void setPathLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setLabel(label);
    }

    public void setPathName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setName(name);
    }

    public void setPathStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setStroke(stroke);
    }

    public void setPathStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setPathStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setStrokeWidth(strokeWidth);
    }

    public void setPathTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setTheC(theC);
    }

    public void setPathTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setTheT(theT);
    }

    public void setPathTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setTheZ(theZ);
    }

    public void setPathTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setTransform(transform);
    }

    public void setPathDefinition(String definition, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Path());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Path)o3).setDefinition(definition);
    }

    public void setPixelsAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels(), (Reference)annotationList_reference);
    }

    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setDimensionOrder(dimensionOrder);
    }

    public void setPixelsID(String id, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setPixelsPhysicalSizeX(Double physicalSizeX, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeX(physicalSizeX);
    }

    public void setPixelsPhysicalSizeY(Double physicalSizeY, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeY(physicalSizeY);
    }

    public void setPixelsPhysicalSizeZ(Double physicalSizeZ, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeZ(physicalSizeZ);
    }

    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeC(sizeC);
    }

    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeT(sizeT);
    }

    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeX(sizeX);
    }

    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeY(sizeY);
    }

    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeZ(sizeZ);
    }

    public void setPixelsTimeIncrement(Double timeIncrement, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setTimeIncrement(timeIncrement);
    }

    public void setPixelsType(PixelType type, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setType(type);
    }

    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getImage(imageIndex).getPixels().getPlane(planeIndex), (Reference)annotationList_reference);
    }

    public void setPlaneDeltaT(Double deltaT, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setDeltaT(deltaT);
    }

    public void setPlaneExposureTime(Double exposureTime, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setExposureTime(exposureTime);
    }

    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setHashSHA1(hashSHA1);
    }

    public void setPlanePositionX(Double positionX, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionX(positionX);
    }

    public void setPlanePositionY(Double positionY, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionY(positionY);
    }

    public void setPlanePositionZ(Double positionZ, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionZ(positionZ);
    }

    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheC(theC);
    }

    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheT(theT);
    }

    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheZ(theZ);
    }

    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex), (Reference)annotationList_reference);
    }

    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setColumnNamingConvention(columnNamingConvention);
    }

    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setColumns(columns);
    }

    public void setPlateDescription(String description, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setDescription(description);
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setExternalIdentifier(externalIdentifier);
    }

    public void setPlateID(String id, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setPlateName(String name, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setName(name);
    }

    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setRowNamingConvention(rowNamingConvention);
    }

    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setRows(rows);
    }

    public void setPlateScreenRef(String screen, int plateIndex, int screenRefIndex) {
        ScreenRef screenList_reference = new ScreenRef();
        screenList_reference.setID(screen);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex), (Reference)screenList_reference);
    }

    public void setPlateStatus(String status, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setStatus(status);
    }

    public void setPlateWellOriginX(Double wellOriginX, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setWellOriginX(wellOriginX);
    }

    public void setPlateWellOriginY(Double wellOriginY, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setWellOriginY(wellOriginY);
    }

    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex), (Reference)annotationList_reference);
    }

    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setDescription(description);
    }

    public void setPlateAcquisitionEndTime(String endTime, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setEndTime(endTime);
    }

    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setMaximumFieldCount(maximumFieldCount);
    }

    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setName(name);
    }

    public void setPlateAcquisitionStartTime(String startTime, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setStartTime(startTime);
    }

    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        WellSampleRef wellSampleList_reference = new WellSampleRef();
        wellSampleList_reference.setID(wellSample);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex), (Reference)wellSampleList_reference);
    }

    public void setPointDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setDescription(description);
    }

    public void setPointFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFill(fill);
    }

    public void setPointFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFontSize(fontSize);
    }

    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Point)o3).setID(id);
    }

    public void setPointLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setLabel(label);
    }

    public void setPointName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setName(name);
    }

    public void setPointStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStroke(stroke);
    }

    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setPointStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeWidth(strokeWidth);
    }

    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheC(theC);
    }

    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheT(theT);
    }

    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheZ(theZ);
    }

    public void setPointTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTransform(transform);
    }

    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setX(x);
    }

    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setY(y);
    }

    public void setPolylineDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setDescription(description);
    }

    public void setPolylineFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFill(fill);
    }

    public void setPolylineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFontSize(fontSize);
    }

    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Polyline)o3).setID(id);
    }

    public void setPolylineLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setLabel(label);
    }

    public void setPolylineName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setName(name);
    }

    public void setPolylineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStroke(stroke);
    }

    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setPolylineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeWidth(strokeWidth);
    }

    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheC(theC);
    }

    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheT(theT);
    }

    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheZ(theZ);
    }

    public void setPolylineTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTransform(transform);
    }

    public void setPolylineClosed(Boolean closed, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setClosed(closed);
    }

    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setPoints(points);
    }

    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getProject(projectIndex), (Reference)annotationList_reference);
    }

    public void setProjectDescription(String description, int projectIndex) {
        OME o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        o1.setDescription(description);
    }

    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference((OMEModelObject)this.root.getProject(projectIndex), (Reference)experimenter_reference);
    }

    public void setProjectGroupRef(String group, int projectIndex) {
        GroupRef group_reference = new GroupRef();
        group_reference.setID(group);
        this.model.addReference((OMEModelObject)this.root.getProject(projectIndex), (Reference)group_reference);
    }

    public void setProjectID(String id, int projectIndex) {
        OME o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setProjectName(String name, int projectIndex) {
        OME o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        o1.setName(name);
    }

    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getROI(ROIIndex), (Reference)annotationList_reference);
    }

    public void setROIDescription(String description, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setDescription(description);
    }

    public void setROIID(String id, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setROIName(String name, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setName(name);
    }

    public void setROINamespace(String namespace, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setNamespace(namespace);
    }

    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getScreen(screenIndex).getReagent(reagentIndex), (Reference)annotationList_reference);
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setDescription(description);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setName(name);
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setReagentIdentifier(reagentIdentifier);
    }

    public void setRectangleDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setDescription(description);
    }

    public void setRectangleFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFill(fill);
    }

    public void setRectangleFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFontSize(fontSize);
    }

    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Rectangle)o3).setID(id);
    }

    public void setRectangleLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setLabel(label);
    }

    public void setRectangleName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setName(name);
    }

    public void setRectangleStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStroke(stroke);
    }

    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setRectangleStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeWidth(strokeWidth);
    }

    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheC(theC);
    }

    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheT(theT);
    }

    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheZ(theZ);
    }

    public void setRectangleTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTransform(transform);
    }

    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setHeight(height);
    }

    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setWidth(width);
    }

    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setX(x);
    }

    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setY(y);
    }

    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getScreen(screenIndex), (Reference)annotationList_reference);
    }

    public void setScreenDescription(String description, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setDescription(description);
    }

    public void setScreenID(String id, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        this.model.addModelObject(id, (OMEModelObject)o1);
        o1.setID(id);
    }

    public void setScreenName(String name, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setName(name);
    }

    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        PlateRef plateList_reference = new PlateRef();
        plateList_reference.setID(plate);
        this.model.addReference((OMEModelObject)this.root.getScreen(screenIndex), (Reference)plateList_reference);
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setProtocolDescription(protocolDescription);
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setProtocolIdentifier(protocolIdentifier);
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setReagentSetDescription(reagentSetDescription);
    }

    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setReagentSetIdentifier(reagentSetIdentifier);
    }

    public void setScreenType(String type, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setType(type);
    }

    public void setStageLabelName(String name, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setName(name);
    }

    public void setStageLabelX(Double x, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setX(x);
    }

    public void setStageLabelY(Double y, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setY(y);
    }

    public void setStageLabelZ(Double z, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setZ(z);
    }

    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setDescription(description);
    }

    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setValue(value);
    }

    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setDescription(description);
    }

    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setValue(value);
    }

    public void setTextDescription(String description, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setDescription(description);
    }

    public void setTextFill(Integer fill, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setFill(fill);
    }

    public void setTextFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setFontSize(fontSize);
    }

    public void setTextID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        ((Text)o3).setID(id);
    }

    public void setTextLabel(String label, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setLabel(label);
    }

    public void setTextName(String name, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setName(name);
    }

    public void setTextStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setStroke(stroke);
    }

    public void setTextStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setTextStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setStrokeWidth(strokeWidth);
    }

    public void setTextTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setTheC(theC);
    }

    public void setTextTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setTheT(theT);
    }

    public void setTextTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setTheZ(theZ);
    }

    public void setTextTransform(String transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setTransform(transform);
    }

    public void setTextValue(String value, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setValue(value);
    }

    public void setTextX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setX(x);
    }

    public void setTextY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape((Shape)new Text());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Text)o3).setY(y);
    }

    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstC(firstC);
    }

    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstT(firstT);
    }

    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstZ(firstZ);
    }

    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setIFD(ifd);
    }

    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setPlaneCount(planeCount);
    }

    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setDescription(description);
    }

    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setTimestampAnnotationValue(String value, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setValue(value);
    }

    public void setTransmittanceRangeCutIn(PositiveInteger cutIn, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutIn(cutIn);
    }

    public void setTransmittanceRangeCutInTolerance(NonNegativeInteger cutInTolerance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutInTolerance(cutInTolerance);
    }

    public void setTransmittanceRangeCutOut(PositiveInteger cutOut, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutOut(cutOut);
    }

    public void setTransmittanceRangeCutOutTolerance(NonNegativeInteger cutOutTolerance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutOutTolerance(cutOutTolerance);
    }

    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setTransmittance(transmittance);
    }

    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
        TiffData o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        if ((o3 = o2.getTiffData(tiffDataIndex)).getUUID() == null) {
            o3.setUUID(new UUID());
        }
        UUID o4 = o3.getUUID();
        o4.setFileName(fileName);
    }

    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex).getWell(wellIndex), (Reference)annotationList_reference);
    }

    public void setWellColor(Integer color, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setColor(color);
    }

    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setColumn(column);
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setExternalDescription(externalDescription);
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setExternalIdentifier(externalIdentifier);
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        ReagentRef reagent_reference = new ReagentRef();
        reagent_reference.setID(reagent);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex).getWell(wellIndex), (Reference)reagent_reference);
    }

    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setRow(row);
    }

    public void setWellStatus(String status, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setStatus(status);
    }

    public void setWellSampleAnnotationRef(String annotation, int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex), (Reference)annotationList_reference);
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        this.model.addModelObject(id, (OMEModelObject)o3);
        o3.setID(id);
    }

    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        ImageRef image_reference = new ImageRef();
        image_reference.setID(image);
        this.model.addReference((OMEModelObject)this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex), (Reference)image_reference);
    }

    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setIndex(index);
    }

    public void setWellSamplePositionX(Double positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setPositionX(positionX);
    }

    public void setWellSamplePositionY(Double positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setPositionY(positionY);
    }

    public void setWellSampleTimepoint(String timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setTimepoint(timepoint);
    }

    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationList_reference = new AnnotationRef();
        annotationList_reference.setID(annotation);
        this.model.addReference((OMEModelObject)this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex), (Reference)annotationList_reference);
    }

    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setDescription(description);
    }

    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        this.model.addModelObject(id, (OMEModelObject)o2);
        o2.setID(id);
    }

    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setValue(value);
    }
}

