/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class VarianFDFReader
extends FormatReader {
    private Vector<String> files = new Vector();
    private long[] pixelOffsets;
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private double originX;
    private double originY;
    private double originZ;
    private String[] units;

    public VarianFDFReader() {
        super("Varian FDF", "fdf");
        this.domains = new String[]{"Medical Imaging"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            return null;
        }
        if (this.files.size() == 0) {
            return new String[]{this.currentId};
        }
        return this.files.toArray(new String[this.files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.files.size() > 0) {
            this.in = new RandomAccessInputStream(this.files.get(no));
            this.in.order(this.isLittleEndian());
        }
        this.in.seek(this.pixelOffsets[no]);
        this.readPlane(this.in, x, y, w, h, buf);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        byte[] rowBuf = new byte[w * bpp];
        for (int row = 0; row < h / 2; ++row) {
            int src = row * rowBuf.length;
            int dest = (h - row - 1) * rowBuf.length;
            System.arraycopy(buf, src, rowBuf, 0, rowBuf.length);
            System.arraycopy(buf, dest, buf, src, rowBuf.length);
            System.arraycopy(rowBuf, 0, buf, dest, rowBuf.length);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffsets = null;
            this.files.clear();
            this.pixelSizeX = 0.0;
            this.pixelSizeY = 0.0;
            this.pixelSizeZ = 0.0;
            this.originX = 0.0;
            this.originY = 0.0;
            this.originZ = 0.0;
            this.units = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.parseFDF(id);
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        this.core[0].dimensionOrder = "XYTZC";
        this.pixelOffsets = new long[this.getImageCount()];
        int planeSize = FormatTools.getPlaneSize(this);
        for (int i = 0; i < this.pixelOffsets.length; ++i) {
            if (this.files.size() > 0) {
                this.in = new RandomAccessInputStream(this.files.get(i));
                this.pixelOffsets[i] = this.in.length() - (long)planeSize;
                continue;
            }
            this.pixelOffsets[i] = this.in.length() - (long)(planeSize * (this.getImageCount() - i));
        }
        boolean minMetadata = this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, !minMetadata);
        if (!minMetadata) {
            store.setPixelsPhysicalSizeX(this.pixelSizeX, 0);
            store.setPixelsPhysicalSizeY(this.pixelSizeY, 0);
            store.setPixelsPhysicalSizeZ(this.pixelSizeZ, 0);
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlanePositionX(this.originX, 0, i);
                store.setPlanePositionY(this.originY, 0, i);
                store.setPlanePositionZ(this.originZ, 0, i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFDF(String file) throws FormatException, IOException {
        String line;
        this.in = new RandomAccessInputStream(file);
        boolean storedFloats = false;
        boolean multifile = false;
        while ((line = this.in.readLine().trim()).length() != 0) {
            String[] values;
            if (line.startsWith("#")) continue;
            int space = line.indexOf(" ");
            int eq = line.indexOf("=");
            String type = line.substring(0, space).trim();
            String var = line.substring(space, eq).trim();
            String value = line.substring(eq + 1, line.indexOf(";")).trim();
            if (var.equals("*storage")) {
                storedFloats = value.equals("\"float\"");
            }
            if (var.equals("bits")) {
                this.core[0].bitsPerPixel = Integer.parseInt(value);
                if (value.equals("8")) {
                    this.core[0].pixelType = 1;
                } else if (value.equals("16")) {
                    this.core[0].pixelType = 3;
                } else {
                    if (!value.equals("32")) throw new FormatException("Unsupported bits: " + value);
                    this.core[0].pixelType = storedFloats ? 6 : 5;
                }
            } else if (var.equals("matrix[]")) {
                values = this.parseArray(value);
                this.core[0].sizeX = (int)Double.parseDouble(values[0]);
                this.core[0].sizeY = (int)Double.parseDouble(values[1]);
                if (values.length > 2) {
                    this.core[0].sizeZ = (int)Double.parseDouble(values[2]);
                }
            } else if (var.equals("slices")) {
                this.core[0].sizeZ = Integer.parseInt(value);
                multifile = true;
            } else if (var.equals("echoes")) {
                this.core[0].sizeT = Integer.parseInt(value);
                multifile = true;
            } else if (var.equals("span[]")) {
                values = this.parseArray(value);
                if (values.length > 0) {
                    this.pixelSizeX = this.computePhysicalSize(this.getSizeX(), values[0], this.units[0]);
                }
                if (values.length > 1) {
                    this.pixelSizeY = this.computePhysicalSize(this.getSizeY(), values[1], this.units[1]);
                }
                if (values.length > 2) {
                    this.pixelSizeZ = this.computePhysicalSize(this.getSizeZ(), values[2], this.units[2]);
                }
            } else if (var.equals("origin[]")) {
                values = this.parseArray(value);
                if (values.length > 0) {
                    this.originX = this.computePhysicalSize(1, values[0], this.units[0]);
                    this.addGlobalMeta("X position for position #1", this.originX);
                }
                if (values.length > 1) {
                    this.originY = this.computePhysicalSize(1, values[1], this.units[1]);
                    this.addGlobalMeta("Y position for position #1", this.originY);
                }
                if (values.length > 2) {
                    this.originZ = this.computePhysicalSize(1, values[2], this.units[2]);
                    this.addGlobalMeta("Z position for position #1", this.originZ);
                }
            } else if (var.equals("*abscissa[]")) {
                this.units = this.parseArray(value);
            } else if (var.equals("bigendian")) {
                this.core[0].littleEndian = value.equals("0");
                this.in.order(this.isLittleEndian());
            }
            this.addGlobalMeta(var, value);
        }
        if (!multifile || this.files.size() != 0) return;
        Location thisFile = new Location(file).getAbsoluteFile();
        Location parent = thisFile.getParentFile();
        Object[] list = parent.list(true);
        Arrays.sort(list);
        for (Object f : list) {
            if (!VarianFDFReader.checkSuffix((String)f, "fdf") || ((String)f).length() != thisFile.getName().length()) continue;
            this.files.add(new Location(parent, (String)f).getAbsolutePath());
        }
    }

    private String[] parseArray(String value) {
        value = value.replaceAll("[{}]", "");
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].replaceAll("\"", "");
            values[i] = values[i].trim();
        }
        return values;
    }

    private double computePhysicalSize(int length, String physicalLength, String unit) {
        double size = Double.parseDouble(physicalLength) / (double)length;
        if (unit.equals("cm")) {
            size *= 1000.0;
        }
        return size;
    }
}

