/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class VGSAMReader
extends FormatReader {
    public static final String VG_MAGIC_STRING = "VGS";
    public static final int PIXEL_OFFSET = 368;

    public VGSAMReader() {
        super("VG SAM", "dti");
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 3;
        if (!FormatTools.validStream(stream, 3, false)) {
            return false;
        }
        return stream.readString(3).indexOf(VG_MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(368L);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.seek(348L);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.in.skipBytes(4);
        int bpp = this.in.readInt();
        this.addGlobalMeta("Bytes per pixel", bpp);
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bpp, false, bpp == 4);
        this.core[0].littleEndian = false;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

