/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphTiffReader
extends BaseTiffReader {
    private static final String DATE_FORMAT = "yyyyMMdd HH:mm:ss.SSS";

    public MetamorphTiffReader() {
        super("Metamorph TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        String comment = tp.getComment();
        if (comment == null) {
            return false;
        }
        return (comment = comment.trim()).startsWith("<MetaData>") && comment.endsWith("</MetaData>");
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        MetamorphHandler handler = new MetamorphHandler(this.getGlobalMetadata());
        for (IFD ifd : this.ifds) {
            XMLTools.parseXML(ifd.getComment(), (DefaultHandler)handler);
        }
        this.core[0].sizeC = 0;
        Vector<String> timestamps = handler.getTimestamps();
        Vector<Integer> wavelengths = handler.getWavelengths();
        Vector<Double> zPositions = handler.getZPositions();
        Vector<Double> exposures = handler.getExposures();
        Vector<Integer> uniqueC = new Vector<Integer>();
        for (Integer c : wavelengths) {
            if (uniqueC.contains(c)) continue;
            uniqueC.add(c);
        }
        int effectiveC = uniqueC.size();
        if (effectiveC == 0) {
            effectiveC = 1;
        }
        this.core[0].sizeC = effectiveC * ((IFD)this.ifds.get(0)).getSamplesPerPixel();
        Vector<Double> uniqueZ = new Vector<Double>();
        for (Double z : zPositions) {
            if (uniqueZ.contains(z)) continue;
            uniqueZ.add(z);
        }
        this.core[0].sizeZ = uniqueZ.size();
        this.core[0].sizeT = this.ifds.size() / (this.getSizeZ() * effectiveC);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        store.setImageName(handler.getImageName(), 0);
        String date = DateTools.formatDate(handler.getDate(), "yyyy-MM-dd'T'HH:mm:ss");
        store.setImageAcquiredDate(date, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            for (i = 0; i < timestamps.size(); ++i) {
                long timestamp = DateTools.getTime(timestamps.get(i), DATE_FORMAT);
                this.addGlobalMeta("timestamp " + i, timestamp);
            }
            for (i = 0; i < exposures.size(); ++i) {
                this.addGlobalMeta("exposure time " + i + " (ms)", exposures.get(i).floatValue() * 1000.0f);
            }
            long startDate = 0L;
            if (timestamps.size() > 0) {
                startDate = DateTools.getTime(timestamps.get(0), DATE_FORMAT);
            }
            store.setImageDescription("", 0);
            for (int i2 = 0; i2 < this.getImageCount(); ++i2) {
                int[] coords = this.getZCTCoords(i2);
                if (coords[2] < timestamps.size()) {
                    String stamp = timestamps.get(coords[2]);
                    long ms = DateTools.getTime(stamp, DATE_FORMAT);
                    store.setPlaneDeltaT((double)(ms - startDate) / 1000.0, 0, i2);
                }
                if (i2 >= exposures.size()) continue;
                store.setPlaneExposureTime(exposures.get(i2), 0, i2);
            }
            store.setImagingEnvironmentTemperature(handler.getTemperature(), 0);
            store.setPixelsPhysicalSizeX(handler.getPixelSizeX(), 0);
            store.setPixelsPhysicalSizeY(handler.getPixelSizeY(), 0);
        }
    }
}

