/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.Log;
import eu.kostia.gtkjfilechooser.ui.GtkFileChooserUI;
import eu.kostia.gtkjfilechooser.xbel.RecentlyUsedManager;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.SwingWorker;

public class RecentlyUsedFileWorker
extends SwingWorker<Void, Void>
implements PropertyChangeListener {
    private static final int NUMBER_OF_RECENT_FILES = 30;
    private RecentlyUsedManager recentManager;
    private final GtkFileChooserUI fileChooserUI;

    public RecentlyUsedFileWorker(GtkFileChooserUI fileChooserUI) {
        this.fileChooserUI = fileChooserUI;
        this.addPropertyChangeListener(this);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.fileChooserUI.getFileChooser().setCursor(Cursor.getPredefinedCursor(3));
        if (this.recentManager == null) {
            this.recentManager = new RecentlyUsedManager(30);
        }
        List<File> fileEntries = this.recentManager.getRecentFiles();
        this.fileChooserUI.getRecentlyUsedPane().getModel().clear();
        for (File file : fileEntries) {
            if (!this.fileChooserUI.getFileChooser().getFileFilter().accept(file)) continue;
            this.fileChooserUI.getRecentlyUsedPane().addFile(file);
        }
        return null;
    }

    @Override
    protected void done() {
        this.fileChooserUI.getFileChooser().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Log.debug(evt);
    }
}

