/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.ActionDispatcher;
import eu.kostia.gtkjfilechooser.BasicActionDispatcher;
import eu.kostia.gtkjfilechooser.DateUtil;
import eu.kostia.gtkjfilechooser.FreeDesktopUtil;
import eu.kostia.gtkjfilechooser.GtkFileChooserSettings;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.ui.FileFindAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class FilesListPane
extends JComponent
implements ActionDispatcher {
    public static final Color PEARL_GRAY = new Color(238, 238, 238);
    public static final Color PEARL_GRAY_LIGHT = new Color(221, 221, 221);
    private static final String FILE_NAME_COLUMN_ID = "Name";
    private static final int FILE_NAME_COLUMN_INDEX = 0;
    private static final String FILE_SIZE_COLUMN_ID = "Size";
    private static final int FILE_SIZE_COLUMN_WIDTH = 100;
    private static final String FILE_DATE_COLUMN_ID = "Modified";
    private static final int FILE_DATE_COLUMN_WIDTH = 125;
    public static final String SELECTED = "selected";
    public static final int SELECTED_ID = 1;
    public static final String DOUBLE_CLICK = "double_click";
    public static final int DOUBLE_CLICK_ID = 2;
    public static final String ENTER_PRESSED = "enter pressed";
    public static final int ENTER_PRESSED_ID = 3;
    private static final long serialVersionUID = 1L;
    protected JTable table;
    private ActionDispatcher actionDispatcher = new BasicActionDispatcher();
    private boolean filesSelectable = true;
    private FileView fileView;

    public FilesListPane(FileView fileView) {
        this(new ArrayList<File>(), fileView);
    }

    public FilesListPane(List<File> fileEntries, FileView fileView) {
        this.fileView = fileView;
        this.setLayout(new BorderLayout());
        this.table = new JTable(){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                File file = (File)this.getValueAt(row, 0);
                if (FilesListPane.this.isRowEnabled(file)) {
                    super.changeSelection(row, column, toggle, extend);
                }
            }
        };
        this.table.setColumnModel(new FilesListTableColumnModel());
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setBackground(UIManager.getColor("TextPane.background"));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        Boolean showSizeColumn = GtkFileChooserSettings.get().getShowSizeColumn();
        this.setModel(fileEntries, showSizeColumn);
        this.table.setDefaultRenderer(Object.class, new FilesListRenderer());
        this.table.setRowSelectionAllowed(true);
        this.table.setShowGrid(false);
        this.table.getTableHeader().setResizingAllowed(true);
        this.table.setRowHeight(23);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ActionEvent event = null;
                event = e.getClickCount() == 2 ? new ActionEvent(FilesListPane.this, 2, FilesListPane.DOUBLE_CLICK) : new ActionEvent(FilesListPane.this, 1, FilesListPane.SELECTED);
                FilesListPane.this.fireActionEvent(event);
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char ch = e.getKeyChar();
                if (ch == '\n') {
                    FilesListPane.this.fireActionEvent(new ActionEvent(FilesListPane.this, 3, FilesListPane.ENTER_PRESSED));
                }
            }
        });
        new FileFindAction().install(this.table);
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public void setFileView(FileView fileView) {
        if (fileView == null) {
            throw new IllegalArgumentException("FileView cannot be null");
        }
        this.fileView = fileView;
    }

    public void setShowSizeColumn(boolean showSizeColumn) {
        GtkFileChooserSettings.get().setShowSizeColumn(showSizeColumn);
        this.setModel(new ArrayList<File>(), showSizeColumn);
        this.table.createDefaultColumnsFromModel();
    }

    public void uninstallUI() {
        this.table = null;
        this.removeAllActionListeners();
    }

    public void setSelectionMode(int selectionMode) {
        this.table.setSelectionMode(selectionMode);
    }

    public void addFile(File entry) {
        FilesListTableModel dataModel = (FilesListTableModel)this.table.getModel();
        dataModel.addFile(entry);
    }

    public void setFilesSelectable(boolean filesSelectable) {
        this.filesSelectable = filesSelectable;
    }

    public void setModel(List<File> fileEntries, Boolean showSizeColumn) {
        FilesListTableModel dataModel = new FilesListTableModel(fileEntries, showSizeColumn);
        this.table.setModel(dataModel);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        FilesListTableRowSorter sorter = new FilesListTableRowSorter();
        sorter.setSortKeys(sortKeys);
        this.table.setRowSorter(sorter);
        this.createColumnsFromModel();
    }

    private void createColumnsFromModel() {
        FilesListTableModel m = (FilesListTableModel)this.table.getModel();
        if (m != null) {
            TableColumnModel cm = this.table.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < m.getColumnCount(); ++i) {
                TableColumn newColumn = new TableColumn(i);
                newColumn.setIdentifier(m.getColumnId(i));
                this.table.addColumn(newColumn);
            }
        }
    }

    public FilesListTableModel getModel() {
        return (FilesListTableModel)this.table.getModel();
    }

    public boolean getShowSizeColumn() {
        return this.getModel().getShowSizeColumn();
    }

    private boolean isRowEnabled(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        return !file.isDirectory() && this.filesSelectable;
    }

    public File getSelectedFile() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (File)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(row), 0);
    }

    public File[] getSelectedFiles() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        File[] selectesFiles = new File[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int rowIndex = rows[i];
            selectesFiles[i] = (File)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(rowIndex), 0);
        }
        return selectesFiles;
    }

    public void clearSelection() {
        this.table.getSelectionModel().clearSelection();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionDispatcher.addActionListener(l);
    }

    @Override
    public void fireActionEvent(ActionEvent e) {
        this.actionDispatcher.fireActionEvent(e);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionDispatcher.removeActionListener(l);
    }

    @Override
    public void removeAllActionListeners() {
        this.actionDispatcher.removeAllActionListeners();
    }

    protected class FilesListTableRowSorter
    extends TableRowSorter<FilesListTableModel> {
        private static final String PREFIX_FIRST = "01_";
        private static final String PREFIX_LAST = "09_";
        private static final String PREFIX_BEFORE_FIRST = "00_";
        private static final String PREFIX_AFTER_LAST = "99_";

        public FilesListTableRowSorter() {
            super((FilesListTableModel)FilesListPane.this.table.getModel());
        }

        @Override
        protected boolean useToString(int column) {
            return true;
        }

        @Override
        public TableStringConverter getStringConverter() {
            return new TableStringConverter(){

                @Override
                public String toString(TableModel model, int row, int column) {
                    return FilesListTableRowSorter.this.toString(model, row, column);
                }
            };
        }

        private String toString(TableModel model, int row, int column) {
            Object value;
            File file = (File)model.getValueAt(row, 0);
            String sortString = null;
            if (file != null) {
                if (file.isDirectory()) {
                    sortString = this.isAscending() ? PREFIX_FIRST : PREFIX_LAST;
                } else {
                    String string = sortString = this.isAscending() ? PREFIX_LAST : PREFIX_FIRST;
                }
            }
            if ((value = model.getValueAt(row, column)) == null) {
                sortString = this.isAscending() ? PREFIX_BEFORE_FIRST : PREFIX_AFTER_LAST;
            } else if (value instanceof File) {
                sortString = sortString + file.getName().toLowerCase();
            } else if (value instanceof Long) {
                Long size = (Long)value;
                size = size > 0L ? size : -1L * size - 1L;
                sortString = String.format("%s%019d", sortString, size);
            } else if (value instanceof Date) {
                Date modified = (Date)value;
                sortString = String.format("%s%019d", sortString, modified.getTime());
            }
            return sortString.toLowerCase();
        }

        private boolean isAscending() {
            if (this.getSortKeys().size() > 0) {
                return this.getSortKeys().get(0).getSortOrder() == SortOrder.ASCENDING;
            }
            return true;
        }
    }

    private class FilesListTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        private FilesListTableColumnModel() {
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            TableColumn col = super.getColumn(columnIndex);
            String columnId = col.getIdentifier().toString();
            if (FilesListPane.FILE_SIZE_COLUMN_ID.equals(columnId)) {
                col.setPreferredWidth(100);
            } else if (FilesListPane.FILE_DATE_COLUMN_ID.equals(columnId)) {
                col.setPreferredWidth(125);
            } else {
                int offset = 125;
                if (FilesListPane.this.table.getModel().getColumnCount() == 3) {
                    offset += 100;
                }
                col.setPreferredWidth(this.getTotalColumnWidth() - offset);
            }
            return col;
        }
    }

    protected class FilesListRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected FilesListRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            File file;
            this.setIcon(null);
            if (value == null) {
                this.setText("");
            } else if (value instanceof File) {
                file = (File)value;
                this.setText(FilesListPane.this.fileView.getName(file));
                this.setIcon(FilesListPane.this.fileView.getIcon(file));
            } else if (value instanceof Long) {
                Long bytes = (Long)value;
                this.setText(bytes >= 0L ? FreeDesktopUtil.humanreadble(bytes, 0) : "");
            } else if (value instanceof Date) {
                Date date = (Date)value;
                this.setText(DateUtil.toPrettyFormat(date));
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                Color rowcolor;
                this.setForeground(table.getForeground());
                Color color = rowcolor = row % 2 == 0 ? table.getBackground() : PEARL_GRAY;
                if (FilesListPane.this.getShowSizeColumn() && column == 0) {
                    rowcolor = row % 2 == 0 ? PEARL_GRAY : PEARL_GRAY_LIGHT;
                }
                this.setBackground(rowcolor);
            }
            if (table.getValueAt(row, 0) instanceof File) {
                file = (File)table.getValueAt(row, 0);
                this.setToolTipText(FilesListPane.this.fileView.getDescription(file));
                this.setEnabled(FilesListPane.this.isRowEnabled(file));
            }
            return this;
        }
    }

    protected class FilesListTableModel
    extends AbstractTableModel
    implements Serializable,
    TableModelListener {
        private static final long serialVersionUID = 1L;
        private List<Object[]> data = new ArrayList<Object[]>();
        private String[] columnNames;
        private String[] columnIds;
        private boolean showSizeColumn;
        private int editableCellRowIndex = -1;

        public FilesListTableModel(List<File> fileEntries, boolean showSizeColumn) {
            this.showSizeColumn = showSizeColumn;
            this.addTableModelListener(this);
            this.columnIds = this.getShowSizeColumn() != false ? new String[]{FilesListPane.FILE_NAME_COLUMN_ID, FilesListPane.FILE_SIZE_COLUMN_ID, FilesListPane.FILE_DATE_COLUMN_ID} : new String[]{FilesListPane.FILE_NAME_COLUMN_ID, FilesListPane.FILE_DATE_COLUMN_ID};
            this.columnNames = new String[this.columnIds.length];
            for (int i = 0; i < this.columnIds.length; ++i) {
                String columnId = this.columnIds[i];
                this.columnNames[i] = I18N._(columnId);
            }
            for (File file : fileEntries) {
                this.addFileEntryInternal(file);
            }
        }

        private Boolean getShowSizeColumn() {
            return this.showSizeColumn;
        }

        public void clear() {
            this.data = new ArrayList<Object[]>();
            this.fireTableDataChanged();
        }

        private void addFileEntryInternal(File file) {
            Object[] row = new Object[this.getColumnCount()];
            row[0] = file;
            if (this.getShowSizeColumn().booleanValue()) {
                if (file != null) {
                    row[1] = file.isDirectory() ? Long.valueOf(file.list() != null ? (long)(-file.list().length) - 1L : -1L) : Long.valueOf(file.length());
                }
                row[2] = new Date(file.lastModified());
            } else {
                row[1] = new Date(file.lastModified());
            }
            this.data.add(row);
        }

        public void addFile(File entry) {
            this.addFileEntryInternal(entry);
            int row = this.getRowCount() - 1;
            this.fireTableRowsInserted(row, row);
        }

        void addEmtpyRow() {
            Object[] row = new Object[this.getColumnCount()];
            this.data.add(0, row);
            this.fireTableRowsInserted(0, 0);
            FilesListPane.this.table.scrollRectToVisible(FilesListPane.this.table.getCellRect(0, 0, true));
        }

        void removeEmtpyRow() {
            if (this.data != null && !this.data.isEmpty() && this.data.get(0)[0] == null) {
                this.data.remove(0);
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public void setEditableRow(int row) {
            this.editableCellRowIndex = row != -1 ? FilesListPane.this.table.convertRowIndexToModel(row) : -1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return row == this.editableCellRowIndex && column == 0;
        }

        @Override
        public int getColumnCount() {
            return this.getShowSizeColumn() != false ? 3 : 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            this.checkColumnIndex(col);
            return this.data.get(row)[col];
        }

        @Override
        public String getColumnName(int col) {
            this.checkColumnIndex(col);
            return this.columnNames[col];
        }

        public String getColumnId(int col) {
            this.checkColumnIndex(col);
            return this.columnIds[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            this.checkColumnIndex(col);
            if (!this.data.isEmpty()) {
                if (this.data.get(0)[col] != null) {
                    return this.data.get(0)[col].getClass();
                }
                if (this.data.size() > 1 && this.data.get(1) != null && this.data.get(1)[col] != null) {
                    return this.data.get(1)[col].getClass();
                }
            }
            return Object.class;
        }

        private void checkColumnIndex(int col) {
            if (col >= this.getColumnCount()) {
                throw new IllegalArgumentException(col + " greater the the column count");
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (FilesListPane.this.table.getRowSorter() != null) {
                FilesListPane.this.table.getRowSorter().allRowsChanged();
            }
        }
    }
}

