/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.GettextResource;
import java.util.Locale;

public class I18N {
    private static GettextResource resources = null;
    private static boolean resourcesNotFound = false;

    public static void init(Locale locale) {
        if (GettextResource.hasTranslation(locale, "gtk20")) {
            resources = new GettextResource(locale, "gtk20");
        } else if (GettextResource.hasTranslation(locale, "/usr/share/locale-langpack", "gtk20")) {
            resources = new GettextResource(locale, "/usr/share/locale-langpack", "gtk20");
        } else if (GettextResource.hasTranslation(locale, "/usr/share/locale-bundle", "gtk20")) {
            resources = new GettextResource(locale, "/usr/share/locale-bundle", "gtk20");
        } else {
            resourcesNotFound = true;
        }
    }

    public static final String _(String msgid) {
        return I18N.getString(msgid).replace("_", "");
    }

    public static final String _(String msgid, Object args) {
        return String.format(I18N._(msgid), args);
    }

    public static final int getMnemonic(String msgid) {
        String msg = I18N.getString(msgid);
        int indexOf = msg.indexOf(95);
        if (indexOf >= 0) {
            return msg.charAt(indexOf + 1);
        }
        return 0;
    }

    private static String getString(String msgid) {
        if (resourcesNotFound) {
            int indexOf = msgid.indexOf(124);
            if (indexOf < 0) {
                return msgid;
            }
            return msgid.substring(indexOf + 1);
        }
        if (resources == null) {
            I18N.init(Locale.getDefault());
        }
        return resources.getString(msgid);
    }

    static {
        I18N.init(Locale.getDefault());
    }
}

