/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class GtkVersion {
    static int gtkMajorVersion = 2;
    static int gtkMinorVersion = Short.MAX_VALUE;
    static int gtkMicroVersion = Short.MAX_VALUE;

    public static boolean check(int major, int minor, int micro) {
        return gtkMajorVersion > major || gtkMajorVersion == major && gtkMinorVersion > minor || gtkMajorVersion == major && gtkMinorVersion == minor && gtkMicroVersion >= micro;
    }

    public static String getCurrent() {
        return gtkMajorVersion + "." + gtkMinorVersion + "." + gtkMicroVersion;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(GtkVersion.getCurrent());
    }

    static {
        try {
            String[] files = new File("/usr/lib").list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("libgtk-x11-2.0.so.0.");
                }
            });
            if (files != null) {
                String lib = files[0];
                int i1 = lib.lastIndexOf(46);
                int i0 = lib.lastIndexOf(46, i1 - 1);
                String minor = lib.substring(i0 + 1, i1);
                String micro = lib.substring(i1 + 1);
                gtkMinorVersion = Integer.parseInt(minor) / 100;
                gtkMicroVersion = Integer.parseInt(micro);
            }
        }
        catch (Throwable e) {
            Log.debug(e.getMessage());
        }
    }
}

